/*
 * Copyright 1996 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: saml-errno.h,v 1.2 1996/08/18 09:37:40 bousch Exp $
 *
 * Error numbers
 */

#ifndef _SAML_ERRNO_H
#define _SAML_ERRNO_H

#define SE_MAX_ERROR	23
extern const char* saml_errlist[];
const char* saml_strerror(int errno);

#define SE_NO_ERROR	0	/* No error */
#define SE_ERROR	1	/* General error */
#define SE_WR_TYPE	2	/* Operand has wrong type */
#define SE_WR_SIZE	3	/* Array operand has wrong size */
#define SE_TCONFL	4	/* Operands have conflicting types */
#define SE_SCONFL	5	/* Array operands have conflicting sizes */
#define SE_ONSUPP	6	/* Operation not supported */
#define SE_TBL_FULL	7	/* Some static table is full */
#define SE_DIVZERO	8	/* Division by zero */
#define SE_OODOMAIN	9	/* Operand out of definition domain */
#define SE_INDEX	10	/* Index out of range */
#define SE_SINGULAR	11	/* Element can't be inverted */
#define SE_NSTYPE	12	/* No such type */
#define SE_NOT_ARRAY	13	/* Object is not an array */
#define SE_IUTYPE	14	/* Type already in use */
#define SE_STRING	15	/* Bad string argument */
#define SE_ICAST	16	/* Impossible cast */
#define SE_NOTRDY	17	/* Not yet implemented */
#define SE_EMPTY	18	/* Uninitialized object */
#define SE_HETERO	19	/* Heterogeneous operands */
#define SE_NSCALAR	20	/* Not a scalar */
#define SE_OVERFLOW	21	/* Internal overflow */
#define SE_TOO_SPARSE	22	/* Object is too sparse */
#define SE_NSMOD	23	/* Not the same modulus */

#endif
