/* *INDENT-OFF* */
!/* PSPP - computes sample statistics.
!   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
!   Written by Ben Pfaff <blp@gnu.org>.
!
!   This program is free software; you can redistribute it and/or
!   modify it under the terms of the GNU General Public License as
!   published by the Free Software Foundation; either version 2 of the
!   License, or (at your option) any later version.
!
!   This program is distributed in the hope that it will be useful, but
!   WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!   General Public License for more details.
!
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
!   02111-1307, USA. */
!
!/*
! SET procedure.
!
! This command accepts PC+ and Windows compatible syntax formats,
! and incorporates PSPP extensions.
!*/
!
!/*
!   Categories of SET subcommands:
!
!   data input: BLANKS, DECIMAL, FORMAT.
!   
!   program input: ENDCMD, NULLINE.
!   
!   interaction: CPROMPT, DPROMPT, ERRORBREAK, MXERRS, MXWARNS, PROMPT.
!   
!   program execution: MEXPAND, MITERATE, MNEST, MPRINT,
!   MXLOOPS, SEED, UNDEFINED.
!
!   data output: CCA...CCE, DECIMAL, FORMAT, RESULTS-p.
!
!   output routing: ECHO, ERRORS, INCLUDE, MESSAGES, PRINTBACK, ERRORS,
!   RESULTS-rw.
!
!   output activation: LISTING (on/off), SCREEN, PRINTER.
!
!   output driver options: HEADERS, MORE, PAGER, VIEWLENGTH, VIEWWIDTH,
!   LISTING (filename).
!
!   logging: LOG, JOURNAL.
!
!   system files: COMP/COMPRESSION, SCOMP/SCOMPRESSION.
!
!   security: SAFER.
!*/
!
!/*
!   FIXME
!
!   These subcommands remain to be implemented:
!     ECHO, PRINTBACK, INCLUDE
!     MORE, PAGER, VIEWLENGTH, VIEWWIDTH, HEADERS
!
!   These subcommands are not complete:
!     MESSAGES, ERRORS, RESULTS
!     LISTING/DISK, LOG/JOURNAL
!*/     
   
$ set:
$   automenu=automenu:on/off;
$   beep=beep:on/off;
$   blanks=custom;
$   block=string "x==1" "one character long";
$   boxstring=string "x==3 || x==11" "3 or 11 characters long";
$   case=size:upper/uplow;
$   cca=string;
$   ccb=string;
$   ccc=string;
$   ccd=string;
$   cce=string;
$   color=custom;
$   compression=compress:on/off;
$   cpi=integer;
$   cprompt=string;
$   decimal=dec:dot/_comma;
$   disk=custom;
$   dprompt=string;
$   echo=echo:on/off;
$   eject=eject:on/off;
$   endcmd=string "x==1" "one character long";
$   errorbreak=errbrk:on/off;
$   errors=errors:on/off/terminal/listing/both/none;
$   format=custom;
$   headers=headers:no/yes/blank;
$   helpwindows=helpwin:on/off;
$   highres=hires:on/off;
$   histogram=string "x==1" "one character long";
$   include=inc:on/off;
$   journal=custom;
$   length=custom;
$   listing=custom;
$   log=custom;
$   lowres=lores:auto/on/off;
$   lpi=integer;
$   menus=menus:standard/extended;
$   messages=messages:on/off/terminal/listing/both/none;
$   mexpand=mexp:on/off;
$   miterate=integer;
$   mnest=integer;
$   more=more:on/off;
$   mprint=mprint:on/off;
$   mxerrs=integer;
$   mxloops=integer;
$   mxmemory=integer;
$   mxwarns=integer;
$   nulline=null:on/off;
$   pager=custom;
$   printback=prtbck:on/off;
$   printer=prtr:on/off;
$   prompt=string;
$   ptranslate=ptrans:on/off;
$   rcolor=custom;
$   results=custom;
$   runreview=runrev:auto/manual;
$   safer=safe:on;
$   scompression=scompress:on/off;
$   screen=scrn:on/off;
$   scripttab=string "x==1" "one character long";
$   seed=custom;
$   tb1=string "x==3 || x==11" "3 or 11 characters long";
$   tbfonts=string;
$   undefined=undef:warn/nowarn;
$   viewlength=custom;
$   viewwidth=integer;
$   width=custom;
$   workdev=custom;
$   workspace=integer;
$   xsort=xsort:yes/no.
/* *INDENT-ON* */

/* Main declarations. */

#include <config.h>
#include <assert.h>
#include <stdio.h>
#include <errno.h>
#include "log.h"
#include "misc.h"
#include "output.h"
#include "settings.h"

double set_blanks;
int set_compression;
set_cust_currency set_cc[5];
int set_cpi;
char *set_cprompt;
int set_decimal;
int set_grouping;
char *set_dprompt;
int set_echo;
int set_endcmd;
int set_errorbreak;
int set_errors, set_messages, set_results;
fmt_spec set_format;
int set_headers;
int set_include;
char *set_journal;
int set_journaling;
int set_lpi;
int set_messages;
int set_mexpand;
int set_miterate;
int set_mnest;
int set_more;
int set_mprint;
int set_mxerrs;
int set_mxloops;
int set_mxwarns;
int set_nullline;
int set_printback;
int set_output = 1;
#if !USE_INTERNAL_PAGER
char *set_pager;
#endif /* !USE_INTERNAL_PAGER */
int set_printer;
char *set_prompt;
char *set_results_file;
int set_safer;
int set_scompression;
int set_screen;
long set_seed;
int set_seed_used;
int set_testing_mode;
int set_undefined;
int set_viewlength;
int set_viewwidth;

/* These caused problems on SunOS. */
#undef ON
#undef OFF

/* (header) */
/* (decls global) */

/* Parser and outline. */

int internal_cmd_set (void);

int
cmd_set (void)
{
  int result = internal_cmd_set ();
  /* (free) */
  return result;
}

static void set_routing (int q, int *setting);
static int set_ccx (char *cc_string, set_cust_currency * cc, int cc_name);

int
internal_cmd_set (void)
{
  /* (parser) */

  /* Common/similar syntax. */
  if (s_block)
    msg (SW, "BLOCK is obsolete.");

  if (s_boxstring)
    msg (SW, "BOXSTRING is obsolete.");

  if (compress != -1)
    {
      msg (MW, "Active file compression is not yet implemented.");	/* FIXME */
      set_compression = compress == OFF ? 0 : 1;
    }
  if (scompress != -1)
    set_scompression = scompress == OFF ? 0 : 1;
  if (n_cpi != NOT_LONG)
    {
      if (n_cpi <= 0)
	msg (SE, "CPI must be greater than 0.");
      else
	set_cpi = n_cpi;
    }
  if (s_histogram)
    msg (MW, "HISTOGRAM is obsolete.");
  if (n_lpi != NOT_LONG)
    {
      if (n_lpi <= 0)
	msg (SE, "LPI must be greater than 0.");
      else
	set_lpi = n_lpi;
    }
  
  /* Windows compatible syntax. */
  if (sbc_case)
    msg (SW, "CASE is not implemented and probably won't be.  If you care, "
	 "complain about it.");
  if (sbc_cca)
    set_ccx (s_cca, &set_cc[0], 'A');
  if (sbc_ccb)
    set_ccx (s_ccb, &set_cc[1], 'B');
  if (sbc_ccc)
    set_ccx (s_ccc, &set_cc[2], 'C');
  if (sbc_ccd)
    set_ccx (s_ccd, &set_cc[3], 'D');
  if (sbc_cce)
    set_ccx (s_cce, &set_cc[4], 'E');
  if (dec != -1)
    {
      set_decimal = dec == DOT ? '.' : ',';
      set_grouping = dec == DOT ? ',' : '.';
    }
  if (errors != -1)
    set_routing (errors, &set_errors);
  if (headers != -1)
    set_headers = headers == NO ? 0 : (headers == YES ? 1 : 2);
  if (messages != -1)
    set_routing (messages, &set_messages);
  if (mexp != -1)
    set_mexpand = mexp == OFF ? 0 : 1;
  if (n_miterate != NOT_LONG)
    {
      if (n_miterate > 0)
	set_miterate = n_miterate;
      else
	msg (SE, "Value for MITERATE (%ld) must be greater than 0.",
	     n_miterate);
    }
  if (n_mnest != NOT_LONG)
    {
      if (n_mnest > 0)
	set_mnest = n_mnest;
      else
	msg (SE, "Value for MNEST (%ld) must be greater than 0.", n_mnest);
    }
  if (mprint != -1)
    set_mprint = mprint == OFF ? 0 : 1;
  if (n_mxerrs != NOT_LONG)
    {
      if (set_mxerrs < 1)
	msg (SE, "MXERRS must be at least 1.");
      else
	set_mxerrs = n_mxerrs;
    }
  if (n_mxloops != NOT_LONG)
    {
      if (set_mxloops < 1)
	msg (SE, "MXLOOPS must be at least 1.");
      else
	set_mxloops = n_mxloops;
    }
  if (n_mxmemory != NOT_LONG)
    msg (SE, "MXMEMORY is obsolete.");
  if (n_mxwarns != NOT_LONG)
    set_mxwarns = n_mxwarns;
  if (prtbck != -1)
    set_printback = prtbck == OFF ? 0 : 1;
  if (s_scripttab)
    msg (SE, "SCRIPTTAB is obsolete.");
  if (s_tbfonts)
    msg (SW, "TBFONTS not implemented.");
  if (s_tb1)
    msg (SW, "TB1 not implemented.");
  if (undef != -1)
    set_undefined = undef == NOWARN ? 0 : 1;
  if (n_workspace != NOT_LONG)
    msg (SE, "WORKSPACE is obsolete.");

  /* PC+ compatible syntax. */
  if (scrn != -1)
    outp_enable_device (scrn == OFF ? 0 : 1, OUTP_DEV_SCREEN);

  if (automenu != -1)
    msg (SW, "AUTOMENU is obsolete.");
  if (beep != -1)
    msg (SW, "BEEP is obsolete.");

  if (s_cprompt)
    {
      free (set_cprompt);
      set_cprompt = s_cprompt;
      s_cprompt = NULL;
    }
  if (s_dprompt)
    {
      free (set_dprompt);
      set_dprompt = s_dprompt;
      s_dprompt = NULL;
    }
  if (echo != -1)
    set_echo = echo == OFF ? 0 : 1;
  if (s_endcmd)
    set_endcmd = s_endcmd[0];
  if (eject != -1)
    msg (SW, "EJECT is obsolete.");
  if (errbrk != -1)
    set_errorbreak = errbrk == OFF ? 0 : 1;
  if (helpwin != -1)
    msg (SW, "HELPWINDOWS is obsolete.");
  if (inc != -1)
    set_include = inc == OFF ? 0 : 1;
  if (menus != -1)
    msg (MW, "MENUS is obsolete.");
  if (null != -1)
    set_nullline = null == OFF ? 0 : 1;
  if (more != -1)
    set_more = more == OFF ? 0 : 1;
  if (prtr != -1)
    outp_enable_device (prtr == OFF ? 0 : 1, OUTP_DEV_PRINTER);
  if (s_prompt)
    {
      free (set_prompt);
      set_prompt = s_prompt;
      s_prompt = NULL;
    }
  if (ptrans != -1)
    msg (SW, "PTRANSLATE is obsolete.");
  if (runrev != -1)
    msg (SW, "RUNREVIEW is obsolete.");
  if (safe == ON)
    set_safer = 1;
  if (xsort != -1)
    msg (SW, "XSORT is obsolete.");

  return 1;
}

/* Sets custom currency specifier CC having name CC_NAME ('A' through
   'E') to correspond to the settings in CC_STRING. */
static int
set_ccx (char *cc_string, set_cust_currency * cc, int cc_name)
{
  char *cp;
  int count_commas, count_periods;

  if (strlen (cc_string) > 16)
    return msg (SE, "CC%c: Length of custom currency string `%s' (%d) "
		"exceeds maximum length of 16.", cc_name, cc_string,
		strlen (cc_string));

  /* Count the number of commas and periods.  There must be exactly
     three of one or the other. */
  for (cp = cc_string, count_commas = count_periods = 0; *cp; cp++)
    if (*cp == ',')
      count_commas++;
    else if (*cp == '.')
      count_periods++;
  if (!((count_commas == 3) ^ (count_periods == 3)))
    return msg (SE, "CC%c: Custom currency string `%s' does not contain "
		"exactly three periods or commas.", cc_name, cc_string);

  /* Decide on separator characters. */
  if (count_commas == 3)
    cc->decimal = '.', cc->grouping = ',';
  else
    cc->decimal = ',', cc->grouping = '.';

  /* Copy cc_string to cc, changing separators to nulls. */
  strcpy (cc->buf, cc_string);
  cc->neg_prefix = cp = cc->buf;

  while (*cp++ != cc->grouping)
    ;
  cp[-1] = '\0';
  cc->prefix = cp;

  while (*cp++ != cc->grouping)
    ;
  cp[-1] = '\0';
  cc->suffix = cp;

  while (*cp++ != cc->grouping)
    ;
  cp[-1] = '\0';
  cc->neg_suffix = cp;

  return 1;
}

/* Sets *SETTING, which is a combination of SET_ROUTE_* bits that
   indicates what to do with some sort of output, to the value
   indicated by Q, which is a value provided by the input parser. */
static void
set_routing (int q, int *setting)
{
  switch (q)
    {
    case ON:
      *setting |= SET_ROUTE_DISABLE;
      break;
    case OFF:
      *setting &= ~SET_ROUTE_DISABLE;
      break;
    case TERMINAL:
      *setting &= ~(SET_ROUTE_LISTING | SET_ROUTE_OTHER);
      *setting |= SET_ROUTE_SCREEN;
      break;
    case LISTING:
      *setting &= ~SET_ROUTE_SCREEN;
      *setting |= SET_ROUTE_LISTING | SET_ROUTE_OTHER;
      break;
    case BOTH:
      *setting |= SET_ROUTE_SCREEN | SET_ROUTE_LISTING | SET_ROUTE_OTHER;
      break;
    case NONE:
      *setting &= ~(SET_ROUTE_SCREEN | SET_ROUTE_LISTING | SET_ROUTE_OTHER);
      break;
    default:
      assert (0);
    }
}

static int
custom_pager (void)
{
  match_tok ('=');
#if !USE_INTERNAL_PAGER
  if (match_id (OFF))
    {
      if (set_pager)
	free (set_pager);
      set_pager = NULL;
    }
  else
    {
      force_string ();
      if (set_pager)
	free (set_pager);
      set_pager = xstrdup (tokstr);
      get_token ();
    }
  return 1;
#else /* USE_INTERNAL_PAGER */
  if (match_id (OFF))
    return 1;
  msg (SW, "External pagers not supported.");
  return 0;
#endif /* USE_INTERNAL_PAGER */
}

/* Parses the BLANKS subcommand, which controls the value that
   completely blank fields in numeric data imply.  X, Wnd: Syntax is
   SYSMIS or a numeric value; PC+: Syntax is '.', which is equivalent
   to SYSMIS, or a numeric value. */
static int
custom_blanks (void)
{
  match_tok ('=');
  if ((token == ID && id_match ("SYSMIS", tokstr))
      || (token == STRING && streq (tokstr, ".")))
    {
      get_token ();
      set_blanks = SYSMIS;
    }
  else
    {
      force_num ();
      set_blanks = tokval;
      get_token ();
    }
  return 1;
}

static int
custom_length (void)
{
  int page_length;

  match_tok ('=');
  if (match_id (NONE))
    page_length = -1;
  else
    {
      force_int ();
      if (tokint < 1)
	return msg (SE, "LENGTH must be at least 1.");
      page_length = tokint;
      get_token ();
    }

  /* FIXME: Set page length. */
  return 1;
}

static int
custom_results (void)
{
  typedef struct
    {	
      const char *s;	
      int v;
    }
  tuple;

  static tuple tab[] =
    {
      {"ON", ON},
      {"OFF", OFF},
      {"TERMINAL", TERMINAL},
      {"LISTING", LISTING},
      {"BOTH", BOTH},
      {"NONE", NONE},
      {NULL, 0},
    };

  tuple *t;

  match_tok ('=');

  if (token != ID)
    return msg (SE, "Missing identifier in RESULTS subcommand.  ");
  for (t = tab; t->s; t++)
    if (id_match (t->s, tokstr))
      {
	get_token ();
	set_routing (t->v, &set_results);
	return 1;
      }
  return msg (SE, "Unrecognized identifier in RESULTS subcommand.");
}

static int
custom_seed (void)
{
  match_tok ('=');
  if (match_id (RANDOM))
    set_seed = NOT_LONG;
  else
    {
      force_num ();
      set_seed = tokval;
      get_token ();
    }
  return 1;
}

static int
custom_width (void)
{
  int page_width;

  match_tok ('=');
  if (match_id (NARROW))
    page_width = 79;
  else if (match_id (WIDE))
    page_width = 131;
  else
    {
      force_int ();
      if (tokint < 1)
	return msg (SE, "WIDTH must be at least 1.");
      page_width = tokint;
      get_token ();
    }

  /* FIXME: Set page width. */
  return 1;
}

/* Parses FORMAT subcommand, which consists of a numeric format
   specifier. */
static int
custom_format (void)
{
  fmt_spec fmt;

  match_tok ('=');
  if (!parse_format_specifier (&fmt, 0))
    return 0;
  if ((formats[fmt.type].cat & FCAT_STRING) != 0)
    return msg (SE, "FORMAT requires numeric output format as an argument.  "
	    "Specified format %s is of type string.", fmt_to_string (&fmt));

  set_format = fmt;
  return 1;
}

static int
custom_journal (void)
{
  match_tok ('=');
  if (match_id (ON))
    set_journaling = 1;
  else if (match_id (OFF))
    set_journaling = 0;
  if (token == STRING)
    {
      set_journal = xstrdup (tokstr);
      get_token ();
    }
  return 1;
}

/* Parses COLOR subcommand.  PC+: either ON or OFF or two or three
   comma-delimited numbers inside parentheses. */
static int
custom_color (void)
{
  msg (MW, "COLOR is obsolete.");

  match_tok ('=');
  if (!match_id (ON) && !match_id (YES) && !match_id (OFF) && !match_id (NO))
    {
      force_match ('(');
      if (!match_tok ('*'))
	{
	  force_int ();
	  if (tokint > 15)
	    return msg (SE, "Text color must be in range 0-15.");
	  get_token ();
	}
      force_match (',');
      if (!match_tok ('*'))
	{
	  force_int ();
	  if (tokint > 7)
	    return msg (SE, "Background color must be in range 0-7.");
	  get_token ();
	}
      if (match_tok (',') && !match_tok ('*'))
	{
	  force_int ();
	  if (tokint > 7)
	    return msg (SE, "Border color must be in range 0-7.");
	  get_token ();
	}
      force_match (')');
    }
  return 1;
}

static int
custom_listing (void)
{
  match_tok ('=');
  if (match_id (ON) || match_id (YES))
    outp_enable_device (1, OUTP_DEV_LISTING);
  else if (match_id (OFF) || match_id (NO))
    outp_enable_device (0, OUTP_DEV_LISTING);
  else
    {
      /* FIXME */
    }

  return 0;
}

static int
custom_disk (void)
{
  custom_listing ();
  return 0;
}

static int
custom_log (void)
{
  custom_journal ();
  return 0;
}

static int
custom_rcolor (void)
{
  msg (SW, "RCOLOR is obsolete.");

  match_tok ('=');
  force_match ('(');

  if (!match_tok ('*'))
    {
      force_int ();
      if (tokint > 6)
	return msg (SE, "Lower window color must be between 0 and 6.");
      get_token ();
    }
  force_match (',');

  if (!match_tok ('*'))
    {
      force_int ();
      if (tokint > 6)
	return msg (SE, "Upper window color must be between 0 and 6.");
      get_token ();
    }

  if (match_tok (',') && !match_tok ('*'))
    {
      force_int ();
      if (tokint > 6)
	return msg (SE, "Frame color must be between 0 and 6.");
      get_token ();
    }
  return 1;
}

static int
custom_viewlength (void)
{
  if (match_id (MINIMUM))
    set_viewlength = 25;
  else if (match_id (MEDIAN))
    set_viewlength = 43;	/* this is not correct for VGA displays */
  else if (match_id (MAXIMUM))
    set_viewlength = 43;
  else
    {
      force_int ();
#if __MSDOS__
      if (tokint >= (43 + 25) / 2)
	set_viewlength = 43;
      else
	set_viewlength = 25;
#else /* not dos */
      set_viewlength = tokint;
#endif /* not dos */
      get_token ();
    }

#if __MSDOS__
  msg (SW, "VIEWLENGTH not implemented.");
#endif /* dos */
  return 1;
}

static int
custom_workdev (void)
{
  char c[2];

  msg (SW, "WORKDEV is obsolete.");

  c[1] = 0;
  for (*c = 'A'; *c <= 'Z'; (*c)++)
    if (token == ID && id_match (c, tokstr))
      {
	get_token ();
	return 1;
      }
  return msg (SE, "Drive letter expected in WORKDEV subcommand.");
}


/* GSET. */

int
cmd_gset (void)
{
  /* FIXME */
  return 0;
}

/* Local variables: */
/* mode:c */
/* End: */
