/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#if !error_h
#define error_h 1

#include <stdarg.h>

/* Message classes. */
enum
  {
    FE,				/* fatal error; causes termination */
    SE,				/* script error */
    SW,				/* script warning */
    SM,				/* script message */
    IE,				/* installation error */
    IS,				/* installation script error */
    DE,				/* data-file error */
    DW,				/* data-file warning */
    ME,				/* general error */
    MW,				/* general warning */
    MM,				/* general message */
    MSG_CLASS_COUNT		/* number of message classes */
  };

/* Number of errors, warnings reported. */
extern int error_count;
extern int warning_count;

/* If number of allowable errors/warnings is exceeded, then a message
   is displayed and this flag is set to suppress subsequent
   messages. */
extern int error_already_flagged;

/* `Custom' error & warning filenames and line numbers. */
extern const char *cust_fn;
extern int cust_ln;

/* `Custom' error & warning beginning & ending columns; `custom' field
   type. */
extern int cust_fc;
extern int cust_lc;
extern struct fmt_spec cust_field;

/* Verbosity level. */
extern int verbosity;

void push_cust (const char *);
void pop_cust (void);

void hcf (int exit_code) __attribute__ ((noreturn));

#if __CHECKER__
void induce_segfault (void) __attribute__ ((noreturn));
#endif

int msg (int class, const char *format,...)
     __attribute__ ((format (printf, 2, 3)));
void vmsg (int class, const char *format, va_list args, const char *title)
     __attribute__ ((format (printf, 2, 0)));
void failure (void);
void error_break (void);

void check_error_count (void);

#if __GNUC__ && !__STRICT_ANSI__
#define verbose_msg(LEVEL, FORMAT, ARGS...) \
     ({ if(verbosity>=(LEVEL)) msg(MM, FORMAT , ## ARGS); })
#else
void verbose_msg (int level, const char *format,...);
#endif

/* Terminate unless we're interactive or will go interactive when the
   file is over with. */
#define cond_fail()						\
	do							\
	  {							\
	    if (am_reading_script)				\
              {						  	\
		if (getl_interactive)				\
		  getl_close_all ();				\
		else						\
		  failure ();					\
              }							\
	  }							\
	while (0)

void chkr_disp_call_chain (void);

#endif /* error.h */
