/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#if !common_h
#define common_h 1

#include <stddef.h>
#include <limits.h>
#include <float.h>

#if ENDIAN != UNKNOWN
#define endian ENDIAN
#else
extern int endian;
#endif

#ifdef SECOND_LOWEST_VALUE
#define second_lowest_value SECOND_LOWEST_VALUE
#else
extern double second_lowest_value;
#endif

/* Special values. */
#define SYSMIS (-DBL_MAX)
#define LOWEST second_lowest_value
#define HIGHEST DBL_MAX

/* NOT_LONG and NOT_INT are used when we want a "missing value" for an
   integer-type variable. */
#define NOT_LONG LONG_MAX
#define NOT_INT INT_MAX

/* Definition of the max length of a short string value, generally
   eight characters.  */
#define MAX_SHORT_STRING ((SIZEOF_DOUBLE)>=8 ? ((SIZEOF_DOUBLE)+1)/2*2 : 8)
#define MIN_LONG_STRING (MAX_SHORT_STRING+1)

/* FYI: It is a bad situation if sizeof(flt64) < MAX_SHORT_STRING:
   then short string missing values can be truncated in system files
   because there's only room for as many characters as can fit in a
   flt64. */
#if MAX_SHORT_STRING > 8
#error MAX_SHORT_STRING must be less than 8.
#endif

/* Variables. */
extern char *pgmname;
extern int finished;
extern char curdate[];
extern int start_interactive;

#if HAVE_LIBHISTORY
extern char *history_file;
#endif

/* Functions. */
void *xmalloc (size_t size);
void *xcalloc (size_t size);
void *xrealloc (void *ptr, size_t size);
char *xstrdup (const char *s);

/* Brokenness. */
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#if !HAVE_GOOD_RANDOM
#include <stdlib.h>
#undef rand
#undef srand
#define rand ansi_rand
#define srand ansi_srand
#define RAND_MAX 32767
#define BROKEN_RAND 1
#endif /* bad system random number generator */

#endif /* common_h */
