/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * twod_install.c 
 */

/*
 * Create TWOD_WIN postmaster object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
 
#include <constants.h>
#include <defaults.h>
#include <math_utils.h>
#include <pm.h>
#include <view.h>
#include <memory.h>
#include <tcl.h>
#include <tk.h>

extern Tcl_Interp *interp;

static char *TWOD_OBJ_NAME = "TwoD_Win";

static char *TWOD_WIN[] = {
  "TwoD_Win.Locn", "TwoD_Win.Open_Corresponding", "TwoD_Win.Window_Number",
  "TwoD_Win.Symbol_Index", "TwoD_Win.Sym_Size_Index", "TwoD_Win.Bg_Color_Index",
  "TwoD_Win.Show_Cmap", "TwoD_Win.Cmap_Type_Index", "TwoD_Win.Depth_Coord",
  "TwoD_Win.Depth_Coord_Min", "TwoD_Win.Depth_Coord_Max", "TwoD_Win.Cmap_File",
  "TwoD_Win.Hor_Min", "TwoD_Win.Hor_Max", "TwoD_Win.Vert_Min", 
  "TwoD_Win.Vert_Max", "TwoD_Win.Hor_Type", "TwoD_Win.Ver_Type", 
  "TwoD_Win.Hor_Index", "TwoD_Win.Ver_Index", "TwoD_Win.Update_Current"
  };

typedef enum {
  LOCN=0, OPEN_CORR, WIN_NUM, SYMB_INDEX, SYMB_SIZE_INDEX, BG_COL_INDEX, 
  SHOW_CMAP, CMAP_TYPE_INDEX, DEPTH_COORD, DEPTH_COORD_MIN, DEPTH_COORD_MAX, 
  CMAP_FILE, HOR_MIN, HOR_MAX, VERT_MIN, VERT_MAX, HOR_TYPE, VER_TYPE, 
  HOR_INDEX, VER_INDEX, UPDATE_CURR
  } TWOD_WIN_t;


void 
twod_install()
{
  void twod_open_corr(), twod_update_current();

  pm(CREATE_OBJ, TWOD_OBJ_NAME,
     CREATE_ELEM, TWOD_WIN[LOCN], INT_LIST, 
     CREATE_ELEM, TWOD_WIN[OPEN_CORR], FNCT, 
     CREATE_ELEM, TWOD_WIN[WIN_NUM], INT,
     CREATE_ELEM, TWOD_WIN[SYMB_INDEX], INT, 
     CREATE_ELEM, TWOD_WIN[SYMB_SIZE_INDEX], INT,
     CREATE_ELEM, TWOD_WIN[BG_COL_INDEX], INT,
     CREATE_ELEM, TWOD_WIN[SHOW_CMAP], INT,
     CREATE_ELEM, TWOD_WIN[CMAP_TYPE_INDEX], INT,
     CREATE_ELEM, TWOD_WIN[DEPTH_COORD], INT, 
     CREATE_ELEM, TWOD_WIN[DEPTH_COORD_MIN], INT,
     CREATE_ELEM, TWOD_WIN[DEPTH_COORD_MAX], INT,
     CREATE_ELEM, TWOD_WIN[CMAP_FILE], STRNG,
     CREATE_ELEM, TWOD_WIN[HOR_MIN], DBL,
     CREATE_ELEM, TWOD_WIN[HOR_MAX], DBL,
     CREATE_ELEM, TWOD_WIN[VERT_MIN], DBL,
     CREATE_ELEM, TWOD_WIN[VERT_MAX], DBL,
     CREATE_ELEM, TWOD_WIN[HOR_TYPE], INT,
     CREATE_ELEM, TWOD_WIN[VER_TYPE], INT,
     CREATE_ELEM, TWOD_WIN[HOR_INDEX], INT, 
     CREATE_ELEM, TWOD_WIN[VER_INDEX], INT,
     CREATE_ELEM, TWOD_WIN[UPDATE_CURR], FNCT,
     NULL);

     pm(INIT, TWOD_WIN[OPEN_CORR], 
        PUT, TWOD_WIN[OPEN_CORR], twod_open_corr,
        INIT, TWOD_WIN[UPDATE_CURR], 
        PUT, TWOD_WIN[UPDATE_CURR], twod_update_current,
	INIT, TWOD_WIN[LOCN], 4, 
        PUT, TWOD_WIN[LOCN], 0, NO_LOCATION,
        INIT, TWOD_WIN[CMAP_FILE], SIZE_OF_DIR_PLUS_FNAME,
        PUT, TWOD_WIN[CMAP_FILE], TRAJ_COLORMAP,
        NULL);

}



void twod_open_corr()
{
    int window_num;
    int *locn;
    char tclcmd[MAX_LONG_STR];

    window_num = *((int *)pm(GET, "TwoD_Win.Window_Number", NULL));
    locn = ivector(0,3);
    pm(GET_LIST, "TwoD_Win.Locn", 0, 3, locn, NULL);
 
    sprintf (tclcmd,"window(mult_open) twoD");
/*    printf ("%s\n", tclcmd); */
    Tcl_Eval(interp, tclcmd);
    sprintf (tclcmd, "window(geometry) twoD%d +%d+%d", window_num, locn[0], locn[1]);
  /*  printf ("%s\n", tclcmd); */
    Tcl_Eval(interp, tclcmd);

    free_ivector(locn,0,3);
}
    



void twod_update_current()
{
    char tclcmd[MAX_LONG_STR];
    char tclcmd2[MAX_LONG_STR];
    int param_dim, varb_dim;
    double tmpval1;
    int hortype, vertype, horindex, verindex;
    int winnum, tmpval;

    winnum = *((int *)pm(GET, "TwoD_Win.Window_Number", NULL));
    varb_dim = *((int *)pm(GET, "Model.Varb_Dim", NULL));
    param_dim = *((int *)pm(GET, "Model.Param_Dim", NULL));

    sprintf (tclcmd, "global twoD%d", winnum);
    Tcl_Eval(interp, tclcmd);

    tmpval = *((int *)pm(GET, "TwoD_Win.Cmap_Type_Index", NULL));
    sprintf (tclcmd, "set twoD%d(pick) %d", winnum, tmpval);
    Tcl_Eval(interp, tclcmd);
    sprintf (tclcmd, "twoD(pickcolor) %d", winnum);
    Tcl_Eval(interp, tclcmd);
 
    hortype = *((int *)pm(GET, "TwoD_Win.Hor_Type", NULL));
    vertype = *((int *)pm(GET, "TwoD_Win.Ver_Type", NULL));
    horindex = *((int *)pm(GET, "TwoD_Win.Hor_Index", NULL));
    verindex = *((int *)pm(GET, "TwoD_Win.Ver_Index", NULL));

    if (hortype == PHASE_SPACE_VARB) {
        sprintf (tclcmd2, "set twoD%d(horindex) %d", winnum, horindex);
    } else if (hortype == PARAMETER_VARB) {
        sprintf (tclcmd2, "set twoD%d(horindex) %d", winnum, horindex+varb_dim);
    } else {
        sprintf (tclcmd2, "set twoD%d(horindex) %d", winnum, horindex+varb_dim+param_dim);
        }
    Tcl_Eval(interp, tclcmd2);
    sprintf (tclcmd, "twoD(hor) %d", winnum);
    Tcl_Eval(interp, tclcmd);

    if (vertype == PHASE_SPACE_VARB) {
	sprintf (tclcmd2, "set twoD%d(verindex) %d", winnum, verindex);
    } else if (vertype == PARAMETER_VARB) {
	sprintf (tclcmd2, "set twoD%d(verindex) %d", winnum, verindex+varb_dim);
    } else {
	sprintf (tclcmd2, "set twoD%d(verindex) %d", winnum, verindex+varb_dim+param_dim);
        }
    Tcl_Eval(interp, tclcmd2);
    sprintf (tclcmd, "twoD(ver) %d", winnum);
    Tcl_Eval(interp, tclcmd);

    tmpval1 = *((double *)pm(GET, "TwoD_Win.Hor_Min", NULL));
    sprintf (tclcmd, "set twoD%d(hormin) %f", winnum, tmpval1);
    Tcl_Eval(interp, tclcmd);
 
    tmpval1 = *((double *)pm(GET, "TwoD_Win.Hor_Max", NULL));
    sprintf (tclcmd, "set twoD%d(hormax) %f", winnum, tmpval1);
    Tcl_Eval(interp, tclcmd);
 
    tmpval1 = *((double *)pm(GET, "TwoD_Win.Vert_Min", NULL));
    sprintf (tclcmd, "set twoD%d(vermin) %f", winnum, tmpval1);
    Tcl_Eval(interp, tclcmd);
 
    tmpval1 = *((double *)pm(GET, "TwoD_Win.Vert_Max", NULL));
    sprintf (tclcmd, "set twoD%d(vermax) %f", winnum, tmpval1);
    Tcl_Eval(interp, tclcmd);

}


