/* $Id: xxl_util.cc,v 1.4 1997/02/10 15:10:01 aml Exp $
*/
#include <stdio.h>
#include <stdlib.h>
#include "utils.hh"
#include "xxl_util.hh"


int find_char(char *st,char c) {
    int i;

    int n = strlen(st);

    for(i=0; i<n ; i++) {
        if (st[i] == c) 
            return(i);
    }
    return(-1);
}

char *normal_cell_name(char *ref) {
    static char cel[10];
    int i,j;
    int n = strlen(ref);

    for(i=0,j=0; i<n; i++) {
        if (ref[i] != '$') 
            cel[j++] = toupper(ref[i]);
        else 
            cel[j++] = '$';
    }
    cel[j] = 0;
    return(cel);
    
}

int cellcol(char *cell) {
    return(atocol(cell));
}

int cellrow(char *cell) {

    for( ; !isdigit(*cell); cell++) ;

    return(atoi(cell)-1);
            
}

int atocol(char *col) {

    int result;

    if (*col == '$') col++;

    if (isdigit(col[1]) || col[1] == '$')
        result = col[0]-'A';
    else if (isdigit(col[2]) || col[2] == '$')
        result = (col[0]-'A'+1)*26+(col[1]-'A');
    else 
        result = 0;

    return(result);


}



/* $Log: xxl_util.cc,v $
// Revision 1.4  1997/02/10  15:10:01  aml
// Print settings now are saved to file.
// Fixed buggy error message when loading sheets.
//
// Revision 1.3  1996/07/23  14:00:31  aml
// Changed canvas widget to handle special items like cell borders.
// Seems to work well. Spreadsheet size is no more limited now.
//
 * Revision 1.2  1996/01/03 23:07:08  aml
 * Absolute and relative references to cells introduced.
 * They are parsed and reverse parsed, not yet evaluated.
 *
// Revision 1.1  1996/01/03  21:18:05  aml
// Initial revision
//
 * Revision 1.4  1995/09/18  09:26:14  aml
 * Last working release with inline expressions.
 * Move to wk1 format will start after this.
 *
 * Revision 1.3  1995/08/08 02:32:38  aml
 * None
 *
 * Revision 1.2  1995/06/26 22:52:35  aml
 * Change to C++
 *
 * Revision 1.1  1995/06/26  17:41:13  aml
 * Initial revision
 *
 * Revision 1.3  1995/06/25  00:09:50  aml
 * First version of copy
 *
 * Revision 1.2  1995/06/23  16:10:32  aml
 * *** empty log message ***
 *
 * Revision 1.1  1995/06/23  15:41:40  aml
 * Initial revision
 * */
