// mailboxmenu.cc for bbmail - an tool for display the mail in X11.
//
//  Copyright (c) 1998,1999 by John Kennis, j.m.b.m.kennis@ele.tue.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//
#include "mailboxmenu.hh"

Mailboxmenu::Mailboxmenu(ToolWindow *toolwindow) :
	Basemenu(toolwindow)
{
	int i;
	bbtool=toolwindow;
	
	setTitleVisibility(False);
	setMovable(False);
	setHidable(True);
	setAlignment(AlignBottom);
	defaultMenu();

	word_length = new int [bbtool->getResource()->report.number_of_spoolfiles];
	for (i=0;i<bbtool->getResource()->report.number_of_spoolfiles;i++)
	{
		insert(bbtool->getResource()->spoolfile[i].name);
		word_length[i]=strlen(bbtool->getResource()->spoolfile[i].name);
	}
	insert("Reconfigure");	
}


Mailboxmenu::~Mailboxmenu(void)
{
	delete [] word_length;
}

void Mailboxmenu::ClearMenu()
{
	int i;
	
	for (i=0;i<=bbtool->getResource()->report.number_of_spoolfiles;i++)
		remove(0);
	delete [] word_length;
}

void Mailboxmenu::Reconfigure()
{
	int i;

	word_length = new int [bbtool->getResource()->report.number_of_spoolfiles];
	for (i=0;i<bbtool->getResource()->report.number_of_spoolfiles;i++)
	{
		insert(bbtool->getResource()->spoolfile[i].name,0);
		word_length[i]=strlen(bbtool->getResource()->spoolfile[i].name);
	}
	insert("Reconfigure");	
	Basemenu::reconfigure();
}


void Mailboxmenu::Move(int x, int y, bool withdrawn)
{
	if (!withdrawn)
	{
		y= y - getHeight() -1;
		if ((x+getWidth())>bbtool->getCurrentScreenInfo()->getWidth())
			x=bbtool->getCurrentScreenInfo()->getWidth()-getWidth();
        if (y<0)
	       	y=bbtool->Frame().height - 1;
	    Basemenu::move(x, y);
	}
	else
	{
		x= x - getWidth() - 6;
		if (x<0)
			x=x + getWidth() + 12;
     	if (y<0)
           	y=0;
												
		Basemenu::move(x, y);
	}
}

/* quick and dirty */
void Mailboxmenu::UpdateNumbers(int newmail, int totalmail,int spoolno)
{
	char dummy[10];	

    bbtool->getResource()->spoolfile[spoolno].name[word_length[spoolno]]='\0';
	sprintf(dummy," (%u/%u)",newmail,totalmail);
	strcat(bbtool->getResource()->spoolfile[spoolno].name,dummy);
	if (newmail>0)
		setHighlight(spoolno);
	wait_for_update=True;
}

void Mailboxmenu::Update()
{
	wait_for_update=False;
	Basemenu::update();
}

void Mailboxmenu::itemSelected(int button, int index)
{
  if (button == 1)
  {
    if (index < bbtool->getResource()->report.number_of_spoolfiles)
    {
		system(bbtool->getResource()->spoolfile[index].runCommand);
    }
    else if (index == bbtool->getResource()->report.number_of_spoolfiles)
    {
		bbtool->Reconfigure();
    }
    hide();
    bbtool->EnvelopePushed(False);
    bbtool->Redraw(False);
  }
}

void Mailboxmenu::show(void) {
  XRaiseWindow(bbtool->getDisplay(), getWindowID());
  Basemenu::show();
}
