/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_lowvideo.h,v 1.2 1999/06/02 20:46:52 slouken Exp $";
#endif

/* The main window -- and a function to set it for the audio */
extern HWND SDL_Window;
extern void SDL_SYS_SoundFocus(HWND window);

/* Variables and functions exported to other parts of the native video
   subsystem (SDL_sysevents.c)
*/
/* Called by windows message loop when system palette is available */
extern void SDL_RealizePalette(void);

/* Called by windows message loop when the system palette changes */
extern void SDL_PaletteChanged(HWND window);

/* Called by windows message loop when a portion of the screen needs update */
extern void SDL_WinPAINT(HDC hdc);

/* The window cursor (from SDL_sysmouse.c) */
extern HCURSOR SDL_hcursor;

/* The bounds of the window in screen coordinates */
extern RECT SDL_bounds;

/* Flag -- SDL is performing a resize, rather than the user */
extern int SDL_resizing;

/* Variables and functions exported by SDL_sysevents.c to other parts 
   of the native video subsystem (SDL_sysvideo.c)
*/
extern int SDL_CreateWindow(void);
extern void SDL_DInputReset(int fullscreen);
extern void SDL_DestroyWindow(void);

