#include "Python.h"
#include <orb/orbit.h>
#include "Types.h"

/* I can't figure out why this isn't added to Types.h by the IDL compiler... */
#if !defined(TC_IMPL_TC_Types_Tester)
#define TC_IMPL_TC_Types_Tester ORBIT_FILE_ID_Types
extern const struct CORBA_TypeCode_struct TC_Types_Tester_struct;
#define TC_Types_Tester ((CORBA_TypeCode)&TC_Types_Tester_struct)
#endif

#define checkCORBA(ev) \
if (ev._major != CORBA_NO_EXCEPTION) {\
fprintf(stderr, "Exception: %s\n", CORBA_exception_id(&(ev)));\
}

static PortableServer_ServantBase__epv base_epv;

/* Begin POA_Tester object */

staticforward CORBA_boolean
Tester_impl_test_boolean(
    PortableServer_Servant servant,
    const CORBA_boolean arg,
    CORBA_Environment *ev
);

staticforward CORBA_short
Tester_impl_test_short(
    PortableServer_Servant servant,
    const CORBA_short arg,
    CORBA_Environment *ev
);

staticforward CORBA_long
Tester_impl_test_long(
    PortableServer_Servant servant,
    const CORBA_long arg,
    CORBA_Environment *ev
);

staticforward CORBA_float
Tester_impl_test_float(
    PortableServer_Servant servant,
    const CORBA_float arg,
    CORBA_Environment *ev
);

staticforward CORBA_double
Tester_impl_test_double(
    PortableServer_Servant servant,
    const CORBA_double arg,
    CORBA_Environment *ev
);

staticforward CORBA_char *
Tester_impl_test_string(
    PortableServer_Servant servant,
    const CORBA_char * arg,
    CORBA_Environment *ev
);

staticforward CORBA_boolean
Tester_impl_test_callback(
    PortableServer_Servant servant,
    const Types_Tester arg,
    CORBA_Environment *ev
);

staticforward Types_Tester
Tester_impl_test_factory(
    PortableServer_Servant servant,
    CORBA_Environment *ev
);

staticforward Types_Truth *
Tester_impl_test_struct(
    PortableServer_Servant servant,
    const Types_Truth *arg,
    CORBA_Environment *ev
);

staticforward POA_Types_Tester__epv Types_Tester_epv;
staticforward POA_Types_Tester__vepv Types_Tester_vepv;

typedef struct {
    POA_Types_Tester servant;
    void *ob;
} impl_POA_Types_Tester;

typedef struct {
    PyObject_HEAD
    impl_POA_Types_Tester impl;
} POA_TesterObject;

staticforward PyTypeObject POA_Tester_Type;

/* End POA_Tester object */

/* Begin Tester object */

typedef struct {
    PyObject_HEAD
    Types_Tester ob;
    CORBA_Environment ev;
} TesterObject;

staticforward PyTypeObject Tester_Type;

staticforward TesterObject *
Tester2Object(Types_Tester object);

/* End Tester object */

/* Begin Truth wrapper */

typedef struct {
   PyObject_HEAD
   Types_Truth * ob;
   CORBA_Environment ev;
} TruthObject;

staticforward PyTypeObject Truth_Type;

staticforward TruthObject *
Truth2Object(Types_Truth * object);

/* End Truth wrapper */

/* Begin MyTest wrapper */

/* End MyTest wrapper */

