#include "global.h"

/*
 * Box
 */
static void
box_pack_start_or_end(argc, argv, self, start)
    int argc;
    VALUE *argv;
    VALUE self;
    int start;
{
    VALUE arg0, arg1, arg2, arg3;
    gint expand, fill, padding;
    GtkWidget *widget, *child;

    expand = fill = Qtrue; padding = 0;
    switch (rb_scan_args(argc, argv, "13", &arg0, &arg1, &arg2, &arg3)) {
      case 4:
	padding = NUM2INT(arg3);
      case 3:
	fill = RTEST(arg2);
      case 2:
	expand = RTEST(arg1);
      default:
	child = get_widget(arg0);
	break;
    }
    widget = get_widget(self);

    if (start)
	gtk_box_pack_start(GTK_BOX(get_widget(self)), child, expand, fill, padding);
    else
	gtk_box_pack_end(GTK_BOX(get_widget(self)), child, expand, fill, padding);
}

static VALUE
box_pack_start(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    box_pack_start_or_end(argc, argv, self, 1);
    return self;
}

static VALUE
box_pack_end(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    box_pack_start_or_end(argc, argv, self, 0);
    return self;
}

static VALUE
box_set_homogeneous(self, homogeneous)
     VALUE self, homogeneous;
{
    gtk_box_set_homogeneous(GTK_BOX(get_widget(self)), RTEST(homogeneous));
    return self;
}

static VALUE
box_set_spacing(self, spacing)
     VALUE self, spacing;
{
    gtk_box_set_spacing(GTK_BOX(get_widget(self)), NUM2INT(spacing));
    return self;
}

static VALUE
box_reorder_child(self, child, pos)
    VALUE self, child, pos;
{
    gtk_box_reorder_child(GTK_BOX(get_widget(self)),
			  get_widget(child), NUM2INT(pos));
    return self;
}

VALUE
box_query_child_packing(self, child)
     VALUE self, child;
{
    gboolean expand, fill;
    guint padding;
    GtkPackType pack_type;
    VALUE ary;

    gtk_box_query_child_packing(GTK_BOX(get_widget(self)), get_widget(child),
				&expand, &fill, &padding, &pack_type);

    ary = rb_ary_new2(4);
    rb_ary_push(ary, expand==FALSE?Qfalse:Qtrue);
    rb_ary_push(ary, fill==FALSE?Qfalse:Qtrue);
    rb_ary_push(ary, INT2NUM(padding));
    rb_ary_push(ary, INT2FIX(pack_type));

    return ary;
}

VALUE
box_set_child_packing(self, child, expand, fill, padding, pack_type)
     VALUE self, child, expand, fill, padding, pack_type;
{
    gtk_box_set_child_packing(GTK_BOX(get_widget(self)), get_widget(child),
			      RTEST(expand), RTEST(fill),
			      NUM2UINT(padding), FIX2INT(pack_type));
    return self;
}

void Init_gtk_box()
{
    gBox = rb_define_class_under(mGtk, "Box", gContainer);

    /* rb_define_const(gBox, "SIGNAL_", rb_str_new2("")); */

    rb_define_method(gBox, "pack_start", box_pack_start, -1);
    rb_define_method(gBox, "pack_end", box_pack_end, -1);
    rb_define_method(gBox, "set_homogeneous", box_set_homogeneous, 1);
    rb_define_method(gBox, "set_spacing", box_set_spacing, 1);
    rb_define_method(gBox, "reorder_child", box_reorder_child, 2);
    rb_define_method(gBox, "query_child_packing", box_query_child_packing, 1);
    rb_define_method(gBox, "set_child_packing", box_set_child_packing, 5);
}


/*
 * ButtonBox
 */
static VALUE
bbox_get_child_size_default(self)
    VALUE self;
{
    int min_width, max_width;

    gtk_button_box_get_child_size_default(&min_width, &max_width);

    return rb_assoc_new(INT2FIX(min_width), INT2FIX(max_width));
}

static VALUE
bbox_get_child_ipadding_default(self)
    VALUE self;
{
    int ipad_x, ipad_y;

    gtk_button_box_get_child_ipadding_default(&ipad_x, &ipad_y);
    return rb_assoc_new(INT2FIX(ipad_x), INT2FIX(ipad_y));
}

static VALUE
bbox_set_child_size_default(self, min_width, max_width)
    VALUE self, min_width, max_width;
{
    gtk_button_box_set_child_size_default(NUM2INT(min_width),
					  NUM2INT(max_width));
    return Qnil;
}

static VALUE
bbox_set_child_ipadding_default(self, ipad_x, ipad_y)
    VALUE self, ipad_x, ipad_y;
{
    gtk_button_box_set_child_ipadding_default(NUM2INT(ipad_x),
					      NUM2INT(ipad_y));
    return Qnil;
}

static VALUE
bbox_get_spacing(self)
    VALUE self;
{
    int i = gtk_button_box_get_spacing(GTK_BUTTON_BOX(get_widget(self)));

    return INT2FIX(i);
}

static VALUE
bbox_get_layout(self)
    VALUE self;
{
    int i = gtk_button_box_get_layout(GTK_BUTTON_BOX(get_widget(self)));

    return INT2FIX(i);
}

static VALUE
bbox_get_child_size(self)
    VALUE self;
{
    int min_width, max_width;

    gtk_button_box_get_child_size(GTK_BUTTON_BOX(get_widget(self)),
				  &min_width, &max_width);
    return rb_assoc_new(INT2FIX(min_width), INT2FIX(max_width));
}

static VALUE
bbox_get_child_ipadding(self)
    VALUE self;
{
    int ipad_x, ipad_y;

    gtk_button_box_get_child_ipadding(GTK_BUTTON_BOX(get_widget(self)),
				      &ipad_x, &ipad_y);
    return rb_assoc_new(INT2FIX(ipad_x), INT2FIX(ipad_y));
}

static VALUE
bbox_set_spacing(self, spacing)
    VALUE self, spacing;
{
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(get_widget(self)),
			       NUM2INT(spacing));
    return self;
}

static VALUE
bbox_set_layout(self, layout)
    VALUE self, layout;
{
    gtk_button_box_set_layout(GTK_BUTTON_BOX(get_widget(self)),
			      NUM2INT(layout));
    return self;
}

static VALUE
bbox_set_child_size(self, min_width, max_width)
    VALUE self, min_width, max_width;
{
    gtk_button_box_set_child_size(GTK_BUTTON_BOX(get_widget(self)),
				  NUM2INT(min_width),
				  NUM2INT(max_width));
    return self;
}

static VALUE
bbox_set_child_ipadding(self, ipad_x, ipad_y)
    VALUE self, ipad_x, ipad_y;
{
    gtk_button_box_set_child_ipadding(GTK_BUTTON_BOX(get_widget(self)),
				      NUM2INT(ipad_x),
				      NUM2INT(ipad_y));
    return self;
}

void Init_gtk_button_box()
{
    gBBox = rb_define_class_under(mGtk, "ButtonBox", gBox);

    rb_define_singleton_method(gBBox, "get_child_size_default",
			       bbox_get_child_size_default, 0);
    rb_define_singleton_method(gBBox, "get_child_ipadding_default",
			       bbox_get_child_ipadding_default, 0);
    rb_define_singleton_method(gBBox, "set_child_size_default",
			       bbox_set_child_size_default, 2);
    rb_define_singleton_method(gBBox, "set_child_ipadding_default",
			       bbox_set_child_ipadding_default, 2);
    rb_define_method(gBBox, "get_spacing", bbox_get_spacing, 0);
    rb_define_method(gBBox, "get_layout", bbox_get_layout, 0);
    rb_define_method(gBBox, "get_child_size", bbox_get_child_size, 0);
    rb_define_method(gBBox, "get_child_ipadding", bbox_get_child_ipadding, 0);
    rb_define_method(gBBox, "set_spacing", bbox_set_spacing, 1);
    rb_define_method(gBBox, "set_layout", bbox_set_layout, 1);
    rb_define_method(gBBox, "set_child_size", bbox_set_child_size, 2);
    rb_define_method(gBBox, "set_child_ipadding", bbox_set_child_ipadding, 2);

    /* rb_define_const(gBBox, "DEFAULT", INT2FIX(GTK_BUTTONBOX_DEFAULT)); */
    /*
      rb_define_const(gBBox, "DEFAULT_STYLE",INT2FIX(GTK_BUTTONBOX_DEFAULT_STYLE));
      rb_define_const(gBBox, "SPREAD", INT2FIX(GTK_BUTTONBOX_SPREAD));
      rb_define_const(gBBox, "EDGE", INT2FIX(GTK_BUTTONBOX_EDGE));
      rb_define_const(gBBox, "START", INT2FIX(GTK_BUTTONBOX_START));
      rb_define_const(gBBox, "END", INT2FIX(GTK_BUTTONBOX_END));
    */
}

/*
 * HButtonBox
 */
static VALUE
hbbox_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_hbutton_box_new());
    return Qnil;
}

static VALUE
hbbox_get_spacing_default(self)
    VALUE self;
{
    int i = gtk_hbutton_box_get_spacing_default();
    
    return INT2FIX(i);
}

static VALUE
hbbox_get_layout_default(self)
    VALUE self;
{
    int i = gtk_hbutton_box_get_layout_default();
    
    return INT2FIX(i);
}

static VALUE
hbbox_set_spacing_default(self, spacing)
    VALUE self, spacing;
{
    gtk_hbutton_box_set_spacing_default(NUM2INT(spacing));
    return Qnil;
}

static VALUE
hbbox_set_layout_default(self, layout)
    VALUE self, layout;
{
    gtk_hbutton_box_set_layout_default(NUM2INT(layout));
    return Qnil;
}

void Init_gtk_hbutton_box()
{
    gHBBox = rb_define_class_under(mGtk, "HButtonBox", gBBox);

    rb_define_method(gHBBox, "initialize", hbbox_initialize, 0);
    rb_define_singleton_method(gHBBox, "get_spacing_default",
			       hbbox_get_spacing_default, 0);
    rb_define_singleton_method(gHBBox, "get_layout_default",
			       hbbox_get_layout_default, 0);
    rb_define_singleton_method(gHBBox, "set_spacing_default",
			       hbbox_set_spacing_default, 1);
    rb_define_singleton_method(gHBBox, "set_layout_default",
			       hbbox_set_layout_default, 1);
}

/*
 * VButtonBox
 */
static VALUE
vbbox_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_vbutton_box_new());
    return Qnil;
}

static VALUE
vbbox_get_spacing_default(self)
    VALUE self;
{
    int i = gtk_vbutton_box_get_spacing_default();
    
    return INT2FIX(i);
}

static VALUE
vbbox_get_layout_default(self)
    VALUE self;
{
    int i = gtk_vbutton_box_get_layout_default();
    
    return INT2FIX(i);
}

static VALUE
vbbox_set_spacing_default(self, spacing)
    VALUE self, spacing;
{
    gtk_vbutton_box_set_spacing_default(NUM2INT(spacing));
    return Qnil;
}

static VALUE
vbbox_set_layout_default(self, layout)
    VALUE self, layout;
{
    gtk_vbutton_box_set_layout_default(NUM2INT(layout));
    return Qnil;
}

void Init_gtk_vbutton_box()
{
    gVBBox = rb_define_class_under(mGtk, "VButtonBox", gBBox);

    rb_define_method(gVBBox, "initialize", vbbox_initialize, 0);
    rb_define_singleton_method(gVBBox, "get_spacing_default",
			       vbbox_get_spacing_default, 0);
    rb_define_singleton_method(gVBBox, "get_layout_default",
			       vbbox_get_layout_default, 0);
    rb_define_singleton_method(gVBBox, "set_spacing_default",
			       vbbox_set_spacing_default, 1);
    rb_define_singleton_method(gVBBox, "set_layout_default",
			       vbbox_set_layout_default, 1);
}

/*
 * HBox
 */
static VALUE
hbox_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE homogeneous, spacing;

    rb_scan_args(argc, argv, "02", &homogeneous, &spacing);

    set_widget(self, gtk_hbox_new(RTEST(homogeneous),
				  (NIL_P(spacing)?0:NUM2INT(spacing))));
    return Qnil;
}

void Init_gtk_hbox()
{
    gHBox = rb_define_class_under(mGtk, "HBox", gBox);

    /* rb_define_const(gHBox, "SIGNAL_", rb_str_new2("")); */

    rb_define_method(gHBox, "initialize", hbox_initialize, -1);
}

/*
 * Statusbar
 */
static VALUE
statusbar_initialize(self)
     VALUE self;
{
  set_widget(self, gtk_statusbar_new());
  return Qnil;
}

static VALUE
statusbar_push(self, id, text)
     VALUE self;
     VALUE id;
     VALUE text;
{
  gint message_id;
  message_id = gtk_statusbar_push(GTK_STATUSBAR(get_widget(self)), 
				  NUM2INT(id), STR2CSTR(text));
  return INT2FIX(message_id);
}

static VALUE
statusbar_pop(self, id)
     VALUE self;
     VALUE id;
{
  gtk_statusbar_pop(GTK_STATUSBAR(get_widget(self)), NUM2INT(id));
  return Qnil;

}

static VALUE
statusbar_get_context_id(self, text)
     VALUE self;
     VALUE text;
{
  gint context_id;
  context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(get_widget(self)),
					    STR2CSTR(text));
  return INT2FIX(context_id);
}

static VALUE
statusbar_remove(self, cid, mid)
     VALUE self;
     VALUE cid;
     VALUE mid;
{
  gtk_statusbar_remove(GTK_STATUSBAR(get_widget(self)),
		       NUM2INT(cid), NUM2INT(mid)); 
  return Qnil;
}

void Init_gtk_statusbar()
{
    gStatusBar = rb_define_class_under(mGtk, "Statusbar", gHBox);
    
    rb_define_const(gStatusBar, "SIGNAL_TEXT_PUSHDED", rb_str_new2("text_pushed"));
    rb_define_const(gStatusBar, "SIGNAL_TEXT_POPPED", rb_str_new2("text_popped"));

    rb_define_method(gStatusBar, "initialize", statusbar_initialize, 0);
    rb_define_method(gStatusBar, "push", statusbar_push, 2);
    rb_define_method(gStatusBar, "pop", statusbar_pop, 1);
    rb_define_method(gStatusBar, "get_context_id", statusbar_get_context_id, 1);
    rb_define_method(gStatusBar, "remove", statusbar_remove, 2);
}

/*
 * Combo
 */
static VALUE
combo_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_combo_new());
    return Qnil;
}

static VALUE
combo_val_in_list(self, val, ok)
    VALUE self, val, ok;
{
    gtk_combo_set_value_in_list(GTK_COMBO(get_widget(self)),
				RTEST(val), RTEST(ok));
    return Qnil;
}

static VALUE
combo_use_arrows(self, val)
    VALUE self, val;
{
    gtk_combo_set_use_arrows(GTK_COMBO(get_widget(self)),
			     RTEST(val));
    return Qnil;
}

static VALUE
combo_case_sensitive(self, val)
    VALUE self, val;
{
    gtk_combo_set_case_sensitive(GTK_COMBO(get_widget(self)),
				 RTEST(val));
    return Qnil;
}

static VALUE
combo_item_string(self, item, val)
    VALUE self, item, val;
{
    gtk_combo_set_item_string(GTK_COMBO(get_widget(self)),
			      GTK_ITEM(get_widget(self)),
			      NIL_P(val)?NULL:STR2CSTR(val));
    return Qnil;
}

static VALUE
combo_popdown_strings(self, ary)
    VALUE self, ary;
{
    int i;
    GList *glist = NULL;

    Check_Type(ary, T_ARRAY);
    for (i=0; i<RARRAY(ary)->len; i++) {
	/* check to avoid memory leak */
	STR2CSTR(RARRAY(ary)->ptr[i]);
    }
    for (i=0; i<RARRAY(ary)->len; i++) {
	glist = g_list_append(glist,STR2CSTR(RARRAY(ary)->ptr[i]));
    }

    gtk_combo_set_popdown_strings(GTK_COMBO(get_widget(self)), glist);
    return Qnil;
}

static VALUE
combo_disable_activate(self)
    VALUE self;
{
    gtk_combo_disable_activate(GTK_COMBO(get_widget(self)));
    return Qnil;
}

static VALUE
combo_entry(self)
    VALUE self;
{
    return make_widget(gEntry, GTK_COMBO(get_widget(self))->entry);
}

static VALUE
combo_button(self)
    VALUE self;
{
    return make_widget(gButton, GTK_COMBO(get_widget(self))->button);
}

static VALUE
combo_popup(self)
    VALUE self;
{
    return make_widget(gScrolledWin, GTK_COMBO(get_widget(self))->popup);
}

static VALUE
combo_popwin(self)
    VALUE self;
{
    return make_widget(gWindow, GTK_COMBO(get_widget(self))->popwin);
}

static VALUE
combo_list(self)
    VALUE self;
{
    return make_widget(gList, GTK_COMBO(get_widget(self))->list);
}

void Init_gtk_combo()
{
    gCombo = rb_define_class_under(mGtk, "Combo", gHBox);

    rb_define_method(gCombo, "initialize", combo_initialize, 0);
    rb_define_method(gCombo, "set_value_in_list", combo_val_in_list, 2);
    rb_define_method(gCombo, "set_use_arrows", combo_use_arrows, 1);
    rb_define_method(gCombo, "set_case_sensitive", combo_case_sensitive, 1);
    rb_define_method(gCombo, "set_item_string", combo_item_string, 2);
    rb_define_method(gCombo, "set_popdown_strings", combo_popdown_strings, 1);
    rb_define_method(gCombo, "disable_activate", combo_disable_activate, 0);

    rb_define_method(gCombo, "entry", combo_entry, 0);
    rb_define_method(gCombo, "button", combo_button, 0);
    rb_define_method(gCombo, "popup", combo_popup, 0);
    rb_define_method(gCombo, "popwin", combo_popwin, 0);
    rb_define_method(gCombo, "list", combo_list, 0);
}

/*
 * VBox
 */
static VALUE
vbox_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE homogeneous, spacing;

    rb_scan_args(argc, argv, "02", &homogeneous, &spacing);

    set_widget(self, gtk_vbox_new(RTEST(homogeneous),
				  (NIL_P(spacing)?0:NUM2INT(spacing))));
    return Qnil;
}

void Init_gtk_vbox()
{
    gVBox = rb_define_class_under(mGtk, "VBox", gBox);

    /* rb_define_const(gVBox, "SIGNAL_", rb_str_new2("")); */

    rb_define_method(gVBox, "initialize", vbox_initialize, -1);
}

/*
 * GammaCurve
 */
static VALUE
gamma_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_gamma_curve_new());
    return Qnil;
}

static VALUE
gamma_gamma(self)
    VALUE self;
{
    return rb_float_new(GTK_GAMMA_CURVE(get_widget(self))->gamma);
}

static VALUE
gamma_curve(self)
    VALUE self;
{
    return make_gobject(gCurve, GTK_OBJECT(GTK_GAMMA_CURVE(get_widget(self))->curve));
}

void Init_gtk_gamma_curve()
{
    gGamma = rb_define_class_under(mGtk, "GammaCurve", gVBox);

    rb_define_method(gGamma, "initialize", gamma_initialize, 0);
    rb_define_method(gGamma, "gamma", gamma_gamma, 0);
    rb_define_method(gGamma, "curve", gamma_curve, 0);
}

/*
 * ColorSelection
 */
static VALUE
colorsel_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_color_selection_new());
    return Qnil;
}

static VALUE
colorsel_set_update_policy(self, policy)
    VALUE self, policy;
{
    gtk_color_selection_set_update_policy(GTK_COLOR_SELECTION(get_widget(self)),
					  (GtkUpdateType)NUM2INT(policy));
    return self;
}

static VALUE
colorsel_set_opacity(self, opacity)
    VALUE self, opacity;
{
    gtk_color_selection_set_opacity(GTK_COLOR_SELECTION(get_widget(self)),
				    RTEST(opacity));
    return self;
}

static VALUE
colorsel_set_color(self, color)
    VALUE self, color;
{
    double buf[4];
    int arylen;
    GtkColorSelection *colorsel;

    Check_Type(color, T_ARRAY);
    colorsel = GTK_COLOR_SELECTION(get_widget(self));
    if (colorsel->use_opacity) {
	arylen = 4;
    } else {
	arylen = 3;
    }
    if (RARRAY(color)->len < arylen) {
	rb_raise(rb_eArgError, "color array too small");
    }
    buf[0] = NUM2DBL(RARRAY(color)->ptr[0]);
    buf[1] = NUM2DBL(RARRAY(color)->ptr[1]);
    buf[2] = NUM2DBL(RARRAY(color)->ptr[2]);
    if (arylen == 4) {
	buf[3] = NUM2DBL(RARRAY(color)->ptr[3]);
    }

    gtk_color_selection_set_color(colorsel, buf);
    return self;
}

static VALUE
colorsel_get_color(self)
    VALUE self;
{
    double buf[4];
    VALUE ary;
    int arylen;
    GtkColorSelection *colorsel;

    colorsel = GTK_COLOR_SELECTION(get_widget(self));
    gtk_color_selection_get_color(colorsel, buf);
    if (colorsel->use_opacity) {
	arylen = 4;
    } else {
	arylen = 3;
    }
    ary = rb_ary_new2(arylen);
    rb_ary_push(ary, rb_float_new(buf[0]));
    rb_ary_push(ary, rb_float_new(buf[1]));
    rb_ary_push(ary, rb_float_new(buf[2]));
    if (arylen == 4) {
	rb_ary_push(ary, rb_float_new(buf[3]));
    }
    return ary;
}

void Init_gtk_color_selection()
{
    gColorSel = rb_define_class_under(mGtk, "ColorSelection", gVBox);

    rb_define_const(gColorSel, "SIGNAL_COLOR_CHANGED", rb_str_new2("color_changed"));

    rb_define_method(gColorSel, "initialize", colorsel_initialize, 0);
    rb_define_method(gColorSel, "set_update_policy", colorsel_set_update_policy, 1);
    rb_define_method(gColorSel, "set_opacity", colorsel_set_opacity, 1);
    rb_define_method(gColorSel, "set_color", colorsel_set_color, 1);
    rb_define_method(gColorSel, "get_color", colorsel_get_color, 0);
}
