#include "global.h"
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif

VALUE gtk_object_list;
VALUE mGtk;
VALUE gObject;
VALUE gWidget;
VALUE gContainer;
VALUE gBin;
VALUE gAlignment;
VALUE gMisc;
VALUE gArrow;
VALUE gFrame;
VALUE gAspectFrame;
VALUE gData;
VALUE gAdjustment;
VALUE gBox;
VALUE gButton;
VALUE gTButton;
VALUE gCButton;
VALUE gRButton;
VALUE gBBox;
VALUE gCList;
VALUE gCTree;
VALUE gCTreeNode;
VALUE gWindow;
VALUE gDialog;
VALUE gFileSel;
VALUE gVBox;
VALUE gColorSel;
VALUE gColorSelDialog;
VALUE gCombo;
VALUE gImage;
VALUE gDrawArea;
VALUE gEditable;
VALUE gEntry;
VALUE gSButton;
VALUE gEventBox;
VALUE gFixed;
VALUE gGamma;
VALUE gCurve;
VALUE gHBBox;
VALUE gVBBox;
VALUE gHBox;
VALUE gPaned;
VALUE gHPaned;
VALUE gVPaned;
VALUE gRuler;
VALUE gHRuler;
VALUE gVRuler;
VALUE gRange;
VALUE gScale;
VALUE gHScale;
VALUE gVScale;
VALUE gScrollbar;
VALUE gHScrollbar;
VALUE gVScrollbar;
VALUE gSeparator;
VALUE gHSeparator;
VALUE gVSeparator;
VALUE gInputDialog;
VALUE gLabel;
VALUE gList;
VALUE gItem;
VALUE gListItem;
VALUE gMenuShell;
VALUE gMenu;
VALUE gMenuBar;
VALUE gMenuItem;
VALUE gCMenuItem;
VALUE gRMenuItem;
VALUE gTMenuItem;
VALUE gNotebook;
VALUE gNotePage;
VALUE gOptionMenu;
VALUE gPixmap;
VALUE gPreview;
VALUE gProgress;
VALUE gProgressBar;
VALUE gScrolledWin;
VALUE gStatusBar;
VALUE gTable;
VALUE gText;
VALUE gToolbar;
VALUE gTooltips;
VALUE gTipsQuery;
VALUE gTree;
VALUE gTreeItem;
VALUE gViewport;

VALUE gAccelGroup;
VALUE gAcceleratorTable;
VALUE gStyle;
VALUE gRcStyle;
VALUE gPreviewInfo;
VALUE gAllocation;
VALUE gRequisition;
VALUE gItemFactory;

VALUE mRC;

static ID id_gtkdata;
static ID id_relatives;
static ID id_call;
static VALUE warn_handler;
static VALUE mesg_handler;
static VALUE print_handler;

static void
gobj_mark(obj)
    GtkObject *obj;
{
    /* just for type mark */
}

GtkObject*
get_gobject(obj)
    VALUE obj;
{
    struct RData *data;
    GtkObject *gtkp;

    if (NIL_P(obj)) { 
	rb_raise(rb_eTypeError, "wrong argument type nil");
    }

    Check_Type(obj, T_OBJECT);
    data = RDATA(rb_ivar_get(obj, id_gtkdata));
    if (NIL_P(data) || data->dmark != gobj_mark) {
	rb_raise(rb_eTypeError, "not a Gtk object");
    }
    Data_Get_Struct(data, GtkObject, gtkp);
    if (!gtkp) {
	rb_raise(rb_eArgError, "destroyed GtkObject");
    }
    if (!GTK_IS_OBJECT(gtkp)) {
	rb_raise(rb_eTypeError, "not a GtkObject");
    }

    return gtkp;
}

static void
delete_gobject(gtkobj, obj)
    GtkObject *gtkobj;
    VALUE obj;
{
    struct RData *data;

    rb_hash_aset(gtk_object_list, INT2NUM(obj), Qnil);
    data = RDATA(rb_ivar_get(obj, id_gtkdata));
    data->dfree = 0;
    data->data = 0;
}

void
set_gobject(obj, gtkobj)
    VALUE obj;
    GtkObject *gtkobj;
{
    VALUE data;

    data = Data_Wrap_Struct(rb_cData, gobj_mark, 0, gtkobj);
    gtk_object_set_user_data(gtkobj, (gpointer)obj);

    rb_ivar_set(obj, id_relatives, Qnil);

    rb_ivar_set(obj, id_gtkdata, data);
    gtk_signal_connect(gtkobj, "destroy",
		       (GtkSignalFunc)delete_gobject, (gpointer)obj);
    rb_hash_aset(gtk_object_list, INT2NUM(obj), obj);
}

static VALUE
nil()
{
    return Qnil;
}

static GtkObject*
try_get_gobject(self)
    VALUE self;
{
    return (GtkObject*)rb_rescue((VALUE(*)())get_gobject, self, nil, 0);
}

GtkWidget*
get_widget(obj)
    VALUE obj;
{
    GtkObject *data = get_gobject(obj);

    return GTK_WIDGET(data);
}

static GtkWidget*
try_get_widget(obj)
    VALUE obj;
{
    GtkObject *data = try_get_gobject(obj);

    return GTK_WIDGET(data);
}

VALUE
get_value_from_gobject(obj)
    GtkObject *obj;
{
    return (VALUE)gtk_object_get_user_data(obj);
}

static void
clear_gobject(obj)
    VALUE obj;
{
    rb_ivar_set(obj, id_relatives, Qnil);
}

void
add_relative(obj, relative)
    VALUE obj, relative;
{
    VALUE ary = rb_ivar_get(obj, id_relatives);

    if (NIL_P(ary) || TYPE(ary) != T_ARRAY) {
	ary = rb_ary_new();
	rb_ivar_set(obj, id_relatives, ary);
    }
    rb_ary_push(ary, relative);
}

VALUE
make_gobject(klass, gtkobj)
    VALUE klass;
    GtkObject *gtkobj;
{
    VALUE obj = rb_obj_alloc(klass);

    set_gobject(obj, gtkobj);
    return obj;
}

void
set_widget(obj, widget)
    VALUE obj;
    GtkWidget *widget;
{
    set_gobject(obj, GTK_OBJECT(widget));
}

VALUE
make_widget(klass, widget)
    VALUE klass;
    GtkWidget *widget;
{
    return make_gobject(klass, GTK_OBJECT(widget));
}

VALUE
get_gtk_type(gtkobj)
    GtkObject *gtkobj;
{
    VALUE klass;

    if (0);
    else if GTK_IS_HSEPARATOR(gtkobj) klass = gHSeparator;
    else if GTK_IS_VSEPARATOR(gtkobj) klass = gVSeparator;
    else if GTK_IS_SEPARATOR(gtkobj) klass = gSeparator;
    else if GTK_IS_HRULER(gtkobj) klass = gHRuler;
    else if GTK_IS_VRULER(gtkobj) klass = gVRuler;
    else if GTK_IS_RULER(gtkobj) klass = gRuler;
    else if GTK_IS_HSCROLLBAR(gtkobj) klass = gHScrollbar;
    else if GTK_IS_VSCROLLBAR(gtkobj) klass = gVScrollbar;
    else if GTK_IS_SCROLLBAR(gtkobj) klass = gScrollbar;
    else if GTK_IS_HSCALE(gtkobj) klass = gHScale;
    else if GTK_IS_VSCALE(gtkobj) klass = gVScale;
    else if GTK_IS_SCALE(gtkobj) klass = gScale;
    else if GTK_IS_RANGE(gtkobj) klass = gRange;
    else if GTK_IS_PROGRESS_BAR(gtkobj) klass = gProgressBar;
    else if GTK_IS_PROGRESS(gtkobj) klass = gProgress;
    else if GTK_IS_PREVIEW(gtkobj) klass = gPreview;
    else if GTK_IS_PIXMAP(gtkobj) klass = gPixmap;
    else if GTK_IS_TIPS_QUERY(gtkobj) klass = gTipsQuery;
    else if GTK_IS_LABEL(gtkobj) klass = gLabel;
    else if GTK_IS_LAYOUT(gtkobj) klass = gLayout;
    else if GTK_IS_IMAGE(gtkobj) klass = gImage;
    else if GTK_IS_ARROW(gtkobj) klass = gArrow;
    else if GTK_IS_MISC(gtkobj) klass = gMisc;
    else if GTK_IS_TEXT(gtkobj) klass = gText;
    else if GTK_IS_SPIN_BUTTON(gtkobj) klass = gSButton;
    else if GTK_IS_ENTRY(gtkobj) klass = gEntry;
    else if GTK_IS_EDITABLE(gtkobj) klass = gEditable;
    else if GTK_IS_CURVE(gtkobj) klass = gCurve;
    else if GTK_IS_DRAWING_AREA(gtkobj) klass = gDrawArea;
    else if GTK_IS_TREE(gtkobj) klass = gTree;
    else if GTK_IS_TOOLBAR(gtkobj) klass = gToolbar;
    else if GTK_IS_TABLE(gtkobj) klass = gTable;
    else if GTK_IS_SCROLLED_WINDOW(gtkobj) klass = gScrolledWin;
    else if GTK_IS_VPANED(gtkobj) klass = gVPaned;
    else if GTK_IS_HPANED(gtkobj) klass = gHPaned;
    else if GTK_IS_PANED(gtkobj) klass = gPaned;
    else if GTK_IS_NOTEBOOK(gtkobj) klass = gNotebook;
    else if GTK_IS_MENU_BAR(gtkobj) klass = gMenuBar;
    else if GTK_IS_MENU(gtkobj) klass = gMenu;
    else if GTK_IS_MENU_SHELL(gtkobj) klass = gMenuShell;
    else if GTK_IS_LIST(gtkobj) klass = gList;
    else if GTK_IS_FIXED(gtkobj) klass = gFixed;
    else if GTK_IS_CTREE(gtkobj) klass = gCTree;
    else if GTK_IS_CLIST(gtkobj) klass = gCList;
    else if GTK_IS_RADIO_BUTTON(gtkobj) klass = gRButton;
    else if GTK_IS_CHECK_BUTTON(gtkobj) klass = gCButton;
    else if GTK_IS_TOGGLE_BUTTON(gtkobj) klass = gTButton;
    else if GTK_IS_OPTION_MENU(gtkobj) klass = gOptionMenu;
    else if GTK_IS_BUTTON(gtkobj) klass = gButton;
    else if GTK_IS_GAMMA_CURVE(gtkobj) klass = gGamma;
    else if GTK_IS_COLOR_SELECTION(gtkobj) klass = gColorSel;
    else if GTK_IS_VBOX(gtkobj) klass = gVBox;
    else if GTK_IS_STATUSBAR(gtkobj) klass = gStatusBar;
    else if GTK_IS_COMBO(gtkobj) klass = gCombo;
    else if GTK_IS_HBOX(gtkobj) klass = gHBox;
    else if GTK_IS_HBUTTON_BOX(gtkobj) klass = gHBBox;
    else if GTK_IS_VBUTTON_BOX(gtkobj) klass = gVBBox;
    else if GTK_IS_BUTTON_BOX(gtkobj) klass = gBBox;
    else if GTK_IS_BOX(gtkobj) klass = gBox;
    else if GTK_IS_FILE_SELECTION(gtkobj) klass = gFileSel;
    else if GTK_IS_INPUT_DIALOG(gtkobj) klass = gInputDialog;
    else if GTK_IS_DIALOG(gtkobj) klass = gDialog;
    else if GTK_IS_COLOR_SELECTION_DIALOG(gtkobj) klass = gColorSelDialog;
    else if GTK_IS_WINDOW(gtkobj) klass = gWindow;
    else if GTK_IS_VIEWPORT(gtkobj) klass = gViewport;
    else if GTK_IS_TREE_ITEM(gtkobj) klass = gTreeItem;
    else if GTK_IS_TEAROFF_MENU_ITEM(gtkobj) klass = gTMenuItem;
    else if GTK_IS_RADIO_MENU_ITEM(gtkobj) klass = gRMenuItem;
    else if GTK_IS_CHECK_MENU_ITEM(gtkobj) klass = gCMenuItem;
    else if GTK_IS_MENU_ITEM(gtkobj) klass = gMenuItem;
    else if GTK_IS_LIST_ITEM(gtkobj) klass = gListItem;
    else if GTK_IS_ITEM(gtkobj) klass = gItem;
    else if GTK_IS_ASPECT_FRAME(gtkobj) klass = gAspectFrame;
    else if GTK_IS_EVENT_BOX(gtkobj) klass = gEventBox;
    else if GTK_IS_ALIGNMENT(gtkobj) klass = gAlignment;
    else if GTK_IS_CONTAINER(gtkobj) klass = gContainer;
    else if GTK_IS_WIDGET(gtkobj) klass = gWidget;
    else if GTK_IS_ADJUSTMENT(gtkobj) klass = gAdjustment;
    else if GTK_IS_TOOLTIPS(gtkobj) klass = gTooltips;
    else if GTK_IS_DATA(gtkobj) klass = gData;
    else if GTK_IS_OBJECT(gtkobj) klass = gObject;
    else {
	rb_raise(rb_eTypeError, "not a Gtk object");
    }
    return klass;
}

VALUE
make_gobject_auto_type(gtkobj)
    GtkObject *gtkobj;
{
    return make_gobject(get_gtk_type(gtkobj), gtkobj);
}

VALUE
make_gstyle(style)
    GtkStyle *style;
{
    gtk_style_ref(style);
    return Data_Wrap_Struct(gStyle, 0, gtk_style_unref, style);
}

GtkStyle*
get_gstyle(style)
    VALUE style;
{
    GtkStyle *gstyle;

    if (NIL_P(style)) return NULL;
    if (!rb_obj_is_instance_of(style, gStyle)) {
	rb_raise(rb_eTypeError, "not a GtkStyle");
    }
    Data_Get_Struct(style, GtkStyle, gstyle);

    return gstyle;
}

#ifndef NT
VALUE
make_grcstyle(style)
    GtkRcStyle *style;
{
    gtk_rc_style_ref(style);
    return Data_Wrap_Struct(gRcStyle, 0, gtk_rc_style_unref, style);
}
#endif

GtkRcStyle*
get_grcstyle(style)
    VALUE style;
{
    GtkRcStyle *gstyle;

    if (NIL_P(style)) return NULL;
    if (!rb_obj_is_instance_of(style, gRcStyle)) {
	rb_raise(rb_eTypeError, "not a GtkRcStyle");
    }
    Data_Get_Struct(style, GtkRcStyle, gstyle);

    return gstyle;
}

VALUE
make_gtkaccelgrp(accel)
    GtkAccelGroup *accel;
{
    gtk_accel_group_ref(accel);
    return Data_Wrap_Struct(gAccelGroup,
                            0,
                            gtk_accel_group_unref,
			    accel);
}

GtkAccelGroup*
get_gtkaccelgrp(value)
    VALUE value;
{
    GtkAccelGroup *accel;

    if (NIL_P(value)) return NULL;
    if (!rb_obj_is_instance_of(value, gAccelGroup)) {
        rb_raise(rb_eTypeError, "not a GtkAccelGroup");
    }
    Data_Get_Struct(value, GtkAccelGroup, accel);

    return accel;
}

#if 0
VALUE
make_gtkacceltbl(tbl)
    GtkAcceleratorTable *tbl;
{
    VALUE obj;

    gtk_accelerator_table_ref(tbl);
    return Data_Wrap_Struct(gAcceleratorTable, 0,
			    gtk_accelerator_table_unref, tbl);
}

GtkAcceleratorTable*
get_gtkacceltbl(value)
    VALUE value;
{
    GtkAcceleratorTable *tbl;

    if (NIL_P(value)) return NULL;

    if (!rb_obj_is_instance_of(value, gAcceleratorTable)) {
	rb_raise(rb_eTypeError, "not an AcceleratorTable");
    }
    Data_Get_Struct(value, GtkAcceleratorTable, tbl);

    return tbl;
}
#endif

VALUE
make_gtkprevinfo(info)
    GtkPreviewInfo *info;
{
    return Data_Wrap_Struct(gPreviewInfo, 0, 0, info);
}

GtkPreviewInfo*
get_gtkprevinfo(value)
    VALUE value;
{
    GtkPreviewInfo *info;

    if (NIL_P(value)) return NULL;

    if (!rb_obj_is_instance_of(value, gPreviewInfo)) {
	rb_raise(rb_eTypeError, "not a PreviewInfo");
    }
    Data_Get_Struct(value, GtkPreviewInfo, info);

    return info;
}

static void
signal_setup_args(obj, sig, argc, params, args)
    VALUE obj;
    ID sig;
    int argc;
    GtkArg *params;
    VALUE args;
{
    GtkArg *params1;
    int i;
    char *signame = rb_id2name(sig);

    if (rb_obj_is_kind_of(obj, gWidget)) {
	if (strcmp(signame, "draw") == 0) {
	    rb_ary_push(args, make_gdkrectangle(GTK_VALUE_POINTER(params[0])));
	    return;
	}
	if (strcmp(signame, "size_request") == 0) {
	    rb_ary_push(args, make_grequisition(GTK_VALUE_POINTER(params[0])));
	    return;
	}
	if (strcmp(signame, "size_allocate") == 0) {
	    rb_ary_push(args, make_gallocation(GTK_VALUE_POINTER(params[0])));
	    return;
	}
    }
    if (rb_obj_is_kind_of(obj, gWindow)) {
	if (strcmp(signame, "move_resize") == 0) {
	    rb_ary_push(args, INT2NUM(*GTK_RETLOC_INT(params[0])));
	    rb_ary_push(args, INT2NUM(*GTK_RETLOC_INT(params[1])));	
	    rb_ary_push(args, INT2NUM(GTK_VALUE_INT(params[3])));
	    rb_ary_push(args, INT2NUM(GTK_VALUE_INT(params[4])));
	    return;
	}
	if (strcmp(signame, "set_focus") == 0) {
	    rb_ary_push(args, get_value_from_gobject(GTK_VALUE_POINTER(params[0])));
	    return;
	}
    }
    if (rb_obj_is_kind_of(obj, gEntry)) {
	if (strcmp(signame, "insert_position") == 0) {
	    rb_ary_push(args, INT2NUM(*GTK_RETLOC_INT(params[0])));
	    return;
	}
    }
    if (rb_obj_is_kind_of(obj, gCList)) {
	if (strcmp(signame, "select_row") == 0 ||
	    strcmp(signame, "unselect_row") == 0) {
	    rb_ary_push(args, INT2NUM(GTK_VALUE_INT(params[0])));
	    rb_ary_push(args, INT2NUM(GTK_VALUE_INT(params[1])));
	    if (GTK_VALUE_POINTER(params[2]))
		rb_ary_push(args, make_gdkevent(GTK_VALUE_POINTER(params[2])));
	    else
		rb_ary_push(args, Qnil);
	    return;
	}
    }
    if (rb_obj_is_kind_of(obj, gNotebook)) {
	if (strcmp(signame, "switch_page") == 0) {
	    rb_ary_push(args, make_notepage((GtkNotebookPage*) GTK_VALUE_OBJECT(params[0])));
	    rb_ary_push(args, INT2FIX(GTK_VALUE_INT(params[1])));
	    return;
	}
    }
  
    params1 = params;
    for (i=0; i<argc; i++) {
	rb_ary_push(args, arg_to_value(params1));
	params1++;
    }
}

static void
signal_sync_args(obj, sig, argc, params, args)
    VALUE obj;
    ID sig;
    int argc;
    GtkArg *params;
    VALUE args;
{
    char *signame = rb_id2name(sig);

    if (rb_obj_is_kind_of(obj, gWidget)) {
	if (strcmp(signame, "size_request") == 0) {
	    memcpy(GTK_VALUE_POINTER(params[0]), get_grequisition(rb_ary_pop(args)),
		   sizeof(GtkRequisition));
	    return;
	}
    }
}

static void
arg_set_value(arg, value)
    GtkArg *arg;
    VALUE value;
{
    switch (GTK_FUNDAMENTAL_TYPE(arg->type)) {
    case GTK_TYPE_NONE:
	break;

    case GTK_TYPE_CHAR:
	*GTK_RETLOC_CHAR(*arg) = NUM2INT(value);
	break;
    case GTK_TYPE_BOOL:
	*GTK_RETLOC_BOOL(*arg) = (TYPE(value) == T_TRUE)? TRUE: FALSE;
	break;
    case GTK_TYPE_INT:
    case GTK_TYPE_ENUM:
    case GTK_TYPE_FLAGS:
	*GTK_RETLOC_INT(*arg) = NUM2INT(value);
	break;
    case GTK_TYPE_UINT:
	*GTK_RETLOC_UINT(*arg) = NUM2INT(value);
	break;
    case GTK_TYPE_LONG:
	*GTK_RETLOC_LONG(*arg) = NUM2INT(value);
	break;
    case GTK_TYPE_ULONG:
	*GTK_RETLOC_ULONG(*arg) = NUM2INT(value);
	break;

    case GTK_TYPE_FLOAT:
	value = rb_Float(value);
	*GTK_RETLOC_FLOAT(*arg) = (float)RFLOAT(value)->value;
	break;

    case GTK_TYPE_STRING:
	*GTK_RETLOC_STRING(*arg) = STR2CSTR(value);
	break;

    case GTK_TYPE_OBJECT:
	*GTK_RETLOC_OBJECT(*arg) = get_gobject(value);
	break;
	    
    case GTK_TYPE_POINTER:
	*GTK_RETLOC_POINTER(*arg) = (gpointer)value;
	break;

    case GTK_TYPE_BOXED:
	if (arg->type == GTK_TYPE_GDK_EVENT)
	    GTK_VALUE_BOXED(*arg) = get_gdkevent(value);
#ifdef GTK_TYPE_GDK_COLORMAP
	else if (arg->type == GTK_TYPE_GDK_COLORMAP)
	    GTK_VALUE_BOXED(*arg) = get_gdkcmap(value);
#endif
#ifdef GTK_TYPE_GDK_FONT
	else if (arg->type == GTK_TYPE_GDK_FONT)
	    GTK_VALUE_BOXED(*arg) = get_gdkfont(value);
#endif
#ifdef GTK_TYPE_GDK_PIXMAP
	else if (arg->type == GTK_TYPE_GDK_PIXMAP)
	    GTK_VALUE_BOXED(*arg) = get_gdkpixmap(value);
#endif
#ifdef GTK_TYPE_GDK_VISUAL
	else if (arg->type == GTK_TYPE_GDK_VISUAL)
	    GTK_VALUE_BOXED(*arg) = get_gdkvisual(value);
#endif
#ifdef GTK_TYPE_ACCEL_GROUP
        else if (arg->type == GTK_TYPE_ACCEL_GROUP)
	    GTK_VALUE_BOXED(*arg) = get_gtkaccelgrp(value);
#endif
#ifdef GTK_TYPE_ACCELERATOR_TABLE
	else if (arg->type == GTK_TYPE_ACCELERATOR_TABLE)
	    GTK_VALUE_BOXED(*arg) = get_gtkacceltbl(value);
#endif
#ifdef GTK_TYPE_STYLE
	else if (arg->type == GTK_TYPE_STYLE)
	    GTK_VALUE_BOXED(*arg) = get_gstyle(value);
#endif
#ifdef GTK_TYPE_TOOLTIPS
	else if (arg->type == GTK_TYPE_TOOLTIPS)
	    GTK_VALUE_BOXED(*arg) = get_widget(value);
#endif
	else
	    goto unsupported;

    unsupported:
    case GTK_TYPE_INVALID:
    case GTK_TYPE_FOREIGN:
    case GTK_TYPE_CALLBACK:
    case GTK_TYPE_ARGS:
    case GTK_TYPE_SIGNAL:
    case GTK_TYPE_C_CALLBACK:
    default:
	rb_raise(rb_eTypeError, "unsupported return type %s (fundamental type %s)",
		 gtk_type_name(arg->type),
		 gtk_type_name(GTK_FUNDAMENTAL_TYPE(arg->type)));
	break;
    }
}

void
exec_callback(widget, proc)
    GtkWidget *widget;
    gpointer proc;
{
    rb_funcall((VALUE)proc, id_call, 1,
	       get_value_from_gobject(GTK_OBJECT(widget)));
}

/*
 * Object
 */
void
signal_callback(widget, data, nparams, params)
    GtkWidget *widget;
    VALUE data;
    int nparams;
    GtkArg *params;
{
    VALUE self = get_value_from_gobject(GTK_OBJECT(widget));
    VALUE proc = RARRAY(data)->ptr[0];
    VALUE a = RARRAY(data)->ptr[2];
    ID id = NUM2INT(RARRAY(data)->ptr[1]);
    VALUE result = Qnil;
    VALUE args = rb_ary_new2(nparams+1+RARRAY(a)->len);
    int i;

    signal_setup_args(self, id, nparams, params, args);
    for (i=0; i<RARRAY(a)->len; i++) {
	rb_ary_push(args, RARRAY(a)->ptr[i]);
    }
    if (NIL_P(proc)) {
	if (rb_respond_to(self, id)) {
	    result = rb_apply(self, id, args);
	}
    }
    else {
	rb_ary_unshift(args, self);
	result = rb_apply(proc, id_call, args);
	rb_ary_shift(args);
    }
    if (params) {
	arg_set_value(params+nparams, result); /* I cannot understand it...?_? */
    }

    for (i=0; i<RARRAY(a)->len; i++) {
	rb_ary_pop(args);
    }
    signal_sync_args(self, id, nparams, params, args);
}

static VALUE
gobj_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    rb_raise(rb_eRuntimeError, "can't instantiate class %s", rb_class2name(self));
}

static VALUE
gobj_smethod_added(self, id)
    VALUE self, id;
{
    GtkObject *obj = get_gobject(self);
    char *name = rb_id2name(NUM2INT(id));
    
    if (gtk_signal_lookup(name, GTK_OBJECT_TYPE(obj))) {
	VALUE data = rb_ary_new3(3, Qnil, id, rb_ary_new2(0));

	add_relative(self, data);
	gtk_signal_connect_full(obj, name, NULL,
				signal_callback, (gpointer)data,
				NULL, FALSE, 0);
    }
    return Qnil;
}

static VALUE
gobj_equal(self, other)
    VALUE self, other;
{
    if (self == other) return Qtrue;
    if (get_gobject(self) == try_get_gobject(other)) return Qtrue;
    return Qfalse;
}

static VALUE
gobj_inspect(self)
    VALUE self;
{
    VALUE iv = rb_ivar_get(self, id_gtkdata);
    char *cname = rb_class2name(CLASS_OF(self));
    char *s;

    s = ALLOCA_N(char, strlen(cname)+8+16+1); /* 6:tags 16:addr 1:eos */
    if (NIL_P(iv) || RDATA(iv)->data == 0) {
	sprintf(s, "#<%s: destroyed>", cname);
    }
    else {
	sprintf(s, "#<%s: id=0x%x>", cname, get_gobject(self));
    }
    return rb_str_new2(s);
}

static VALUE
gobj_emit_stop(self, sig)
    VALUE self, sig;
{
    gtk_signal_emit_stop_by_name(GTK_OBJECT(get_gobject(self)),
                                 STR2CSTR(sig));
    return self;
}

static VALUE
gobj_destroy(self)
    VALUE self;
{
    VALUE iv = rb_ivar_get(self, id_gtkdata);

    if (NIL_P(iv) || RDATA(iv)->data == 0) {
	/* destroyed object */
	return Qnil;
    }
    gtk_object_destroy(get_gobject(self));
    clear_gobject(self);
    return Qnil;
}

static VALUE
gobj_get_flags(self)
    VALUE self;
{
    /* _GtkObject.flags is int32 */
    return(INT2FIX( GTK_OBJECT_FLAGS(get_gobject(self)) ));
}

static VALUE
gobj_set_flags(self, flags)
    VALUE self, flags;
{
    GtkObject *object = get_gobject(self);
    GTK_OBJECT_SET_FLAGS(object, NUM2INT(flags));
    return self;
}

static VALUE
gobj_unset_flags(self, flags)
    VALUE self, flags;
{
    GtkObject *object = get_gobject(self);
    GTK_OBJECT_UNSET_FLAGS(object, NUM2INT(flags));
    return self;
}

static VALUE
gobj_sig_connect(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE sig, data, args;
    ID id = 0;
    int i;

    rb_scan_args(argc, argv, "1*", &sig, &args);
    id = rb_intern(STR2CSTR(sig));
    data = rb_ary_new3(3, rb_f_lambda(), INT2NUM(id), args);
    add_relative(self, data);
    i = gtk_signal_connect_full(get_gobject(self),
				STR2CSTR(sig), NULL,
				signal_callback, (gpointer)data,
				NULL, FALSE, 0);

    return INT2FIX(i);
}

static VALUE
gobj_sig_connect_after(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE sig, data, args;
    ID id = 0;
    int i;

    rb_scan_args(argc, argv, "1*", &sig, &args);
    id = rb_intern(STR2CSTR(sig));
    data = rb_ary_new3(3, rb_f_lambda(), INT2NUM(id), args);
    add_relative(self, data);
    i = gtk_signal_connect_full(GTK_OBJECT(get_widget(self)),
				STR2CSTR(sig), NULL,
				signal_callback, (gpointer)data,
				NULL, FALSE, 1);

    return INT2FIX(i);
}

void Init_gtk_object()
{
    gObject = rb_define_class_under(mGtk, "Object", rb_cObject);

    /*
     * constants
     */
    rb_define_const(gObject, "DESTROYED", INT2NUM(GTK_DESTROYED));
    rb_define_const(gObject, "FLOATING", INT2NUM(GTK_FLOATING));
    rb_define_const(gObject, "CONNECTED", INT2NUM(GTK_CONNECTED));
    rb_define_const(gObject, "CONSTRUCTED", INT2NUM(GTK_CONSTRUCTED));
    /* 1.2.x
       rb_define_const(gObject, "RESERVED_2", INT2NUM(GTK_RESERVED_2));
       rb_define_const(gObject, "FLAG_LAST", INT2NUM(GTK_OBJECT_FLAG_LAST));
    */
    rb_define_const(gObject, "ARG_READABLE", INT2NUM(GTK_ARG_READABLE));
    rb_define_const(gObject, "ARG_WRITABLE", INT2NUM(GTK_ARG_WRITABLE));
    rb_define_const(gObject, "ARG_CONSTRUCT", INT2NUM(GTK_ARG_CONSTRUCT));
    rb_define_const(gObject, "ARG_READWRITE", INT2NUM(GTK_ARG_READWRITE));

    /*
     * signals
     */
    rb_define_const(gObject, "SIGNAL_DESTROY", rb_str_new2("destroy"));

    /*
     * instance methods
     */
    rb_define_method(gObject, "initialize", gobj_initialize, -1);
    rb_define_method(gObject, "flags", gobj_get_flags, 0);
    rb_define_method(gObject, "flags=", gobj_set_flags, 1);
    rb_define_method(gObject, "flags!=", gobj_unset_flags, 1);
    rb_define_method(gObject, "get_flags", gobj_get_flags, 0);
    rb_define_method(gObject, "set_flags", gobj_set_flags, 1);
    rb_define_method(gObject, "unset_flags", gobj_unset_flags, 1);

    rb_define_method(gObject, "destroy", gobj_destroy, 0);
    rb_define_method(gObject, "signal_connect", gobj_sig_connect, -1);
    rb_define_method(gObject, "signal_connect_after", gobj_sig_connect_after, -1);
    rb_define_method(gObject, "singleton_method_added", gobj_smethod_added, 1);
    rb_define_method(gObject, "==", gobj_equal, 1);
    rb_define_method(gObject, "inspect", gobj_inspect, 0);

    rb_define_method(gObject, "signal_emit_stop", gobj_emit_stop, 1);
}

/*
 * OptionMenu
 */
static VALUE
omenu_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_option_menu_new());
    return Qnil;
}

static VALUE
omenu_set_menu(self, child)
    VALUE self, child;
{
    rb_iv_set(self, "option_menu", child);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(get_widget(self)),
			     get_widget(child));
    return self;
}

static VALUE
omenu_get_menu(self)
    VALUE self;
{
    return rb_iv_get(self, "option_menu");
}

static VALUE
omenu_remove_menu(self)
    VALUE self;
{
    gtk_option_menu_remove_menu(GTK_OPTION_MENU(get_widget(self)));
    return self;
}

static VALUE
omenu_set_history(self, index)
    VALUE self, index;
{
    gtk_option_menu_set_history(GTK_OPTION_MENU(get_widget(self)),
				NUM2INT(index));
    return self;
}

void Init_gtk_option_menu()
{
    gOptionMenu = rb_define_class_under(mGtk, "OptionMenu", gButton);

    rb_define_method(gOptionMenu, "initialize", omenu_initialize, 0);
    rb_define_method(gOptionMenu, "get_menu", omenu_get_menu, 0);
    rb_define_method(gOptionMenu, "menu", omenu_get_menu, 0);
    rb_define_method(gOptionMenu, "set_menu", omenu_set_menu, 1);
    rb_define_method(gOptionMenu, "remove_menu", omenu_remove_menu, 0);
    rb_define_method(gOptionMenu, "set_history", omenu_set_history, 1);
}

/*
 * Preview
 */
static VALUE
preview_initialize(self, type)
    VALUE self, type;
{
    set_widget(self, gtk_preview_new((GtkPreviewType)NUM2INT(type)));
    return Qnil;
}

static VALUE
preview_size(self, w, h)
    VALUE self, w, h;
{
    gtk_preview_size(GTK_PREVIEW(get_widget(self)), NUM2INT(w), NUM2INT(h));
    return self;
}

static VALUE
preview_put(self, win, gc, srcx, srcy, dstx, dsty, w, h)
    VALUE self, win, gc, srcx, srcy, dstx, dsty, w, h;
{
    gtk_preview_put(GTK_PREVIEW(get_widget(self)), get_gdkwindow(win),
		    get_gdkgc(gc),
		    NUM2INT(srcx), NUM2INT(srcy),
		    NUM2INT(dstx), NUM2INT(dsty),
		    NUM2INT(w), NUM2INT(h));
    return self;
}
/* 1.2.x
static VALUE
preview_put_row(self, src, dst, x, y, w)
    VALUE self, src, dst, x, y, w;
{
    int width = NUM2INT(w);
    int dlen = width;

    if (GTK_PREVIEW(get_widget(self))->type == GTK_PREVIEW_COLOR) {
	dlen *= 3;
    }
    Check_Type(src, T_STRING);
    if (RSTRING(src)->len < dlen) {
	rb_raise(rb_eArgError, "src too short");
    }
    Check_Type(dst, T_STRING);
    if (RSTRING(dst)->len < dlen) {
	rb_raise(rb_eArgError, "dst too short");
    }
    rb_str_modify(dst);
    gtk_preview_put_row(GTK_PREVIEW(get_widget(self)),
			RSTRING(src)->ptr, RSTRING(dst)->ptr,
			NUM2INT(x), NUM2INT(y), width);
    return self;
}
*/
static VALUE
preview_draw_row(self, data, x, y, w)
    VALUE self, data, x, y, w;
{
    int width = NUM2INT(w);
    int dlen = width;

    if (GTK_PREVIEW(get_widget(self))->type == GTK_PREVIEW_COLOR) {
	dlen *= 3;
    }
    Check_Type(data, T_STRING);
    if (RSTRING(data)->len < dlen) {
	rb_raise(rb_eArgError, "data too short");
    }

    gtk_preview_draw_row(GTK_PREVIEW(get_widget(self)), RSTRING(data)->ptr,
			 NUM2INT(x), NUM2INT(y), width);
    return self;
}

static VALUE
preview_set_expand(self, expand)
    VALUE self, expand;
{
    gtk_preview_set_expand(GTK_PREVIEW(get_widget(self)), NUM2INT(expand));
    return self;
}

static VALUE
preview_set_gamma(self, gamma)
    VALUE self, gamma;
{
    gtk_preview_set_gamma(NUM2DBL(gamma));
    return Qnil;
}

static VALUE
preview_set_color_cube(self, nred, ngreen, nblue, ngray)
    VALUE self, nred, ngreen, nblue, ngray;
{
    gtk_preview_set_color_cube(NUM2INT(nred),
			       NUM2INT(ngreen),
			       NUM2INT(nblue),
			       NUM2INT(ngray));
    return Qnil;
}

static VALUE
preview_set_install_cmap(self, cmap)
    VALUE self, cmap;
{
    gtk_preview_set_install_cmap(RTEST(cmap));
    return Qnil;
}

static VALUE
preview_set_reserved(self, nreserved)
    VALUE self, nreserved;
{
    gtk_preview_set_reserved(NUM2INT(nreserved));
    return Qnil;
}

static VALUE
preview_get_visual(self)
    VALUE self;
{
    return make_gdkvisual(gtk_preview_get_visual());
}

static VALUE
preview_get_cmap(self)
    VALUE self;
{
    return make_gdkcmap(gtk_preview_get_cmap());
}

static VALUE
preview_get_info(self)
    VALUE self;
{
    GtkPreviewInfo *i = gtk_preview_get_info();
    return make_gtkprevinfo(i);
}

void Init_gtk_preview()
{
    gPreview = rb_define_class_under(mGtk, "Preview", gWidget);

    /*
     * instance methods
     */
    rb_define_method(gPreview, "initialize", preview_initialize, 1);
    rb_define_method(gPreview, "size", preview_size, 2);
    rb_define_method(gPreview, "put", preview_put, 8);
    /* 1.2.x
       rb_define_method(gPreview, "put_row", preview_put_row, 5);
    */
    rb_define_method(gPreview, "draw_row", preview_draw_row, 4);
    rb_define_method(gPreview, "set_expand", preview_set_expand, 1);

    /*
     * singleton methods
     */
    rb_define_singleton_method(gPreview, "set_gamma", preview_set_gamma, 1);
    rb_define_singleton_method(gPreview, "set_color_cube",
			       preview_set_color_cube, 4);
    rb_define_singleton_method(gPreview, "set_install_cmap",
			       preview_set_install_cmap, 1);
    rb_define_singleton_method(gPreview, "set_reserved",
			       preview_set_reserved, 1);
    rb_define_singleton_method(gPreview, "get_visual", preview_get_visual, 0);
    rb_define_singleton_method(gPreview, "get_cmap", preview_get_cmap, 0);
    rb_define_singleton_method(gPreview, "get_info", preview_get_info, 0);
}

/*
 * Progress
 */
static VALUE
progress_set_show_text(self, show_text)
     VALUE self, show_text;
{
    gtk_progress_set_show_text(GTK_PROGRESS(get_widget(self)),
			       RTEST(show_text));
    return self;
}

static VALUE
progress_show_text_p(self)
     VALUE self;
{
    gboolean result = GTK_PROGRESS(get_widget(self))->show_text;
    return result?Qtrue:Qfalse;
}

static VALUE
progress_set_text_alignment(self, x_align, y_align)
     VALUE self, x_align, y_align;
{
    gtk_progress_set_text_alignment(GTK_PROGRESS(get_widget(self)),
				    (gfloat)NUM2DBL(x_align),
				    (gfloat)NUM2DBL(y_align));
    return self;
}

static VALUE
progress_set_format_string(self, format)
     VALUE self, format;
{
    gtk_progress_set_format_string(GTK_PROGRESS(get_widget(self)),
				   STR2CSTR(format));
    return self;
}

static VALUE
progress_set_adjustment(self, adjustment)
     VALUE self, adjustment;
{
    gtk_progress_set_adjustment(GTK_PROGRESS(get_widget(self)),
				GTK_ADJUSTMENT(get_widget(adjustment)));
    return self;
}

static VALUE
progress_get_adjustment(self)
     VALUE self;
{
    GtkAdjustment* result = GTK_PROGRESS(get_widget(self))->adjustment;
    return result?get_value_from_gobject(GTK_OBJECT(result)):Qnil;
}

static VALUE
progress_set_percentage(self, percentage)
    VALUE self, percentage;
{
    gtk_progress_set_percentage(GTK_PROGRESS(get_widget(self)),
				(gfloat)NUM2DBL(percentage));
    return self;
}

static VALUE
progress_set_value(self, value)
    VALUE self, value;
{
    gtk_progress_set_value(GTK_PROGRESS(get_widget(self)),
			   (gfloat)NUM2DBL(value));
    return self;
}

static VALUE
progress_get_value(self)
     VALUE self;
{
    gfloat result;
    result = gtk_progress_get_value(GTK_PROGRESS(get_widget(self)));
    return rb_float_new((double)result);
}

static VALUE
progress_set_activity_mode(self, activity_mode)
     VALUE self, activity_mode;
{
    gtk_progress_set_activity_mode(GTK_PROGRESS(get_widget(self)),
				   RTEST(activity_mode));
    return self;
}

static VALUE
progress_activity_mode_p(self)
     VALUE self;
{
    gboolean result;
    result = GTK_PROGRESS(get_widget(self))->activity_mode;
    return result?Qtrue:Qfalse;
}

static VALUE
progress_get_current_text(self)
     VALUE self;
{
    gchar* result;
    result = gtk_progress_get_current_text(GTK_PROGRESS(get_widget(self)));
    return result?rb_str_new2(result):Qnil;
}

static VALUE
progress_get_text_from_value(self, value)
     VALUE self, value;
{
    gchar* result;
    result = gtk_progress_get_text_from_value(GTK_PROGRESS(get_widget(self)),
					      (gfloat)NUM2DBL(value));
    return result?rb_str_new2(result):Qnil;
}

static VALUE
progress_get_current_percentage(self)
     VALUE self;
{
    gfloat result;
    result = gtk_progress_get_current_percentage(
		GTK_PROGRESS(get_widget(self)));
    return rb_float_new((double)result);    
}

static VALUE
progress_get_percentage_from_value(self, value)
     VALUE self, value;
{
    gfloat result;
    result = gtk_progress_get_percentage_from_value(
		GTK_PROGRESS(get_widget(self)),
		(gfloat)NUM2DBL(value));
    return rb_float_new((double)result);
}

static VALUE
progress_configure(self, value, min, max)
     VALUE self, value, min, max;
{
    gtk_progress_configure(GTK_PROGRESS(get_widget(self)),
			   (gfloat)NUM2DBL(value),
			   (gfloat)NUM2DBL(min),
			   (gfloat)NUM2DBL(max));
    return self;
}

void Init_gtk_progress()
{
    gProgress = rb_define_class_under(mGtk, "Progress", gWidget);

    /*
     * instance methods
     */
    rb_define_method(gProgress, "set_show_text", progress_set_show_text, 1);
    rb_define_method(gProgress, "show_text=", progress_set_show_text, 1);
    rb_define_method(gProgress, "show_text?", progress_show_text_p, 0);
    rb_define_method(gProgress, "set_text_alignment", progress_set_text_alignment, 2);
    rb_define_method(gProgress, "set_format_string", progress_set_format_string, 1);
    rb_define_method(gProgress, "set_adjustment", progress_set_adjustment, 1);
    rb_define_method(gProgress, "adjustment=", progress_set_adjustment, 1);
    rb_define_method(gProgress, "adjustment", progress_get_adjustment, 0);
    rb_define_method(gProgress, "set_percentage", progress_set_percentage, 1);
    rb_define_method(gProgress, "set_value", progress_set_value, 1);
    rb_define_method(gProgress, "get_value", progress_get_value, 0);
    rb_define_method(gProgress, "set_activity_mode", progress_set_activity_mode, 1);
    rb_define_method(gProgress, "activity_mode=", progress_set_activity_mode, 1);
    rb_define_method(gProgress, "activity_mode?", progress_activity_mode_p, 0);
    rb_define_method(gProgress, "get_current_text", progress_get_current_text, 0);
    rb_define_method(gProgress, "get_text_from_value", progress_get_text_from_value, 1);
    rb_define_method(gProgress, "get_current_percentage", progress_get_current_percentage, 0);
    rb_define_method(gProgress, "get_percentage_from_value", progress_get_percentage_from_value, 1);
    rb_define_method(gProgress, "configure", progress_configure, 3);
}

/*
 * ProgressBar
 */
static VALUE
pbar_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg;
    GtkAdjustment *adj;
    GtkWidget* widget;

    if (rb_scan_args(argc, argv, "01", &arg) == 1) {
	adj = NIL_P(arg)?0:GTK_ADJUSTMENT(get_gobject(arg));
	widget = gtk_progress_bar_new_with_adjustment(adj);
    } else {
	widget = gtk_progress_bar_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
pbar_set_bar_style(self, style)
     VALUE self, style;
{
    gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR(get_widget(self)),
				   NUM2INT(style));
    return self;
}

static VALUE
pbar_set_discrete_blocks(self, blocks)
     VALUE self, blocks;
{
    gtk_progress_bar_set_discrete_blocks(GTK_PROGRESS_BAR(get_widget(self)),
					 NUM2INT(blocks));
    return self;
}

static VALUE
pbar_set_activity_step(self, step)
     VALUE self, step;
{
    gtk_progress_bar_set_activity_step(GTK_PROGRESS_BAR(get_widget(self)),
				       NUM2INT(step));
    return self;
}

static VALUE
pbar_set_activity_blocks(self, blocks)
     VALUE self, blocks;
{
    gtk_progress_bar_set_activity_blocks(GTK_PROGRESS_BAR(get_widget(self)),
					 NUM2INT(blocks));
    return self;
}

static VALUE
pbar_set_orientation(self, orientation)
     VALUE self, orientation;
{
    gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(get_widget(self)),
				     NUM2INT(orientation));
    return self;
}

static VALUE
pbar_update(self, percentage)
    VALUE self, percentage;
{
    gtk_progress_bar_update(GTK_PROGRESS_BAR(get_widget(self)),
			    NUM2DBL(percentage));
    return self;
}    

void Init_gtk_progress_bar()
{
    gProgressBar = rb_define_class_under(mGtk, "ProgressBar", gProgress);

    /* GtkProgressBarStyle */
    rb_define_const(gProgressBar, "CONTINUOUS", INT2FIX(GTK_PROGRESS_CONTINUOUS));
    rb_define_const(gProgressBar, "DISCRETE", INT2FIX(GTK_PROGRESS_DISCRETE));

    /* GtkProgressBarOrientation */
    rb_define_const(gProgressBar, "LEFT_TO_RIGHT", INT2FIX(GTK_PROGRESS_LEFT_TO_RIGHT));
    rb_define_const(gProgressBar, "RIGHT_TO_LEFT", INT2FIX(GTK_PROGRESS_RIGHT_TO_LEFT));
    rb_define_const(gProgressBar, "BOTTOM_TO_TOP", INT2FIX(GTK_PROGRESS_BOTTOM_TO_TOP));
    rb_define_const(gProgressBar, "TOP_TO_BOTTOM", INT2FIX(GTK_PROGRESS_TOP_TO_BOTTOM));

    rb_define_method(gProgressBar, "initialize", pbar_initialize, -1);
    rb_define_method(gProgressBar, "set_bar_style", pbar_set_bar_style, 1);
    rb_define_method(gProgressBar, "set_discrete_blocks", pbar_set_discrete_blocks, 1);
    rb_define_method(gProgressBar, "set_activity_step", pbar_set_activity_step, 1);
    rb_define_method(gProgressBar, "set_activity_blocks", pbar_set_activity_blocks, 1);
    rb_define_method(gProgressBar, "set_orientation", pbar_set_orientation, 1);
    rb_define_method(gProgressBar, "update", pbar_update, 1);
}

/*
 * DrawingArea
 */
static VALUE
darea_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_drawing_area_new());
    return Qnil;
}

static VALUE
darea_size(self, w, h)
    VALUE self, w, h;
{
    gtk_drawing_area_size(GTK_DRAWING_AREA(get_widget(self)),
			  NUM2INT(w), NUM2INT(h));
    return self;
}

void Init_gtk_drawing_area()
{
    gDrawArea = rb_define_class_under(mGtk, "DrawingArea", gWidget);

    rb_define_method(gDrawArea, "initialize", darea_initialize, 0);
    rb_define_method(gDrawArea, "size", darea_size, 2);
}

/*
 * Curve
 */
static VALUE
curve_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_curve_new());
    return Qnil;
}

static VALUE
curve_reset(self)
    VALUE self;
{
    gtk_curve_reset(GTK_CURVE(get_widget(self)));
    return self;
}

static VALUE
curve_set_gamma(self, gamma)
    VALUE self, gamma;
{
    gtk_curve_set_gamma(GTK_CURVE(get_widget(self)), NUM2DBL(gamma));
    return self;
}

static VALUE
curve_set_range(self, min_x, max_x, min_y, max_y)
    VALUE self, min_x, max_x, min_y, max_y;
{
    gtk_curve_set_range(GTK_CURVE(get_widget(self)),
			NUM2DBL(min_x), NUM2DBL(max_x),
			NUM2DBL(min_y), NUM2DBL(max_y));
    return self;
}

static VALUE
curve_set_curve_type(self, type)
    VALUE self, type;
{
    gtk_curve_set_curve_type(GTK_CURVE(get_widget(self)), NUM2INT(type));
    return self;
}

static VALUE
curve_set_vector(self, length, vector)
    VALUE self, length, vector;
{
    gint len = NUM2INT(length);
    gfloat *c_vec;
    gint i;

    c_vec = ALLOCA_N(gfloat, len);
    for (i = 0; i < len; i++)
      c_vec[i] = NUM2DBL(RARRAY(vector)->ptr[i]);
    gtk_curve_set_vector(GTK_CURVE(get_widget(self)), len, c_vec);
    return self;
}

static VALUE
curve_get_vector(self, length)
    VALUE self, length;
{
    gint len = NUM2INT(length);
    gfloat *c_vec;
    gint i;
    VALUE vector = rb_ary_new2(len);

    c_vec = ALLOCA_N(gfloat, len);
    gtk_curve_get_vector(GTK_CURVE(get_widget(self)), len, c_vec);
    for (i = 0; i < len; i++)
      rb_ary_push(vector, rb_float_new(c_vec[i]));
    return vector;
}

void Init_gtk_curve()
{
    gCurve = rb_define_class_under(mGtk, "Curve", gDrawArea);

    rb_define_const(gCurve, "SIGNAL_CURVE_TYPE_CHANGED", rb_str_new2("curve-type-changed"));

    rb_define_method(gCurve, "initialize", curve_initialize, 0);
    rb_define_method(gCurve, "reset", curve_reset, 0);
    rb_define_method(gCurve, "set_gamma", curve_set_gamma, 1);
    rb_define_method(gCurve, "set_range", curve_set_range, 4);
    rb_define_method(gCurve, "set_curve_type", curve_set_curve_type, 1);
    rb_define_method(gCurve, "set_vector", curve_set_vector, 2);
    rb_define_method(gCurve, "get_vector", curve_get_vector, 1);

    rb_define_const(gCurve, "CURVE_TYPE_LINEAR", INT2FIX(GTK_CURVE_TYPE_LINEAR));
    rb_define_const(gCurve, "CURVE_TYPE_SPLINE", INT2FIX(GTK_CURVE_TYPE_SPLINE));
    rb_define_const(gCurve, "CURVE_TYPE_FREE", INT2FIX(GTK_CURVE_TYPE_FREE));
}

/*
 * Ruler
 */
static VALUE
ruler_set_metric(self, metric)
    VALUE self, metric;
{
    gtk_ruler_set_metric(GTK_RULER(get_widget(self)), 
			 (GtkMetricType)NUM2INT(metric));

    return self;
}

static VALUE
ruler_set_range(self, lower, upper, position, max_size)
    VALUE self, lower, upper, position, max_size;
{
    gtk_ruler_set_range(GTK_RULER(get_widget(self)), 
			NUM2DBL(lower), NUM2DBL(upper),
			NUM2DBL(position), NUM2DBL(max_size));

    return self;
}

static VALUE
ruler_draw_ticks(self)
    VALUE self;
{
    gtk_ruler_draw_ticks(GTK_RULER(get_widget(self)));
    return self;
}

static VALUE
ruler_draw_pos(self)
    VALUE self;
{
    gtk_ruler_draw_pos(GTK_RULER(get_widget(self)));
    return self;
}

void Init_gtk_ruler()
{
    gRuler = rb_define_class_under(mGtk, "Ruler", gWidget);

    rb_define_method(gRuler, "set_metric", ruler_set_metric, 1);
    rb_define_method(gRuler, "set_range", ruler_set_range, 4);
    rb_define_method(gRuler, "draw_ticks", ruler_draw_ticks, 0);
    rb_define_method(gRuler, "draw_pos", ruler_draw_pos, 0);
}

/*
 * HRuler
 */
static VALUE
hruler_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_hruler_new());
    return Qnil;
}

void Init_gtk_hruler()
{
    gHRuler = rb_define_class_under(mGtk, "HRuler", gRuler);

    rb_define_method(gHRuler, "initialize", hruler_initialize, 0);
}

/*
 * VRuler
 */
static VALUE
vruler_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_vruler_new());
    return Qnil;
}

void Init_gtk_vruler()
{
    gVRuler = rb_define_class_under(mGtk, "VRuler", gRuler);

    rb_define_method(gVRuler, "initialize", vruler_initialize, 0);
}

/*
 * Separator
 */
void Init_gtk_separator()
{
    gSeparator = rb_define_class_under(mGtk, "Separator", gWidget);

    /* -- */
}

/*
 * HSeparator
 */
static VALUE
hsep_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_hseparator_new());
    return Qnil;
}

void Init_gtk_hseparator()
{
    gHSeparator = rb_define_class_under(mGtk, "HSeparator", gSeparator);

    rb_define_method(gHSeparator, "initialize", hsep_initialize, 0);
}

/*
 * VSeparator
 */
static VALUE
vsep_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_vseparator_new());
    return Qnil;
}

void Init_gtk_vseparator()
{
    gVSeparator = rb_define_class_under(mGtk, "VSeparator", gSeparator);

    rb_define_method(gVSeparator, "initialize", vsep_initialize, 0);
}

/* 
 * Allocation
 */
static VALUE
gallocation_new(VALUE self, VALUE x, VALUE y, VALUE w, VALUE h)
{
    GtkAllocation a;

    a.x = NUM2INT(x);
    a.y = NUM2INT(y);
    a.width = NUM2INT(w);
    a.height = NUM2INT(h);
    return make_gallocation(&a);
}

static VALUE
gallocation_x(self)
{
    return INT2NUM(get_gallocation(self)->x);
}

static VALUE
gallocation_y(self)
{
    return INT2NUM(get_gallocation(self)->y);
}

static VALUE
gallocation_w(self)
{
    return INT2NUM(get_gallocation(self)->width);
}

static VALUE
gallocation_h(self)
{
    return INT2NUM(get_gallocation(self)->height);
}

static VALUE
gallocation_to_a(self)
    VALUE self;
{
    GtkAllocation *a;

    a = get_gallocation(self);
    return rb_ary_new3(4, a->x, a->y, a->width, a->height);
}

static VALUE
gallocation_to_s(self)
    VALUE self;
{
    char str[2 +2*3 +5*4  +1]; /* member is guint16. max string size is 5 */
    GtkAllocation *a;

    a = get_gallocation(self);
    sprintf(str, "(%5d, %5d, %5d, %5d)", a->x, a->y, a->width, a->height);
    return rb_str_new2(str);
}
void Init_gtk_allocation()
{
    gAllocation = rb_define_class_under(mGtk, "Allocation", rb_cData);

    rb_define_singleton_method(gAllocation, "new", gallocation_new, 4);
    rb_define_method(gAllocation, "x", gallocation_x, 0);
    rb_define_method(gAllocation, "y", gallocation_y, 0);
    rb_define_method(gAllocation, "width", gallocation_w, 0);
    rb_define_method(gAllocation, "height", gallocation_h, 0);
    rb_define_method(gAllocation, "to_a", gallocation_to_a, 0);
    rb_define_method(gAllocation, "to_s", gallocation_to_s, 0);
}

/*
 * Main(Gtk module functions)
 */
static VALUE
gtk_m_events_pending(self)
    VALUE self;
{
    return INT2FIX(gtk_events_pending());
}

static VALUE
gtk_m_main(self)
    VALUE self;
{
    gtk_main();
    return Qnil;
}

static VALUE
gtk_m_main_level(self)
    VALUE self;
{
    return INT2FIX(gtk_main_level());
}

static VALUE
gtk_m_main_quit(self)
    VALUE self;
{
    gtk_main_quit();
    return Qnil;
}

static VALUE
gtk_m_main_iteration(self)
    VALUE self;
{
    gtk_main_iteration();
    return Qnil;
}

static VALUE
exec_interval(proc)
    VALUE proc;
{
    return RTEST(rb_funcall(proc, id_call, 0));
}

static VALUE
timeout_add(self, interval)
    VALUE self, interval;
{
    int id;
    VALUE func;

    func = rb_f_lambda();
    add_relative(self, func);
    id = gtk_timeout_add(NUM2INT(interval), (GtkFunction)exec_interval,
			 (gpointer)func);
    return INT2FIX(id);
}

static VALUE
timeout_remove(self, id)
    VALUE self, id;
{
    gtk_timeout_remove(NUM2INT(id));
    return Qnil;
}

static VALUE
idle_add(self)
    VALUE self;
{
    int id;
    VALUE func;

    func = rb_f_lambda();
    add_relative(self, func);
    id = gtk_idle_add((GtkFunction)exec_interval, (gpointer)func);
    return INT2FIX(id);
}

static VALUE
idle_remove(self, id)
    VALUE self, id;
{
    gtk_idle_remove(NUM2INT(id));
    return Qnil;
}

static void
gtkwarn(mesg)
    char *mesg;
{
    rb_funcall(warn_handler, id_call, 1, rb_str_new2(mesg));
}

static void
gtkmesg(mesg)
    char *mesg;
{
    rb_funcall(mesg_handler, id_call, 1, rb_str_new2(mesg));
}

static void
gtkprint(mesg)
    char *mesg;
{
    rb_funcall(print_handler, id_call, 1, rb_str_new2(mesg));
}


static VALUE
set_warning_handler(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE handler;

    rb_scan_args(argc, argv, "01", &handler);
    if (NIL_P(handler)) {
	handler = rb_f_lambda();
    }
    g_set_warning_handler(gtkwarn);
    return handler;
}

static VALUE
set_message_handler(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE handler;

    rb_scan_args(argc, argv, "01", &handler);
    if (NIL_P(handler)) {
	handler = rb_f_lambda();
    }
    g_set_message_handler(gtkmesg);
    return handler;
}

static VALUE
set_print_handler(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE handler;

    rb_scan_args(argc, argv, "01", &handler);
    if (NIL_P(handler)) {
	handler = rb_f_lambda();
    }
    g_set_print_handler(gtkprint);
    return handler;
}

void Init_gtk_main()
{
    rb_define_module_function(mGtk, "events_pending", gtk_m_events_pending, 0);
    rb_define_module_function(mGtk, "main", gtk_m_main, 0);
    rb_define_module_function(mGtk, "main_level", gtk_m_main_level, 0);
    rb_define_module_function(mGtk, "main_quit", gtk_m_main_quit, 0);
    rb_define_module_function(mGtk, "main_iteration", gtk_m_main_iteration, 0);
    rb_define_module_function(mGtk, "timeout_add", timeout_add, 1);
    rb_define_module_function(mGtk, "timeout_remove", timeout_remove, 1);
    rb_define_module_function(mGtk, "idle_add", idle_add, 0);
    rb_define_module_function(mGtk, "idle_remove", idle_remove, 1);

    rb_define_module_function(mGtk, "set_warning_handler",
			      set_warning_handler, -1);
    rb_define_module_function(mGtk, "set_message_handler",
			      set_message_handler, -1);
    rb_define_module_function(mGtk, "set_print_handler",
			      set_print_handler, -1);
}

/*
 * RC
 */
static VALUE
gtk_rc_m_parse(self, rc)
    VALUE self, rc;
{
    gtk_rc_parse(STR2CSTR(rc));
    return Qnil;
}

static VALUE
gtk_rc_m_parse_string(self, rc)
    VALUE self, rc;
{
    gtk_rc_parse_string(STR2CSTR(rc));
    return Qnil;
}

static VALUE
gtk_rc_m_get_style(self, w)
    VALUE self, w;
{
    GtkStyle *s = gtk_rc_get_style(get_widget(w));
    return make_gstyle(s);
}

static VALUE
gtk_rc_m_add_widget_name_style(self, style, pat)
    VALUE self, style, pat;
{
    gtk_rc_add_widget_name_style(get_grcstyle(style), STR2CSTR(pat));
    return Qnil;
}

static VALUE
gtk_rc_m_add_widget_class_style(self, style, pat)
    VALUE self, style, pat;
{
    gtk_rc_add_widget_class_style(get_grcstyle(style), STR2CSTR(pat));
    return Qnil;
}

void Init_gtk_rc()
{
    mRC = rb_define_module_under(mGtk, "RC");

    rb_define_module_function(mRC, "parse", gtk_rc_m_parse, 1);
    rb_define_module_function(mRC, "parse_string", gtk_rc_m_parse_string, 1);
    rb_define_module_function(mRC, "get_style", gtk_rc_m_get_style, 1);
    rb_define_module_function(mRC, "add_widget_name_style",
			      gtk_rc_m_add_widget_name_style, 2);
    rb_define_module_function(mRC, "add_widget_class_style",
			      gtk_rc_m_add_widget_class_style, 2);
}

/*
 * AccelGroup
 */

static VALUE
gaccelgrp_s_new(self)
    VALUE self;
{
    return make_gtkaccelgrp(gtk_accel_group_new());
}

static VALUE
gaccelgrp_s_get_default(self)
    VALUE self;
{
    return make_gtkaccelgrp(gtk_accel_group_get_default());
}

static VALUE
gaccelgrp_activate(self, key, modtype)
    VALUE self, key, modtype;
{
    gtk_accel_group_activate(get_gtkaccelgrp(self),
                             NUM2INT(key),
                             NUM2INT(modtype));
    return self;
}

static VALUE
gaccelgrp_s_activate(self, obj, key, modtype)
    VALUE self, obj, key, modtype;
{
    gtk_accel_groups_activate(get_gobject(obj),
                              NUM2INT(key),
                              NUM2INT(modtype));
    return self;
}

static VALUE
gaccelgrp_attach(self, obj)
    VALUE self, obj;
{
    gtk_accel_group_attach(get_gtkaccelgrp(self),
                           GTK_OBJECT(get_gobject(obj)));
    return Qnil;
}

static VALUE
gaccelgrp_detach(self, obj)
    VALUE self, obj;
{
    gtk_accel_group_detach(get_gtkaccelgrp(self),
                           GTK_OBJECT(get_gobject(obj)));
    return Qnil;
}

static VALUE
gaccelgrp_lock(self)
    VALUE self;
{
    gtk_accel_group_lock(get_gtkaccelgrp(self));
    return Qnil;
}

static VALUE
gaccelgrp_unlock(self)
    VALUE self;
{
    gtk_accel_group_unlock(get_gtkaccelgrp(self));
    return Qnil;
}

static VALUE
gaccelgrp_add(self, key, modtype, flag, obj, strsig)
    VALUE self, key, modtype, flag, obj, strsig;
{
    gtk_accel_group_add(get_gtkaccelgrp(self),
                        NUM2INT(key),
			NUM2INT(modtype),
			NUM2INT(flag),
			GTK_OBJECT(get_gobject(obj)),
			STR2CSTR(strsig));
    return Qnil;
}

static VALUE
gaccelgrp_remove(self, key, modtype, obj)
    VALUE self, key, modtype, obj;
{
    gtk_accel_group_remove(get_gtkaccelgrp(self),
                           NUM2INT(key),
			   NUM2INT(modtype),
			   GTK_OBJECT(get_gobject(obj)));
    return Qnil;
}

void Init_gtk_accel_group()
{
    gAccelGroup = rb_define_class_under(mGtk, "AccelGroup", rb_cData);
    rb_define_singleton_method(gAccelGroup, "new", gaccelgrp_s_new, 0);
    rb_define_singleton_method(gAccelGroup, "get_default", gaccelgrp_s_get_default, 0);
    rb_define_singleton_method(gAccelGroup, "activate", gaccelgrp_s_activate, 3);
    rb_define_method(gAccelGroup, "attach", gaccelgrp_attach, 1);
    rb_define_method(gAccelGroup, "detach", gaccelgrp_detach, 1);
    rb_define_method(gAccelGroup, "lock", gaccelgrp_lock, 0);
    rb_define_method(gAccelGroup, "unlock", gaccelgrp_unlock, 0);
    rb_define_method(gAccelGroup, "add", gaccelgrp_add, 5);
    rb_define_method(gAccelGroup, "remove", gaccelgrp_remove, 3);
    rb_define_method(gAccelGroup, "activate", gaccelgrp_activate, 2);
    rb_define_method(gAccelGroup, "activate", gaccelgrp_activate, 2);
    rb_define_const(gAccelGroup, "ACCEL_VISIBLE", INT2NUM(GTK_ACCEL_VISIBLE));
    rb_define_const(gAccelGroup, "ACCEL_SIGNAL_VISIBLE", INT2NUM(GTK_ACCEL_SIGNAL_VISIBLE));
    rb_define_const(gAccelGroup, "ACCEL_LOCKED", INT2NUM(GTK_ACCEL_LOCKED));
    rb_define_const(gAccelGroup, "ACCEL_MASK", INT2NUM(GTK_ACCEL_MASK));
}

/*
 * Requisition
 */
static VALUE grequisition_new(self, w, h)
    VALUE self, w, h;
{
    GtkRequisition r;

    r.width = NUM2INT(w);
    r.height = NUM2INT(h);
    return make_grequisition(&r);
}

static VALUE
grequisition_w(self)
    VALUE self;
{
    return INT2NUM(get_grequisition(self)->width);
}

static VALUE
grequisition_h(self)
    VALUE self;
{
    return INT2NUM(get_grequisition(self)->height);
}

static VALUE
grequisition_set_w(self, w)
    VALUE self, w;
{
    get_grequisition(self)->width = NUM2INT(w);
    return self;
}

static VALUE
grequisition_set_h(self, h)
    VALUE self, h;
{
    get_grequisition(self)->height = NUM2INT(h);
    return self;
}

static VALUE
grequisition_to_a(self)
    VALUE self;
{
    GtkRequisition *r;

    r = get_grequisition(self);
    return rb_ary_new3(2, r->width, r->height);
}

static VALUE
grequisition_to_s(self)
    VALUE self;
{
    char str[2 +2*1 +5*2  +1]; /* member is guint16. max string size is 5 */
    GtkRequisition *r;

    r = get_grequisition(self);
    sprintf(str, "(%5d, %5d)", r->width, r->height);
    return rb_str_new2(str);
}

void Init_gtk_requisiton()
{
    gRequisition = rb_define_class_under(mGtk, "Requisition", rb_cData);

    rb_define_singleton_method(gRequisition, "new", grequisition_new, 2);
    rb_define_method(gRequisition, "width", grequisition_w, 0);
    rb_define_method(gRequisition, "height", grequisition_h, 0);
    rb_define_method(gRequisition, "width=", grequisition_set_w, 1);
    rb_define_method(gRequisition, "height=", grequisition_set_h, 1);
    rb_define_method(gRequisition, "to_a", grequisition_to_a, 0);
    rb_define_method(gRequisition, "to_s", grequisition_to_s, 0);
}


/*
 * Gtk module
 */
static gint
idle()
{
    struct timeval wait;

    wait.tv_sec  = 0;
    wait.tv_usec = 100000; /* 100ms */

    CHECK_INTS;
    if (!rb_thread_critical) rb_thread_wait_for(wait);

    return Qtrue;
}

/*
 * Init
 */
extern void Init_gtk_adjustment();
extern void Init_gtk_alignment();
extern void Init_gtk_arrow();
extern void Init_gtk_aspect_frame();
extern void Init_gtk_bin();
extern void Init_gtk_box();
extern void Init_gtk_button();
extern void Init_gtk_button_box();
extern void Init_gtk_check_button();
extern void Init_gtk_check_menu_item();
extern void Init_gtk_clist();
extern void Init_gtk_color_selection();
extern void Init_gtk_color_selection_dialog();
extern void Init_gtk_combo();
extern void Init_gtk_const();
extern void Init_gtk_container();
extern void Init_gtk_ctree();
extern void Init_gtk_data();
extern void Init_gtk_dialog();
extern void Init_gtk_editable();
extern void Init_gtk_entry();
extern void Init_gtk_eventbox();
extern void Init_gtk_fileselection();
extern void Init_gtk_fixed();
extern void Init_gtk_frame();
extern void Init_gtk_gamma_curve();
extern void Init_gtk_hbox();
extern void Init_gtk_hbutton_box();
extern void Init_gtk_hpaned();
extern void Init_gtk_hscale();
extern void Init_gtk_hscrollbar();
extern void Init_gtk_image();
extern void Init_gtk_input_dialog();
extern void Init_gtk_item();
extern void Init_gtk_label();
extern void Init_gtk_layout();
extern void Init_gtk_list();
extern void Init_gtk_list_item();
extern void Init_gtk_menu();
extern void Init_gtk_menu_bar();
extern void Init_gtk_menu_item();
extern void Init_gtk_menu_shell();
extern void Init_gtk_misc();
extern void Init_gtk_notebook();
extern void Init_gtk_paned();
extern void Init_gtk_pixmap();
extern void Init_gtk_radio_button();
extern void Init_gtk_radio_menu_item();
extern void Init_gtk_range();
extern void Init_gtk_scale();
extern void Init_gtk_scrollbar();
extern void Init_gtk_scrolled_window();
extern void Init_gtk_spin_button();
extern void Init_gtk_statusbar();
extern void Init_gtk_style();
extern void Init_gtk_table();
extern void Init_gtk_tearoff_menu_item();
extern void Init_gtk_text();
extern void Init_gtk_tips_query();
extern void Init_gtk_toggle_button();
extern void Init_gtk_toolbar();
extern void Init_gtk_tooltips();
extern void Init_gtk_tree();
extern void Init_gtk_tree_item();
extern void Init_gtk_vbox();
extern void Init_gtk_vbutton_box();
extern void Init_gtk_viewport();
extern void Init_gtk_vpaned();
extern void Init_gtk_vscale();
extern void Init_gtk_vscrollbar();
extern void Init_gtk_widget();
extern void Init_gtk_window();

void Init_gtk_gtk()
{
    gtk_object_list = rb_hash_new();
    rb_global_variable(&gtk_object_list);

    /* IDs */
    id_gtkdata = rb_intern("gtkdata");
    id_relatives = rb_intern("relatives");
    id_call = rb_intern("call");

    mGtk = rb_define_module("Gtk");
    rb_ivar_set(mGtk, id_relatives, Qnil);
    Init_gtk_const();
    Init_gtk_main();
    Init_gtk_rc();

    Init_gtk_object();
    Init_gtk_widget();
    Init_gtk_container();
    Init_gtk_bin();
    Init_gtk_alignment();
    Init_gtk_misc();
    Init_gtk_arrow();
    Init_gtk_frame();
    Init_gtk_aspect_frame();
    Init_gtk_data();
    Init_gtk_adjustment();
    Init_gtk_box();
    Init_gtk_button();
    Init_gtk_toggle_button();
    Init_gtk_check_button();
    Init_gtk_radio_button();
    Init_gtk_button_box();
    Init_gtk_clist();
    Init_gtk_ctree();
    Init_gtk_window();
    Init_gtk_dialog();
    Init_gtk_vbox();
    Init_gtk_color_selection();
    Init_gtk_color_selection_dialog();
    Init_gtk_image();
    Init_gtk_drawing_area();
    Init_gtk_curve();
    Init_gtk_editable();
    Init_gtk_entry();
    Init_gtk_spin_button();
    Init_gtk_eventbox();
    Init_gtk_fixed();
    Init_gtk_gamma_curve();
    Init_gtk_hbutton_box();
    Init_gtk_vbutton_box();
    Init_gtk_hbox();
    Init_gtk_statusbar();
    Init_gtk_combo();
    Init_gtk_paned();
    Init_gtk_hpaned();
    Init_gtk_vpaned();
    Init_gtk_ruler();
    Init_gtk_hruler();
    Init_gtk_vruler();
    Init_gtk_range();
    Init_gtk_scale();
    Init_gtk_hscale();
    Init_gtk_vscale();
    Init_gtk_scrollbar();
    Init_gtk_hscrollbar();
    Init_gtk_vscrollbar();
    Init_gtk_separator();
    Init_gtk_hseparator();
    Init_gtk_vseparator();
    Init_gtk_fileselection();
    Init_gtk_input_dialog();
    Init_gtk_label();
    Init_gtk_layout();
    Init_gtk_list();
    Init_gtk_item();
    Init_gtk_list_item();
    Init_gtk_menu_shell();
    Init_gtk_menu();
    Init_gtk_menu_bar();
    Init_gtk_menu_item();
    Init_gtk_check_menu_item();
    Init_gtk_radio_menu_item();
    Init_gtk_tearoff_menu_item();
    Init_gtk_notebook();
    Init_gtk_option_menu();
    Init_gtk_pixmap();
    Init_gtk_preview();
    Init_gtk_progress();
    Init_gtk_progress_bar();
    Init_gtk_scrolled_window();
    Init_gtk_table();
    Init_gtk_text();
    Init_gtk_toolbar();
    Init_gtk_tooltips();
    Init_gtk_tips_query();
    Init_gtk_tree();
    Init_gtk_tree_item();
    Init_gtk_viewport();
    Init_gtk_accel_group();
    gAcceleratorTable = rb_define_class_under(mGtk, "AcceleratorTable", rb_cData);
    Init_gtk_style();
    gRcStyle = rb_define_class_under(mGtk, "RcStyle", rb_cData);
    gPreviewInfo = rb_define_class_under(mGtk, "PreviewInfo", rb_cData);
    Init_gtk_requisiton();
    Init_gtk_allocation();
    gItemFactory = rb_define_class_under(mGtk, "ItemFactory", rb_cData);

#if 1
    gtk_idle_add((GtkFunction)idle, 0);
#else
    /* use timeout to avoid busy wait */
    gtk_timeout_add(100, (GtkFunction)idle, 0);
#endif

    rb_global_variable(&warn_handler);
    rb_global_variable(&mesg_handler);
    rb_global_variable(&print_handler);
}
