#ifndef VECTORBASE_HH
#define VECTORBASE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: VectorBase.hh,v 1.45 1999/03/09 22:52:25 dmartin Exp $
//---------------------------------------------------------------------------
#include <iostream.h>
#include "ObjectBase.hh"
#include "VHDLData.hh"
#include "TypeInfo.hh"
#include "VHDLType.hh"
#include "TypeKind.hh"

class enumInfo;
extern const enumInfo NULL_ENUM_INFO;

extern "C" int abs(int);
class VHDLKernelBase;
class SignalBase;

//class so that all BitVectors can be passed around the same way
class VectorBase : public VHDLType {
public:
  int numElems;
  ArrayInfo bounds;

  VectorBase(void);
  VectorBase(int lBound, ArrayDirn_t dirn, int rBound);
  VectorBase(VectorBase& b);
  virtual ~VectorBase();

  virtual VHDLType& operator=(const VHDLType&);
  virtual VectorBase& operator = (const VectorBase& vb);
  VHDLType& assignVal(const VHDLType&);

  virtual VHDLType& operator[](const int) const = 0;

  int left() const;
  int right() const;
  ArrayDirn_t dirn() const;
  int length() const;

// Note: The method "get_kind()" MUST NOT be overloaded by a derived type.
// This is to ensure that the type is recognized correctly.
  Type get_kind() const;

  virtual void print(ostream& os) const;

  int get_number_of_elements() const;
  virtual VHDLType& get_element(const int) const;
  ArrayInfo* get_bounds() const;

  virtual void setRange(ObjectBase::ObjectType, ArrayInfo*, int = 1, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  virtual void setRange(ObjectBase::ObjectType, VectorBase*);

  virtual ObjectBase* getObject() const;
  virtual ObjectBase::ObjectType getKind() const;

  virtual VectorBase* getNewArray(const ArrayInfo& newBounds,
				  const ArrayInfo& actualBounds) const;

  virtual int savantwrite(SavantlineType &) const;
  virtual int savantread(SavantlineType &);

  //The TYPE's resolve is called only for composite resolved signals
  //This resolve goes down to first sub-element of the VHDLType and
  //calls the sub-elements resolve, but which actually does the resolution
  //for the whole composite type
  virtual VHDLType* resolve(VHDLKernelBase*);
  virtual void updateEffVal(const VHDLType*);
  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);

  virtual void setParentCompositeType(VHDLType*);
  virtual void setCompositeResolvedSignal(bool);
  virtual bool _is_signal() const { return get_element(0)._is_signal(); }
  virtual SignalBase* locateSig(int);
  virtual SignalBase* findSigInBlock(int, int);
};

EnumerationType savantEqual(const VectorBase &, const VectorBase &);
EnumerationType savantNotEqual(const VectorBase &, const VectorBase &);
#endif



