
//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef INTEGERTYPE_HH
#define INTEGERTYPE_HH

#include "ScalarType.hh"
#include "TypeInfo.hh"
extern rangeInfo SavantintegerType_info;
class SavantstringType;

//This class has been to added to hold the attributes of IntegerTypes
class IntegerType;

class IntegerType: public ScalarType {
public:
  IntegerType() : ScalarType() {}
  IntegerType(ObjectBase::ObjectType);
  IntegerType(ObjectBase::ObjectType, const UniversalInteger&);
  IntegerType(ObjectBase::ObjectType, const IntegerType&);
  IntegerType(bool, const IntegerType&); //must copy range info ptr swami
  IntegerType(const IntegerType&);
  IntegerType(ObjectBase::ObjectType, int);
  
  //The new constructors to hold the attribute information also
  IntegerType(ObjectBase::ObjectType, const rangeInfo&);
  IntegerType(ObjectBase::ObjectType, const TypeInfo&);
  IntegerType(ObjectBase::ObjectType, const UniversalInteger&, 
	      const rangeInfo&);
  IntegerType(ObjectBase::ObjectType, const UniversalInteger&,
	      const enumInfo&);
  IntegerType(ObjectBase::ObjectType, const IntegerType&, 
	      const rangeInfo&);
  IntegerType(bool, const IntegerType&, const rangeInfo&);
  IntegerType(const IntegerType&, const rangeInfo&);

  virtual ~IntegerType() {}

  IntegerType& operator = (const IntegerType&);

  Type get_kind() const;
  virtual const VHDLData& leftValue();

  //Code added for folding
  //All the attributes of IntegerTypeRange
  static IntegerType LEFT (const rangeInfo &);
  static IntegerType RIGHT(const rangeInfo &);
  static IntegerType HIGH (const rangeInfo &);
  static IntegerType LOW  (const rangeInfo &);

  static EnumerationType   ASCENDING (const rangeInfo &);
  static IntegerType       SUCC      (const IntegerType&);
  static IntegerType       PRED      (const IntegerType&);
  static IntegerType       LEFTOF    (const IntegerType&);
  static IntegerType       RIGHTOF   (const IntegerType&);
  static SavantstringType  IMAGE     (const IntegerType&);
  static IntegerType       VALUE     (const SavantstringType&, 
				      const rangeInfo & = SavantintegerType_info);
  static IntegerType       POS       (const IntegerType&, 
				      const rangeInfo & = SavantintegerType_info);
  static IntegerType       VAL       (const IntegerType&, 
				      const rangeInfo & = SavantintegerType_info);

  TypeInfo& getTypeInfo() const;
  
public:
  rangeInfo range;
};

IntegerType savantPlus(const IntegerType&, const IntegerType&);
IntegerType savantMinus(const IntegerType&, const IntegerType&);
IntegerType savantUnaryPlus(const IntegerType&);
IntegerType savantUnaryMinus(const IntegerType&);
IntegerType savantMultiply(const IntegerType&, const IntegerType&);
IntegerType savantDivide(const IntegerType&, const IntegerType&);
IntegerType savantMod(const IntegerType&, const IntegerType&);
IntegerType savantRem(const IntegerType&, const IntegerType&);
IntegerType savantPow(const IntegerType&, const IntegerType&);
IntegerType savantAbs(const IntegerType&);

#endif

