#ifndef IMPSIGNAL_HH
#define IMPSIGNAL_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: ImplicitSignal.hh,v 1.17 1999/03/09 22:52:04 dmartin Exp $
//
//---------------------------------------------------------------------------
#include "SignalBase.hh"

class SourceBase;

template <class Type> 
class ImplicitSignal : public SignalBase {
public:
  ImplicitSignal(void);
  ImplicitSignal(const VHDLData&);
  ImplicitSignal(const char*);
  ImplicitSignal(const int);
//   ImplicitSignal(const char);
//   ImplicitSignal(const double);
//   ImplicitSignal(const bool);
  void print(ostream&) const;
  virtual ObjectType getKind() const {return IMPLICIT_SIGNAL;};
  void updateDriver(const int, const int, VHDLData*, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  VHDLType* readDriver(int);
  void updateDrvVal(const VHDLData*, const ArrayInfo* = NULL, 
		    const ArrayInfo* = NULL);
  VHDLData* readDrvVal();
  void updateEffVal(const VHDLData*, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  void updateEffVal(const VHDLData&, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  VHDLData* readEffVal();
  VTime& readTimeVal();
  VTime& updateTimeVal(const VTime& v = ZERO);

  ObjectBase& operator=(const ObjectBase&);
  ObjectBase& operator=(const VHDLData&);
  const VHDLData& readVal() const {
    return effVal;
  }
  void updateVal(const VHDLData& val) {
    updateEffVal((const VHDLData *) &val);
  }

  VTime timeval;        // time value for Stable, Quiet, Delayed

  SourceBase *source;	// source for this signal
  Type drvVal;          // driving value of the signal
  Type effVal;          // effective value of the signal

  UniversalBoolean (*guardExpr)(void);

  ObjectBase* clone() const {
    ImplicitSignal<Type> *retval = new ImplicitSignal<Type>;
    *retval = *this;
    return retval;
  }

  void setSource(SourceBase *src) {
    source = src;
  }
};

#include "ImplicitSignal.cc"
#endif





