#include "FileType.hh"
#include "AccessVariable.hh"
#include "SavantlineType.hh"
#include "VHDLKernel.hh"
#include "SavantstringType.hh"

const int maxExtraInFilesInProcedure = 5;
const int maxExtraOutFilesInProcedure = 5;

FileType::FileType(bool alias ) : VHDLType(alias) {
  //  object = NULL;
}

FileType::FileType(const FileType &ft) {
  fileHandle = ft.fileHandle;
  (_savant_file_open_kind &) openKind   = ft.openKind;
}

FileType::FileType(VHDLKernelBase* proc, const char* fileName, const _savant_file_open_kind mode) {
  set_fileHandle(proc->openFile(fileName, mode));
  set_fileOpenKind(mode);
}

FileType::FileType(VHDLKernelBase* proc, const ArrayType& fileName, const _savant_file_open_kind mode) {
  char *file_name_string = fileName.getString();
  set_fileHandle(proc->openFile(file_name_string, mode));
  set_fileOpenKind(mode);

  delete [] file_name_string;
}

FileType::~FileType() { }

Type
FileType::get_kind() const {
  return FILE_TYPE;
}


ObjectBase::ObjectType
FileType::getKind() const {
  return ObjectBase::VARIABLE;
}

void
FileType::print(ostream& ) const {
}

void
FileType::openFile(VHDLKernelBase *proc, const char *fileName, const _savant_file_open_kind &mode, ios::open_mode opening_mode) {
  set_fileHandle(proc->openFile(fileName, mode, opening_mode));
  set_fileOpenKind(mode);
}

void
FileType::openFile(VHDLKernelBase *proc, const ArrayType& fileName, const _savant_file_open_kind &mode, ios::open_mode opening_mode) {
  char* ptr = fileName.getString();
  set_fileHandle(proc->openFile(ptr, mode, opening_mode));
  set_fileOpenKind(mode);

  delete [] ptr;
}

void
FileType::closeFile(VHDLKernelBase *proc)
{
  proc->closeFile(get_fileOpenKind(), get_fileHandle());
}

void
FileType::reset(const char *fileName) {
  // Reset a shared file.
  fstream tempFile;

  tempFile.open(fileName, ios::out);
  tempFile.close();
}

void
FileType::reset(const ArrayType &fileName) {
  char *file_name_string = fileName.getString();
  reset(file_name_string);

  delete [] file_name_string;
}

VHDLType *
FileType::clone() const{
  VHDLType *retval = new FileType(is_alias);

  return retval;
}

int
FileType::savantwriteline(VHDLKernelBase *base, AccessVariable <char*> &line) {
  base->savantwriteline(base, get_fileHandle(), line);

  return NORMAL_RETURN;
}

int
FileType::savantwriteline(VHDLKernelBase *base, SavantlineType &line) 
{
  base->savantwriteline(base, get_fileHandle(), line);

  return NORMAL_RETURN;
}

int
FileType::savantreadline(VHDLKernelBase *base, SavantlineType &line)
{
  base->savantreadline(base, get_fileHandle(), line);

  return NORMAL_RETURN;
}

int
FileType::savantreadline(VHDLKernelBase *base, AccessVariable <char*> &line)
{
  base->savantreadline(base, get_fileHandle(), line);

  return NORMAL_RETURN;
}

int
FileType::get_fileHandle() const {
  return fileHandle;
}

_savant_file_open_kind&
FileType::get_fileOpenKind() {
  return openKind;
}

void
FileType::set_fileHandle(const int handle) {
  fileHandle = handle;
}

void
FileType::set_fileOpenKind(const _savant_file_open_kind& kind)
{
  (_savant_file_open_kind&) openKind = kind;
}

FileType &
FileType::operator =(const FileType &val) {
  (_savant_file_open_kind&) openKind = val.openKind;
  fileHandle = val.fileHandle;

  return *this;
}

bool
FileType::operator==(const VHDLType& val) const {
  ASSERT(val.get_kind() == FILE_TYPE);
  return INT_TO_BOOL((fileHandle == ((FileType&) val).fileHandle));
}


EnumerationType
FileType::savantendfile_boolean(VHDLKernelBase *base, int fileHandle)
{
  return base->savantendfile_boolean(base, fileHandle);
}

int
FileType::savantreadline(VHDLKernelBase *base, SavantlineType& line, IntegerType &count)
{
  base->savantreadline(base, get_fileHandle(), line, count);

  return NORMAL_RETURN;
}


