/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */


#include <stdio.h>
#include "x10.h"

extern char hc2char();
extern unsigned int x2unitmap();

extern int Irev, Idays, Ihours, Iminutes, Ijday, Iseconds;
extern int Istatdim, Istatmon, Iaddmon;


extern unsigned char Ihcode;
extern void error();

extern char *wdays[];

/* ARGSUSED */

int c_info(argc, argv)
char *argv[];
{
    char RCSID[]= "@(#) $Id: info.c,v 1.10 1999/12/13 21:04:14 dbs Exp $\n";
    extern int usage(), get_status();
    extern char *bits2day(), *b2s();

    display(RCSID);

    if (argc != 2)
	usage(E_2MANY);
    if ( get_status() < 0 )
         error("No repsonse from the CM11A.  Program exiting.");
    printf("Firmware revision Level = %d\n", Irev );
    if ((Ihours + Iminutes + Idays + Ijday) != 0 )
	(void) printf("Interface clock: %s, %2d:%02d:%02d, Julian %d\n",
		      bits2day(Idays), Ihours, Iminutes, Iseconds, Ijday);
    else
	(void) printf("Interface clock not yet set\n");
    (void) printf("Housecode = %c\n", hc2char(Ihcode));
    
    (void) printf("0 = off, 1 = on,               unit  16.......8...4..1\n");

    (void) printf("Last addressed device =       0x%04x (%s)\n", Iaddmon,
            b2s(x2unitmap(Iaddmon)) );
    (void) printf("Status of monitored devices = 0x%04x (%s)\n", Istatmon,
            b2s(x2unitmap(Istatmon)) );
    (void) printf("Status of dimmed devices =    0x%04x (%s)\n", Istatdim,
            b2s(x2unitmap(Istatdim)) );
    return(0);
}
