/*$Id: e_vcsrc.h,v 15.6 1999/09/20 06:10:44 al Exp $ -*- C++ -*-
 $ voltage controlled source base
 */
#ifndef E_VCSRC_H
#define E_VCSRC_H
#include "l_denoise.h"
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
class VCSRC_BASE : public ELEMENT {
protected:
  explicit VCSRC_BASE()			   :ELEMENT()  {}
  explicit VCSRC_BASE(const VCSRC_BASE& p) :ELEMENT(p) {}
private: // override virtual
  void	   tr_unload()		{tr_unload_active();}
  double   tr_involts()const	{return dn_diff(n[IN1].v0(), n[IN2].v0());}
  COMPLEX  ac_involts()const	{return n[IN1].vac() - n[IN2].vac();}
  int	   numnodes()const	{return 4;}
  bool	   is_2port()const	{return true;}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
