/*$Id: d_diode.h,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * data structures and defaults for diode model.
 */
#ifndef D_DIODE_H
#define D_DIODE_H
#include "e_subckt.h"
#include "e_model.h"
/*--------------------------------------------------------------------------*/
class DEV_DIODE;		/* this file */
class DIODE_COMMON;
class MODEL_DIODE;
class EVAL_DIODE_Yj;
class EVAL_DIODE_Cj;
/*--------------------------------------------------------------------------*/
class DEV_ADMITTANCE;		/* external */
class DEV_CAPACITANCE;
/*--------------------------------------------------------------------------*/
enum region_t {INITOFF=-2, REVERSE=-1, UNKNOWN=0, FORWARD=1};
/*--------------------------------------------------------------------------*/
class DEV_DIODE : public BASE_SUBCKT {
  friend class DEV_MOS;
  friend class EVAL_DIODE_Yj;
  friend class EVAL_DIODE_Cj;
private:
  explicit DEV_DIODE(const DEV_DIODE& p);
public:
  explicit DEV_DIODE();
           ~DEV_DIODE()		{--Count;}
private: // override virtual
  CARD*	   clone()const		{untested(); return new DEV_DIODE(*this);}
  void	   parse(CS&);
  void	   print(OMSTREAM,int)const;
  double   probe_tr_num(const std::string&)const;
  void	   expand();
  int	   numnodes()const	{return 2;}
public:
  static int count()		{return Count;}
private:
  region_t region;	/* fwd, reverse, unknown */
  double   isat;	/* is adjusted for temp, etc. */
  double   gd;		/* conductance to pass to capacitor */
  DEV_ADMITTANCE*  Yj;	/* subckt elements, for probe */
  DEV_CAPACITANCE* Cj;
  static int Count;
};
/*--------------------------------------------------------------------------*/
class DIODE_COMMON : public COMPONENT_COMMON {
public:
  explicit DIODE_COMMON(int c=0);
  explicit DIODE_COMMON(const DIODE_COMMON& p, int c=0);
	   ~DIODE_COMMON()	{--Count;}
  void	   parse(CS&);
  void	   print(OMSTREAM)const;
  void	   expand();
  const char* name()const	{untested(); return "diode";}

  double   is;		/* saturation current */
  double   rs;		/* series resistance */
  double   cj;		/* zero bias jct capacitance */
  double   cjsw;	/* zero bias sidewall capacitance */
  double   area;	/* area factor */
  double   perim;	/* perimeter factor */
  double   gparallel;	/* parallel conductance */
  double   ic;		/* initial voltage */
  bool	   off;		/* flag: assume reverse biased */
  struct {
    unsigned is:1,
	     rs:1,
	     cj:1,
	     cjsw:1,
	     gparallel:1;
  } calc;
  static int count()		{return Count;}
private:
  static int Count;
};
/*--------------------------------------------------------------------------*/
class MODEL_DIODE : public MODEL_CARD {
friend class DEV_DIODE;
friend class DIODE_COMMON;
friend class EVAL_DIODE_Yj;
friend class EVAL_DIODE_Cj;
protected:
  explicit MODEL_DIODE(const MODEL_DIODE& p) :MODEL_CARD(p) {unreachable();}
public:
  explicit	MODEL_DIODE();
		~MODEL_DIODE()	{--Count;}
private: // override virtual
  void		parse(CS&);
  void		print(OMSTREAM,int)const;
public:
  static int	count()		{return Count;}
protected:
  double   js;	/* is  *//* saturation current (per area) */
  double   rs;		 /* ohmic resistance (per area) */
  double   n;		 /* emission coefficient */
  double   tt;		 /* transit time */
  double   cjo;	/* cj  *//* zero-bias jct capacitance (per area) */
  double   pb;	/* vj  *//* junction potential */
  double   mj;	/* m   *//* grading coefficient */
  double   eg;		 /* activation energy */
  double   xti;		 /* saturation-current temp. exp. */
  double   kf;		 /* flicker noise coefficient */
  double   af;		 /* flicker noise exponent */
  double   fc;		 /* coef for fwd bis depl cap formula */
  double   bv;		 /* reverse breakdown voltage */
  double   ibv;		 /* current at reverse breakdown */
   			 /* non-spice extensions */
  double   cjsw;	 /* zero bias sidewall cap (per perim.) */
  double   mjsw;	 /* sidewall grading coefficient */
  double   gparallel;	 /* parallel conductance */
  int	   flags;
  double   fcpb;	 /* fc * pb */
private:
  static int Count;
  enum {USE_OPT = 0x8000};
};
/*--------------------------------------------------------------------------*/
class EVAL_DIODE_Yj : public COMPONENT_COMMON {
private:
  explicit EVAL_DIODE_Yj(const EVAL_DIODE_Yj& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_DIODE_Yj(int c=0)	:COMPONENT_COMMON(c) {}
  const char* name()const		{untested(); return "EVAL_DIODE_Yj";}
  void	   tr_eval(COMPONENT*d)const;
  bool	   has_tr_eval()const		{return true;}
  bool	   has_ac_eval()const		{return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_DIODE_Cj : public COMPONENT_COMMON {
private:
  explicit EVAL_DIODE_Cj(const EVAL_DIODE_Cj& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_DIODE_Cj(int c=0)	:COMPONENT_COMMON(c) {}
  const char* name()const		{untested(); return "EVAL_DIODE_Cj";}
  void	   tr_eval(COMPONENT*d)const;
  bool	   has_tr_eval()const		{return true;}
  bool	   has_ac_eval()const		{return false;}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
