/*$Id: c_delete.cc,v 15.14 1999/10/20 08:53:59 al Exp $ -*- C++ -*-
 * delete and clear commands
 */
#include "e_card.h"
#include "s__.h"
#include "ap.h"
#include "c_comand.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::clear(CS&);
//	void	CMD::del(CS&);
static	void	bylabel(CS&);
/*--------------------------------------------------------------------------*/
/* cmd_clear: clear the whole circuit, including faults, etc
 *   equivalent to unfault; unkeep; delete all; title = (blank)
 */
void CMD::clear(CS&)
{
  {CS nil("");      unfault(nil);}
  {CS nil("");      unmark(nil);}
  {CS clr("clear"); ic(clr);}
  {CS clr("clear"); nodeset(clr);}
  {CS clr("clear"); alarm(clr);}
  {CS clr("clear"); plot(clr);}
  {CS clr("clear"); print(clr);}
  {CS All("all");   del(All);}
  {CS q("'");       title(q);}
}
/*--------------------------------------------------------------------------*/
/* cmd_delete:  delete command
 */
void CMD::del(CS& cmd)
{
  SIM::uninit();
  {if (cmd.pmatch("ALL")){
    CARD_LIST::card_list.destroy();
  }else{
    while (cmd.more()){
      bylabel(cmd);
    }
  }}
}
/*--------------------------------------------------------------------------*/
/* bylabel: delete circuit element by label
 * 	all lines with matching label (with wild cards * and ?) deleted.
 *	although it looks like a loop, it matches one label
 *	syntax warning if no match
 */
static void bylabel(CS& cmd)
{
  int mark = cmd.cursor(); // where we started parsing
  int cmax = cmd.cursor(); // where we got after being successful
  
  CARD_LIST::fat_iterator ci(&(CARD_LIST::card_list));
  for (;;){
    cmd.reset(mark);
    ci = findbranch(cmd, ci);
    cmax = std::max(cmax, cmd.cursor());
    {if (!ci.isend()){ // found something
      CARD_LIST::iterator here(ci.iter());
      ++ci;
      ci.list()->erase(here);
    }else{ // no more matches
      break;
    }}
  }
  cmd.reset(cmax);
  if (mark == cmax){ // didn't do anything
    cmd.check(bWARNING, "no match");
    cmd.skiparg();
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
