/* Load trimmed message catalogs. 
   Copyright (C) Enrique Zanardi <ezanard@debian.org>, 1999
   gettext.h code fragment is:
   Copyright (C) 1995, 1997 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <stdlib.h>

#include <unistd.h>
#include <sys/mman.h>

/* The following is copied from gettext.h */

/* BEGIN gettext */
/* Use the C preprocessor to determine an unsigned integral type that is
 * 32 bits wide. */

#if __STDC__
# define UINT_MAX_32_BITS 4294967295U
#else
# define UINT_MAX_32_BITS 0xFFFFFFFF
#endif

/* If UINT_MAX isn't defined, assume it's a 32-bit type. */

#ifndef UINT_MAX
# define UINT_MAX UINT_MAX_32_BITS
#endif

#if UINT_MAX == UINT_MAX_32_BITS
typedef unsigned nls_uint32;
#else
# if USHRT_MAX == UINT_MAX_32_BITS
typedef unsigned short nls_uint32;
# else
#  if ULONG_MAX == UINT_MAX_32_BITS
typedef unsigned long nls_uint32;
#  else
  /* The following line is intended to throw an error.  Using #error is
     not portable enough.  */
  "Cannot determine unsigned 32-bit data type."
#  endif
# endif
#endif
/* END gettext */

/* Load the message catalogs specified by FILENAME.  On error return 0,
 * on success return the nuber of strings read. */
int load_trmfile (char *file, char **messages_table, int tstrings) {
  int fd, cnt;
  size_t size;
  struct stat st;
  nls_uint32 nstrings,*data,*ptr;

  /* Try to open the addressed file.  */
  fd = open (file, O_RDONLY);
  if (fd == -1)
    return 0;

  /* We must know about the size of the file.  */
  if (fstat (fd, &st) != 0
      || (size = (size_t) st.st_size) != st.st_size) {
    /* Something went wrong.  */
    close (fd);
    return 0;
  }

  /* Load the file. */
  data = (nls_uint32 *) mmap (NULL, size, PROT_READ,
					 MAP_PRIVATE, fd, 0);

  if (data != (nls_uint32 *) -1) {
    /* mmap() call was successful.  */
    close (fd);
  } else {
    return 0;
  }

  nstrings = *data;
  if ((int)nstrings != tstrings) {
    /* The number of strings is wrong: not a valid message catalog file.  */
    munmap ((caddr_t) data, size);
    return 0;
  }

  for (cnt=0, ptr=data, ptr++; cnt<nstrings; cnt++, ptr++)
  	messages_table[cnt]=(char *)data+(*ptr);
  return cnt;
}
