// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: progress.cc,v 1.5 1998/09/18 02:42:42 jgg Exp $
/* ######################################################################

   Progress - % Based progress meter
   
   This displays a simple progress meter with a % figure in the middle
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/progress.h"
#endif  
#include <deity/progress.h>
#include <stdio.h>
									/*}}}*/

// Progress::Progress - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
Progress::Progress(Widget *Parent) : BasicWidget(Parent), iPercent(0)
{
   if (GraphicGC::GC != 0)
   {
      BFlag(EtchBorder);
      BorderWidth(2);
   }   
}
									/*}}}*/
// Progress::Render - Draw the progress bar									/*{{{*/
// ---------------------------------------------------------------------
/* */
void Progress::Render(CombinedGC &GC)
{
   BasicRender(GC,false);
   
   char S[30];
   sprintf(S,"%3.0f%%",iPercent);
   
   AbsRect Draw;
   Draw.x1 = BorderX;
   Draw.y1 = BorderY;
   Draw.x2 = BorderX + (long)((Pos.w - 2*BorderX)*iPercent/100.0);
   Draw.y2 = Pos.h - BorderY;
   unsigned long Center = Pos.w/2;
   
   GC->SetColor(iBackground);
   GC->Background(iColor);   
   GC->DrawString(Draw,Point(Center,(Draw.y2 - Draw.y1)/2),S,
		GenGC::XCenter | GenGC::YCenter);
		  
   Draw.x1 = Draw.x2;
   Draw.x2 = Pos.w - BorderX;
   GC->SetColor(iColor);
   GC->Background(iBackground);
   GC->DrawString(Draw,Point(Center - Draw.x1,(Pos.h - 2*BorderY)/2),S,
		  GenGC::XCenter | GenGC::YCenter);
}
									/*}}}*/
// Progress::IdealSize - Best size for the widget			/*{{{*/
// ---------------------------------------------------------------------
/* */
Point Progress::IdealSize()
{
   // Extent the text
   GenGC::GC->SetFont(iFont);
   Rect SSize = GenGC::GC->ExtentText("199%");
   return Point(SSize.w*10 + 2*BorderX,SSize.h*1.5 + 2*BorderY);
}
									/*}}}*/
