#include <string.h>
#include <stdlib.h>
#include <misc.h>
#include "daemoni.h"
#include <popen.h>
#include "netconf.h"
#include "internal.h"
#include "hostinfo.h"

/*
	Copy a string.
	Return != 0 if the source was different from the destination
*/
static int bootp_copy (SSTRING &dst, const char *src)
{
	int ret = 0;
	if (dst.cmp(src)!=0){
		ret = 1;
		dst.setfrom (src);
	}
	return ret;
}

/*
	Execute bootp and extract the config obtained
*/
int bootp_probe (INTER_INFO &itf)
{
	int ret = -1;
	const char *device = itf.device.get();
	IFCONFIG_INFO info;
	if (ifconfig_getinfo (device,info)==-1){
		ret = 0;
	}else{
		/* #Specification: bootp / principle
			Normally, bootp is executed only at boot time. Linuxconf
			execute it all the time and check if the IP configuration
			has to be changed. If not, nothing happen.
		*/
		if (strcmp(info.ip_addr,"0.0.0.0")==0){
			// We must minimally program the interface
			DAEMON_INTERNAL *dae = daemon_find ("ifconfig");
			char cmd[200];
			snprintf (cmd,sizeof(cmd)-1,"%s %s 0.0.0.0 netmask 0.0.0.0"
				,dae->getpath(),device);
			system (cmd);
			dae = daemon_find ("route");
			snprintf (cmd,sizeof(cmd)-1,"%s add -host 255.255.255.255 dev %s"
				,dae->getpath(),device);
			system (cmd);
		}
		char args[100];
		snprintf (args,sizeof(args)-1,"--dev %s --returniffail",device);
		POPEN pop ("bootpc",args);
		if (pop.isok()){
			int change = 0;
			SSTRING dnservers[3],domain,search;
			while (pop.wait(1)>=0){
				char line[500];
				while (pop.readout(line,sizeof(line)-1)==0){
					strip_end (line);
					char *pt = strchr(line,'=');
					if (pt != NULL){
						*pt++ = '\0';
						if (pt[0] == '\'') pt++;
						int last = strlen(pt)-1;
						if (last >= 0 && pt[last] == '\'') pt[last] = '\0';
						if (strcmp(line,"IPADDR")==0){
							change |= bootp_copy (itf.ipaddr,pt);
						}else if (strcmp(line,"NETWORK")==0){
							change |= bootp_copy (itf.network,pt);
						}else if (strcmp(line,"NETMASK")==0){
							change |= bootp_copy (itf.netmask,pt);
						}else if (strcmp(line,"BROADCAST")==0){
							change |= bootp_copy (itf.bcast,pt);
						}else if (strcmp(line,"GATEWAYS_1")==0){
							groutes_setgateway (pt,true);
						}else if (strcmp(line,"DNSSRVS_1")==0){
							dnservers[0].setfrom(pt);
						}else if (strcmp(line,"DNSSRVS_2")==0){
							dnservers[1].setfrom(pt);
						}else if (strcmp(line,"DNSSRVS_3")==0){
							dnservers[2].setfrom(pt);
						}else if (strcmp(line,"DOMAIN")==0){
							domain.setfrom (pt);
						}else if (strcmp(line,"SEARCH")==0){
							search.setfrom (pt);
						}
					}
				}
			}
			ret = pop.close();
			if (ret == 0){
				SSTRINGS searchs;
				str_splitline (search.get(),' ',searchs);
				resolv_updateconf (domain.get(),dnservers,searchs,true);
			}
		}
	}
	return ret;
}


/*
	Execute dhcpcd and extract the config obtained
*/
int dhcp_probe (INTER_INFO &itf)
{
	int ret = 0;
	DAEMON_INTERNAL *dae = daemon_find ("dhcpcd");
	if (dae != NULL && dae->is_managed()){
		bool problem;
		PROC *prc = dae->findprocess(problem);
		if (prc == NULL){
			netconf_system_if ("dhcpcd",itf.device.get());
		}
	}
	return ret;
}
