/*
	This API allows the firewall module to request some information
	about logical interface (such as dialout:config_name)
*/
#ifndef FWINFO_API_H
#define FWINFO_API_H

#include <module_api.h>
#include <module_apis/fwinfo_apidef.h>
static const char FWINFO_API_KEY[]="fwinfo";
static const int  FWINFO_API_REV=1;

inline int fwinfo_apis_init(
	const char *client,
	FWINFO_API *tb[])
{
	return module_get_apis (FWINFO_API_KEY,FWINFO_API_REV
		,client,(void*[])tb);
}

inline void fwinfo_apis_end(FWINFO_API *apis[], int nbapis)
{
	module_release_apis (FWINFO_API_KEY,(void*[])apis,nbapis);
}

inline bool fwinfo_api_available(const char *client)
{
	return module_api_available (FWINFO_API_KEY,FWINFO_API_REV,client);
}


#endif


