#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "mailconf.h"
#include "mailconf.m"
#include "internal.h"
#include <dialog.h>
#include <popen.h>
#include <netconf.h>
#include <userconf.h>

static MAILCONF_HELP_FILE help_mailq("mailq");

class MAILQ_ENTRY: public ARRAY_OBJ{
public:
	char id[10];
	int size;
	SSTRING date;
	SSTRING sender;
	SSTRING status;
	SSTRINGS dests;
	/*~PROTOBEG~ MAILQ_ENTRY */
public:
	MAILQ_ENTRY (const char *_id,
		 int _size,
		 const char *_date,
		 const char *_sender);
	int edit (void);
	/*~PROTOEND~ MAILQ_ENTRY */
};

PUBLIC MAILQ_ENTRY::MAILQ_ENTRY(
	const char *_id,
	int _size,
	const char *_date,
	const char *_sender)
{
	strncpy (id,_id,sizeof(id)-1);
	id[sizeof(id)-1] = '\0';
	sender.setfrom (_sender);
	date.setfrom (_date);
	size = _size;
}

/*
	Present the entry and return 1 if it was deleted
*/
PUBLIC int MAILQ_ENTRY::edit()
{
	int ret = 0;
	DIALOG dia;
	dia.newf_info (MSG_U(F_ID,"Message ID"),id);
	dia.newf_info (MSG_U(F_DATE,"Date sent"),date.get());
	dia.newf_info (MSG_U(F_SENDER,"Sender"),sender.get());
	dia.newf_num  (MSG_U(F_SIZE,"Size"),size);
	dia.set_lastreadonly();
	dia.newf_info (MSG_U(F_STATUS,"Status"),status.get());
	for (int i=0; i<dests.getnb(); i++){
		dia.newf_info (i==0 ? MSG_U(F_SENTTO,"Sent to") : ""
			,dests.getitem(i)->get());
	}
	int nof = 0;
	if (dia.edit (MSG_U(T_ONEMESSAGE,"One message status")
		,MSG_U(I_ONEMESSAGE
			,"This message is currently in sendmail queue.\n"
			 "You can delete from the queue if you want.\n"
			 "*** Are you really sure ? ***")
			,help_mailq
			,nof,MENUBUT_CANCEL|MENUBUT_DEL) == MENU_DEL){
		if (perm_rootaccess(MSG_U(P_DELMESSAGE
			,"to delete queued email messages"))){
			ret = 1;
			net_introlog (NETINTRO_MISC);
			net_prtlog (NETLOG_VERB,MSG_U(N_DELMESSAGE
				,"Deleting mail message %s: size %d from %s\n")
				,id,size,sender.get());
			net_prtlog (NETLOG_VERB,MSG_U(N_MESSAGESENT,"Sent on %s\n")
				,date.get());
			for (int i=0; i<dests.getnb(); i++){
				net_prtlog (NETLOG_VERB,MSG_U(N_MESSAGETO,"Sent to %s\n")
					,dests.getitem(i)->get());
			}
			const char *mqueue = configf_lookuppath ("/var/spool/mqueue");
			SSTRINGS tb;
			int n = dir_getlist (mqueue,tb);
			for (int i=0; i<n; i++){
				const char *s = tb.getitem(i)->get();
				if (strcmp(s+2,id)==0){
					char path[PATH_MAX];
					sprintf (path,"%s/%s",mqueue,s);
					unlink (path);
				}
			}
		}
	}
	return ret;
}



class MAILQ_ENTRIES: public ARRAY{
	/*~PROTOBEG~ MAILQ_ENTRIES */
public:
	MAILQ_ENTRY *getitem (int no)const;
	/*~PROTOEND~ MAILQ_ENTRIES */
};

PUBLIC MAILQ_ENTRY *MAILQ_ENTRIES::getitem (int no) const
{
	return (MAILQ_ENTRY*)ARRAY::getitem(no);
}


void mailq_edit()
{
	DIALOG_LISTE *dia = NULL;
	int nof = 0;
	MAILQ_ENTRIES entries;
	while (1){
		if (dia == NULL){
			dia = new DIALOG_LISTE;
			POPEN pop ("mailq");
			entries.remove_all();
			if (pop.isok()){
				MAILQ_ENTRY *last = NULL;
				while (pop.wait(10)!=-1){
					char buf[1000];
					while (pop.readout(buf,sizeof(buf)-1)!=-1){
						strip_end (buf);
						if (buf[0] == '-'){
							continue;
						}else if (buf[0] > ' '){
							char id[10];
							char *pt = str_copyword (id,buf,sizeof(id));
							id[8] = '\0';
							pt = str_skip(pt);
							int size = atoi(pt);
							// skip number and negative sign if there
							if (pt[0] == '-') pt++;
							pt = str_skipdig(pt);
							pt = str_skip(pt);
							char *date = pt;
							// Jump to the end and step back to the start
							// of the word
							char *sender = date + strlen(date);
							while (sender > date && sender[-1] > ' ') sender--;
							sender[-1] = '\0';
							last = new MAILQ_ENTRY (id,size,date,sender);
							entries.add (last);
						}else if (last != NULL
							&& (buf[0] == ' ' || buf[0] == '\t')){
							char *pt = str_skip (buf);
							if (pt[0] == '('){
								// Remove the ()
								pt++;
								pt[strlen(pt)-1] = '\0';
								last->status.setfrom (pt);
							}else{
								last->dests.add (new SSTRING(pt));
							}
						}
					}
				}
			}
			dia->newf_head ("",MSG_U(H_MAILQ,"Id\tSender\tDate\tSize"));
			for (int i=0; i<entries.getnb(); i++){
				MAILQ_ENTRY *ent = entries.getitem(i);
				char buf[100];
				snprintf (buf,sizeof(buf)-1,"%s\t%s\t%d"
					,ent->sender.get(),ent->date.get(),ent->size);
				dia->new_menuitem (ent->id,buf);
			}
		}
		MENU_STATUS code = dia->editmenu (MSG_U(T_MAILQ,"Mail queue")
			,MSG_U(I_MAILQ,"This is the list in the queue.\n"
				"You can review their status and erase them if need")
			,help_mailq
			,nof,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (nof >= 0 && nof < entries.getnb()){
			if (entries.getitem(nof)->edit()==1){
				delete dia;
				dia = NULL;
			}
		}
	}
	delete dia;
}
			

