#pragma interface
#ifndef FVIEWS_H
#define FVIEWS_H

#ifndef MISC_H
	#include "misc.h"
#endif

class CONFIG_FILE;
class PRIVILEGE;

// #Specbeg: VIEWITEM / layout
class VIEWITEM: public ARRAY_OBJ{
public:
	SSTRING comment;		// Full line comments before this line
	SSTRING line;
	SSTRING endcomment;		// Comment at the end of the line
	// #Specend:
	/*~PROTOBEG~ VIEWITEM */
public:
	VIEWITEM (const SSTRING&_comment,
		 const char *_line,
		 const SSTRING&_endcomment);
	VIEWITEM (const char *_line);
	/*~PROTOEND~ VIEWITEM */
};

class VIEWITEMS: public ARRAY{
	SSTRING firstcomment;
	SSTRING lastcomment;
	char comcar;		// Special char identifying comments
	/*~PROTOBEG~ VIEWITEMS */
public:
	VIEWITEMS (void);
	VIEWITEM *getitem (int no)const;
	VIEWITEM *locate (const char *key);
	int locate (const char *key, VIEWITEMS&items);
	VIEWITEM *locate (const char *key1,
		 const char *key2);
	int locate (const char *key1,
		 const char *key2,
		 VIEWITEMS&items);
private:
	int locate_gen (const char *key,
		 VIEWITEMS&items,
		 bool fullmatch);
public:
	int locate_prefix (const char *key,
		 VIEWITEMS&items);
	VIEWITEM *locateassign (const char *var);
	int locatebval (const char *var);
	int locatehval (const char *var);
	int locatenval (const char *var);
	const char *locateval (const char *var,
		 char tmp[1000]);
	int read (CONFIG_FILE&fconf);
	void setcomcar (char com);
	void update (const char *var, const SSTRING&val);
	void update (const char *var, const char *val);
	void update (const char *var, int val);
	void updatebval (const char *var, bool val);
	void updatehval (const char *var, int val);
	int write (CONFIG_FILE&fconf, PRIVILEGE *priv);
	/*~PROTOEND~ VIEWITEMS */
};

#endif
