#!/bin/sh
# This script try to stuff linuxconf base configuration out
# of slackware specific configuration files
echo Probing Slackware specific information
echo
INET1=/etc/rc.d/rc.inet1
TMPVAR=/tmp/inet1.var.sh
grep IPADDR= $INET1   >$TMPVAR
grep NETMASK= $INET1 >>$TMPVAR
grep GATEWAY= $INET1 >>$TMPVAR
HOSTNAME=`cat /etc/HOSTNAME`
chmod +x $TMPVAR
. $TMPVAR
DEVICE=eth0
echo "Main network device  is" $DEVICE
echo "Setting hostname     to" $HOSTNAME
echo "Setting IP address   to" $IPADDR
echo "Setting netmask      to" $NETMASK
netconf --setdevdef 0 $HOSTNAME $IPADDR $NETMASK $DEVICE
if [ "$GATEWAY" != ""  -a "$GATEWAY" != "localhost" ] ; then
	netconf --setgateway $GATEWAY
	echo "Setting gateway      to" $GATEWAY
fi

