
#ifndef _SCREEN_LIST_H
#define _SCREEN_LIST_H

#include <list/filters.h>
#include <list/sorting.h>
#include <list/packages.h>

#include <func/keys.h>

class ScreenList
{
      public:
	struct Screen;

	enum view_t
	{ Normal = 0, Verbose = 1 };
	enum init_t
	{ PkgInit, noPkgInit };

	Screen *filtnorm, *filtinv, *markstat;

	void boundreset(Screen *);
	void align_all_bounds();
	Screen *add(init_t Op = PkgInit);
	void remove(Screen *);

	// List Accessors (This isn't very safe!)
	inline Screen *Head()
	{
		return _head;
	};
	inline Screen *Current()
	{
		return _current;
	};

	// Attempt to behave like a struct Screen
	inline Screen *operator->()
	{
		return Current();
	};
	inline void operator = (Screen * B) { _current = B;
	};

	 ScreenList();
	~ScreenList();

      protected:
	 Screen * _head, *_current;
};

struct ScreenList::Screen
{
	long _cursor, _boundstart, _boundend;
	 PackageList::Package * Cursor, *boundstart, *boundend;

	enum view_t mode;
	unsigned int scroll;

	KeyHandler *kdriver;
	sortorderlist *Sorting;
	PackageList *Packages;

	struct ScreenList::Screen * next;
	struct ScreenList::Screen * prev;
};

extern ScreenList screen;

#endif
