
#include <std.h>
#include <ops.h>
#include <parsers/strutl.h>
#include <func/apt.h>
#include <list/filters.h>
#include <list/screens.h>

// Begin "PackageList" class functions

PackageList::PackageList(ListType Init = AllPkgs)
{
	_Head = NULL;
	_Tail = NULL;
	PackageCount = 0;

	FilteredMode = FilterList::None;

	Type = Init;

	if (Type == AllPkgs)
		inject_all_packages();
	else if (Type == ModPkgs)
		inject_changed_packages();
}

PackageList::PackageList(FilterList::FilterMode NewMode, ListType Init = AllPkgs)
{
	_Head = NULL;
	_Tail = NULL;
	PackageCount = 0;

	FilteredMode = NewMode;

	Type = Init;

	if (Type == AllPkgs)
		inject_all_packages();
	else if (Type == ModPkgs)
		inject_changed_packages();
}

PackageList::~PackageList()
{
	free_list();
}

void PackageList::reinitialize()
{
	free_list();

	if (Type == AllPkgs)
		inject_all_packages();
	else if (Type == ModPkgs)
		inject_changed_packages();
}

void PackageList::inject_all_packages()
{
	pkgCache::PkgIterator I;
	pkgCache::VerIterator V;

	Package *P;

	pkgCache::Package ** SortedPkgs = new pkgCache::Package *[Cache->Head().PackageCount + 1];

	char *section_ptr = "/dev/null";
	char *priority_ptr = "/dev/null";
	char *new_section;

	register int J = 0;
	int State = -100;

	int cur_increment = 0, prev_increment = 0;

	if (FilteredMode != FilterList::None)
	{
		for (I = Cache->PkgBegin(); I.end() != true; I++)
			if (Filters.Match(I, FilteredMode) == false)
				SortedPkgs[J++] = I;
	}
	else
	{
		for (I = Cache->PkgBegin(); I.end() != true; I++)
			SortedPkgs[J++] = I;
	}

	SortedPkgs[J] = 0;

	qsort(SortedPkgs, J, sizeof(*SortedPkgs), sortorderlist::qsort_handler);

	bool Shown[3];
	int H;

	for (register int K = 0; K < J; K++)
	{
		pkgCache::PkgIterator curPkg(*CacheFile, SortedPkgs[K]);

		V = (*Cache)[curPkg].CandidateVerIter(*Cache);

		if (V.end() == true)
			continue;

		Shown[0] = Shown[1] = Shown[2] = false;
		H = 0;

		for (sortorderlist::SortIterator S = screen->Sorting->ListBegin(); S.end() == false; S++, H++)
		{
			switch (S.method())
			{
			case sortorderlist::Section:

				new_section = (char *) curPkg.Section();

				if (new_section == NULL)
					new_section = "";

				if (strcmp(section_ptr, new_section) != 0 || Shown[0] == true || Shown[1] == true)
				{
					cur_increment = screen->Sorting->FindIncrement(sortorderlist::Section);

					if (cur_increment < prev_increment)
						cur_increment = prev_increment;

					P = add();

					P->pkg = curPkg;
					P->type = PackageList::Div_Sect;
					P->increment = cur_increment;

					Shown[H] = true;
				}
				break;

			case sortorderlist::Status:

				if ((*Cache)[curPkg].Status != State || Shown[0] == true || Shown[1] == true)
				{
					cur_increment = screen->Sorting->FindIncrement(sortorderlist::Status);

					if (cur_increment < prev_increment)
						cur_increment = prev_increment;

					P = add();
					P->pkg = curPkg;
					P->type = PackageList::Div_State;
					P->increment = cur_increment;

					Shown[H] = true;
				}
				break;

			case sortorderlist::Priority:

				if (strcmp(V.PriorityType(), priority_ptr) != 0 || Shown[0] == true || Shown[1] == true)
				{
					cur_increment = screen->Sorting->FindIncrement(sortorderlist::Priority);

					if (cur_increment < prev_increment)
						cur_increment = prev_increment;

					P = add();

					P->pkg = curPkg;
					P->type = PackageList::Div_Pri;
					P->increment = cur_increment;

					Shown[H] = true;
				}

				// These currently do not have dividers -- it would be unethical
				//
			case sortorderlist::None:
			case sortorderlist::PkgName:
			case sortorderlist::Size:
			case sortorderlist::Instsize:
				break;
			}
		}

		// Standard package! Woop.
		P = add();
		P->pkg = curPkg;
		SetType(P, Pkg);
		P->increment = cur_increment;

		// Record previous priority
		priority_ptr = (char *) V.PriorityType();

		// Record previous section
		if (curPkg.Section() == NULL)
			section_ptr = "";
		else
			section_ptr = (char *) curPkg.Section();

		// Record previous inst state
		State = (*Cache)[curPkg].Status;

		// Record previous inclevel
		prev_increment = cur_increment;
	}

	delete[]SortedPkgs;
}

void PackageList::inject_changed_packages()
{
	pkgCache::PkgIterator I;

	Package *P;

	P = add();

	P->increment = 0;
	P->type = PackageList::Div_Custom;
	P->flags = PackageList::None;
	P->Extra = (char *) strdup("New packages that will be installed");

	for (I = Cache->PkgBegin(); I.end() != true; I++)
	{
		if ((*Cache)[I].CandidateVerIter(*Cache).end() == true)
			continue;

		if ((*Cache)[I].NewInstall() == true)
		{
			P = add();

			P->increment = 1;
			P->type = PackageList::Pkg;
			P->pkg = I;
			P->flags = PackageList::None;
		}
	}

/*	P = add();

	P->increment = 0;
	P->type = PackageList::Div_Custom;
	P->flags = PackageList::None;
	P->Extra = (char *) strdup("Extra packages that will be installed");
	
	for (I = Cache->PkgBegin(); I.end() != true; I++)
	{
		if ((*Cache)[I].CandidateVerIter(*Cache).end() == true)
			continue;

		if ((*Cache)[I].NewInstall() == true)
		{
		P = add();

		P->increment = 1;
		P->type = PackageList::Pkg;
		P->pkg = I;
		P->flags = PackageList::None;
	}
*/

	P = add();

	P->increment = 0;
	P->type = PackageList::Div_Custom;
	P->flags = PackageList::None;
	P->Extra = (char *) strdup("Packages that will be deleted");

	for (I = Cache->PkgBegin(); I.end() != true; I++)
	{
		if ((*Cache)[I].CandidateVerIter(*Cache).end() == true)
			continue;

		if ((*Cache)[I].Delete() == false)
			continue;

		P = add();

		P->increment = 1;
		P->type = PackageList::Pkg;
		P->pkg = I;
		P->flags = PackageList::None;
	}

	P = add();

	P->increment = 0;
	P->type = PackageList::Div_Custom;
	P->flags = PackageList::None;
	P->Extra = (char *) strdup("Packages that will be upgraded");

	for (I = Cache->PkgBegin(); I.end() != true; I++)
	{
		if ((*Cache)[I].Upgrade() == false || (*Cache)[I].NewInstall() == true)
			continue;

		if ((*Cache)[I].CandidateVerIter(*Cache).end() == true)
			continue;

		P = add();

		P->increment = 1;
		P->type = PackageList::Pkg;
		P->pkg = I;
		P->flags = PackageList::None;
	}

/*	P = add();

	P->increment = 0;
	P->type = PackageList::Div_Custom;
	P->flags = PackageList::None;
	P->Extra = (char *) strdup("Packages that will be kept back");

	for (I = Cache->PkgBegin(); I.end() != true; I++)
	{
		if ((*Cache)[I].CandidateVerIter(*Cache).end() == true)
			continue;

		if ((*Cache)[I].Upgrade() == true || (*Cache)[I].Upgradable() == false || I->CurrentVer == 0 || (*Cache)[I].Delete() == true)
			continue;

		P = add();

		P->increment = 1;
		P->type = PackageList::Pkg;
		P->pkg = I;
		P->flags = PackageList::None;
	}
	*/
}

void PackageList::free_list(void)
{
	Package *z, *v;

	for (z = _Head; z != NULL; z = v)
	{
		v = z->next;
		remove(z);
	}
}

PackageList::Package * PackageList::append(Package * pos)
{
	Package *ptr;

	if (pos == NULL)
		return NULL;

	ptr = pos->next;

	pos->next = (Package *) malloc(sizeof(Package));

	memset(pos->next, 0, sizeof(Package));

	pos->next->prev = pos;
	pos->next->next = ptr;
	if (ptr != NULL)
		ptr->prev = pos->next;

	PackageCount++;

	return pos->next;
}

PackageList::Package * PackageList::add(Package * carbon = NULL)
{
	Package *P = NULL;

	if (_Head == NULL)
	{
		_Head = (Package *) malloc(sizeof(Package));

		if (carbon == NULL)
			memset(_Head, 0, sizeof(Package));
		else
			memcpy(_Head, carbon, sizeof(Package));

		_Head->next = NULL;
		_Head->prev = NULL;

		_Tail = _Head;

		P = _Head;
	}
	else
	{
		_Tail->next = (Package *) malloc(sizeof(Package));

		if (carbon == NULL)
			memset(_Tail->next, 0, sizeof(Package));
		else
			memcpy(_Tail->next, carbon, sizeof(Package));

		_Tail->next->next = NULL;
		_Tail->next->prev = _Tail;

		_Tail = _Tail->next;

		P = _Tail;
	}

	if (carbon == NULL)
		P->p_parent = NULL;

	PackageCount++;

	return P;
}

void PackageList::remove(Package * p)
{
	Package *x, *y;

	x = p->next;
	y = p->prev;

	if (p == _Head)
		_Head = x;

	if (p == _Tail)
		_Tail = y;

	free(p);

	if (x != NULL)
		x->prev = y;

	if (y != NULL)
		y->next = x;

	PackageCount--;
}

void PackageList::Locate(char *substring, unsigned long options)
{
	regex_t rectx;

	if (options & SEARCH_REGEX)
	{
		int reflags = REG_EXTENDED | REG_NOSUB;

		if (options & SEARCH_CASE)
			reflags |= REG_ICASE;

		regcomp(&rectx, substring, reflags);
	}
	else if (options & SEARCH_CASE)
	{
		strlower(substring);
	}

	for (Package * P = _Head; P != NULL; P = P->next)
	{
		if (IsDivider(P))
			continue;

		const char *desc;

		if ((options & SEARCH_DESC))
			desc = Recs->Lookup(((*Cache)[P->pkg].CandidateVerIter(*Cache)).FileList()).LongDesc().c_str();
		else
			desc = NULL;

		if (search_string(P->pkg.Name(), substring, options, &rectx))
			AddFlag(P, Matched);
		else if (desc && search_string(desc, substring, options, &rectx))
			AddFlag(P, Matched);
	}

	if (options & SEARCH_REGEX)
		regfree(&rectx);
}

PackageList::Package * PackageList::LocateNext(bool start_at_beginning = false)
{
	Package *P = NULL;

	switch (start_at_beginning)
	{
	case true:
		P = _Head;
		break;
	case false:
		P = screen->Cursor;
		break;
	}

	for (; P != NULL; P = P->next)
	{
		if (IsDivider(P) || P == screen->Cursor)
			continue;

		if (IsMatched(P))
			return P;
	}

	return NULL;
}

void PackageList::ClearFlag(pkgFlags Z)
{
	for (Package * P = _Head; P != NULL; P = P->next)
	{
		if (IsDivider(P))
			continue;

		(int) P->flags &= ~Z;
	}
}

void PackageList::ClearFlag(Package * P, pkgFlags Z)
{
	if (!IsDivider(P))
		(int) P->flags &= ~Z;
}

void PackageList::AddFlag(pkgFlags Z)
{
	for (Package * P = _Head; P != NULL; P = P->next)
	{
		if (IsDivider(P))
			continue;

		(int) P->flags |= Z;
	}
}

void PackageList::AddFlag(Package * P, pkgFlags Z)
{
	if (!IsDivider(P))
		(int) P->flags |= Z;
}

int PackageList::CountFlag(pkgFlags Z)
{
	int count = 0;

	for (Package * P = _Head; P != NULL; P = P->next)
	{
		if (IsDivider(P))
			continue;

		if (P->flags & Z)
			count++;
	}

	return count;
}

void PackageList::SetType(Package * P, pkgType Z)
{
	P->type = Z;
};
bool PackageList::IsDivider(Package * P)
{
	return (P->type == Pkg ? false : true);
};
bool PackageList::IsMatched(Package * P)
{
	return (P->flags & Matched);
};
bool PackageList::IsExpanded(Package * P)
{
	return (P->flags & Expanded);
};
