
#include <stdlib.h>

#include <std.h>

#include <list/screens.h>
#include <list/sorting.h>
#include <list/colors.h>

#include <parsers/color.h>

#include "coreui.h"
#include "wrappers.h"

#include "sortui.h"

void sort_select_method()
{
	char buf[100];
	UniqueWindow *Popup = new UniqueWindow(21, 60, CenterY(21), CenterX(60));
	sortorderlist::SortIterator S;
	int I;

	Popup->ChangeTitle("Sort Editor");

	while (1)
	{
		Popup->Erase();

		wattrset(Popup->body(), Pair(COLOR_MAGENTA, COLOR_BLUE) | A_BOLD);
		mvwprintw(Popup->body(), 1, 0, " Please select an option to change your sorting:");
		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
		mvwprintw(Popup->body(), 4, 0, "   I  ==  Insert new before an installed method");
		mvwprintw(Popup->body(), 3, 0, "   A  ==  Append new at end of the list");
		mvwprintw(Popup->body(), 5, 0, "   D  ==  Delete installed sort method");
		mvwprintw(Popup->body(), 6, 0, "   M  ==  Modify installed sort method");
		wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
		mvwprintw(Popup->body(), 7, 0, "   Q  ==  Quit back to main list");

		wattrset(Popup->body(), Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);

		sprintf(buf, "  You currently have %d sorting methods installed.", screen->Sorting->Length());
		mvwprintw(Popup->body(), 11, 0, buf);

		int list_start = 13, list_end = 20;

		wattrset(Popup->body(), Pair(COLOR_YELLOW, COLOR_BLUE) | A_BOLD);

		for (I = list_start, S = screen->Sorting->ListBegin(); S.end() != true && I < list_end; S++, I++)
		{
			char *sorttext = sort_to_str(S.method());

			mvwprintw(Popup->body(), I, 0, "  ` Method %d (Packages by %s)", I - list_start + 1, sorttext);

			free(sorttext);
		}

		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

		bool listchanged = false;

		switch (wgetch(Popup->body()))
		{
		case 'i':
		case 'I':
			listchanged = sort_insert(Popup, false);
			break;

		case 'a':
		case 'A':
			listchanged = sort_insert(Popup, true);
			break;

		case 'd':
		case 'D':
			listchanged = sort_delete(Popup);
			break;

		case 'm':
		case 'M':
			listchanged = sort_modify(Popup);
			break;

		case 'q':
		case 'Q':
			delete Popup;
			ui_redraw_current();
			return;
		}

		if (listchanged == true)
		{
			delete screen->Packages;
			screen->Packages = new PackageList;
			screen.boundreset(screen.Current());
			ui_redraw_current();
			Popup->Redraw();
			Popup->Refresh();

			// whee
			screen->Sorting->commit_to_config();
		}
	}
}

bool sort_insert(UniqueWindow * Popup, bool Append = false)
{
	int I;
	sortorderlist::SortIterator S = screen->Sorting->ListEnd();

	curs_set(1);

	if (Append == false)
	{
		for (I = 0; I <= 10; I++)
		{
			wmove(Popup->body(), I, 0);
			wclrtoeol(Popup->body());
		}

		wattrset(Popup->body(), Pair(COLOR_MAGENTA, COLOR_BLUE) | A_BOLD);
		mvwprintw(Popup->body(), 1, 2, "Please enter the number of the sort method that");
		mvwprintw(Popup->body(), 2, 2, "you would like to insert a new entry /before/.");

		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
		mvwprintw(Popup->body(), 4, 7, "Insert before ('Q' aborts): ");

		Popup->Refresh();

		while (1)
		{
			char c = wgetch(Popup->body());

			if (c == 'q' || c == 'Q')
			{
				curs_set(0);
				return false;
			}

			c -= 48;

			if (screen->Sorting->Exists((sortorderlist::method_t) c))
			{
				for (S = screen->Sorting->ListBegin(); S.end() == false; S++)
					if (S.seq() == (unsigned) c)
						break;

				break;
			}
			else
			{
				wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
				mvwprintw(Popup->body(), 6, 7, "That method doesn't exist!");
				wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			}
		}
	}

	for (I = 0; I <= 10; I++)
	{
		wmove(Popup->body(), I, 0);
		wclrtoeol(Popup->body());
	}

	wattrset(Popup->body(), Pair(COLOR_MAGENTA, COLOR_BLUE) | A_BOLD);
	ColorMVPrintW(Popup->body(), 1, 0, COLOR_BLUE, A_BOLD, " %s ($3#yellow$! = installed, $7#white$! = available):", Append == true ? "Append" : "Insert");

	if (screen->Sorting->Exists(sortorderlist::Section))
		wattrset(Popup->body(), Pair(COLOR_YELLOW, COLOR_BLUE));
	else
		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 3, 0, "   T  ==  Type / section / area");

	if (screen->Sorting->Exists(sortorderlist::PkgName))
		wattrset(Popup->body(), Pair(COLOR_YELLOW, COLOR_BLUE));
	else
		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 4, 0, "   N  ==  Name (alphabetically)");

	if (screen->Sorting->Exists(sortorderlist::Priority))
		wattrset(Popup->body(), Pair(COLOR_YELLOW, COLOR_BLUE));
	else
		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 5, 0, "   P  ==  Priority (needworthyness)");

	if (screen->Sorting->Exists(sortorderlist::Status))
		wattrset(Popup->body(), Pair(COLOR_YELLOW, COLOR_BLUE));
	else
		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 6, 0, "   S  ==  Status (installed / upgraded)");

	if (screen->Sorting->Exists(sortorderlist::Size))
		wattrset(Popup->body(), Pair(COLOR_YELLOW, COLOR_BLUE));
	else
		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 7, 0, "   A  ==  Archive size (download)");

	if (screen->Sorting->Exists(sortorderlist::Instsize))
		wattrset(Popup->body(), Pair(COLOR_YELLOW, COLOR_BLUE));
	else
		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 8, 0, "   I  ==  Installed size (unpacked)");

	wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 9, 0, "   Q  ==  Go back [Exit]");

	wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

	mvwprintw(Popup->body(), 6, 42, "Your choice: ");

	Popup->Refresh();

	bool exitloop = false, listchanged = false;

	while (exitloop == false)
	{
		char c = wgetch(Popup->body());

		switch (c)
		{
		case 'q':
		case 'Q':
			curs_set(0);
			return listchanged;

		case 't':
		case 'T':
			if (!screen->Sorting->Exists(sortorderlist::Section))
			{
				if (Append == true)
					screen->Sorting->Push(sortorderlist::Section);
				else
					screen->Sorting->Insert(S, sortorderlist::Section);
				exitloop = true;
				listchanged = true;
			}
			else
			{
				wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
				mvwprintw(Popup->body(), 4, 42, "Already exists!");
				wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			}
			break;

		case 'n':
		case 'N':
			if (!screen->Sorting->Exists(sortorderlist::PkgName))
			{
				if (Append == true)
					screen->Sorting->Push(sortorderlist::PkgName);
				else
					screen->Sorting->Insert(S, sortorderlist::PkgName);
				exitloop = true;
				listchanged = true;
			}
			else
			{
				wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
				mvwprintw(Popup->body(), 4, 42, "Already exists!");
				wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			}
			break;

		case 'p':
		case 'P':
			if (!screen->Sorting->Exists(sortorderlist::Priority))
			{
				if (Append == true)
					screen->Sorting->Push(sortorderlist::Priority);
				else
					screen->Sorting->Insert(S, sortorderlist::Priority);
				exitloop = true;
				listchanged = true;
			}
			else
			{
				wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
				mvwprintw(Popup->body(), 4, 42, "Already exists!");
				wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			}
			break;

		case 's':
		case 'S':
			if (!screen->Sorting->Exists(sortorderlist::Status))
			{
				if (Append == true)
					screen->Sorting->Push(sortorderlist::Status);
				else
					screen->Sorting->Insert(S, sortorderlist::Status);
				exitloop = true;
				listchanged = true;
			}
			else
			{
				wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
				mvwprintw(Popup->body(), 4, 42, "Already exists!");
				wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			}
			break;

		case 'a':
		case 'A':
			if (!screen->Sorting->Exists(sortorderlist::Size))
			{
				if (Append == true)
					screen->Sorting->Push(sortorderlist::Size);
				else
					screen->Sorting->Insert(S, sortorderlist::Size);
				exitloop = true;
				listchanged = true;
			}
			else
			{
				wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
				mvwprintw(Popup->body(), 4, 42, "Already exists!");
				wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			}
			break;

		case 'i':
		case 'I':
			if (!screen->Sorting->Exists(sortorderlist::Instsize))
			{
				if (Append == true)
					screen->Sorting->Push(sortorderlist::Instsize);
				else
					screen->Sorting->Insert(S, sortorderlist::Instsize);
				exitloop = true;
				listchanged = true;
			}
			else
			{
				wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
				mvwprintw(Popup->body(), 4, 42, "Already exists!");
				wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			}
			break;

		default:
			wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);
			mvwprintw(Popup->body(), 4, 42, "               ");
			mvwprintw(Popup->body(), 4, 42, "Bad key!");
			wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
			break;
		}

		wmove(Popup->body(), 6, 55);
		Popup->Refresh();
	}

	curs_set(0);

	return listchanged;
}

bool sort_delete(UniqueWindow * Popup)
{
	int I;

	for (I = 0; I <= 10; I++)
	{
		wmove(Popup->body(), I, 0);
		wclrtoeol(Popup->body());
	}

	curs_set(1);

	char c;

	sortorderlist::SortIterator S;

	while (1)
	{
		mvwprintw(Popup->body(), 5, 12, "('Q' to exit)");
		mvwprintw(Popup->body(), 4, 12, "Delete method number: ");

		Popup->Refresh();

		c = wgetch(Popup->body());

		if (c == 'q' || c == 'Q')
		{
			curs_set(0);
			return false;
		}

		if (c >= 49 && c <= 58)
			c -= 48;
		else
			c = -1;

		//mvwprintw(Popup->body(), 0, 0, "%d", c);

		bool exitloop = false;

		for (I = 1, S = screen->Sorting->ListBegin(); S.end() != true; S++, I++)
			if (I == (int) c)
			{
				exitloop = true;
				break;
			}

		if (exitloop == true)
			break;

		wattrset(Popup->body(), Pair(COLOR_RED, COLOR_BLUE) | A_BOLD);

		mvwprintw(Popup->body(), 2, 6, "Error! Can't delete a nonexistant method.");

		wattrset(Popup->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
	}

	screen->Sorting->remove(S);

	curs_set(0);

	return true;
}

bool sort_modify(UniqueWindow * Popup)
{
	return false;
}

/*
 * Note - memory is allocated, that must be freed.
 */
char *sort_to_str(sortorderlist::method_t ThisMethod)
{
	char *str = (char *) malloc(100);

	switch (ThisMethod)
	{
	case sortorderlist::None:
		break;
	case sortorderlist::Section:
		strcpy(str, "type/section");
		break;
	case sortorderlist::PkgName:
		strcpy(str, "name, alphabetically");
		break;
	case sortorderlist::Priority:
		strcpy(str, "install-need priority");
		break;
	case sortorderlist::Status:
		strcpy(str, "installed/upgraded status");
		break;
	case sortorderlist::Size:
		strcpy(str, "archive size");
		break;
	case sortorderlist::Instsize:
		strcpy(str, "installed size");
		break;
	}

	return str;
}
