
#ifndef _format_strings_H
#define _format_strings_H

/*-----------------------------------------------------------------*/
/*    Unless otherwise specified, defs have no format chars (%)    */
/*-----------------------------------------------------------------*/

/* Strings that findicate if the item has been expanded or not */
#define FMT_DIV_EXPN   "$7[$7#-$7] $!"
#define FMT_DIV_NEXPN  "$7[$7#+$7] $!"

/* Three different modes of a package state */
#define FMT_DIV_STAT_INST     "Installed packages (newer version is available)"
#define FMT_DIV_STAT_NOTINST  "Non-installed packages (available for installation)"
#define FMT_DIV_STAT_UPGR     "Upgraded packages (can only purge or remove)"

/* Displayed divider for packages with no section */
#define FMT_DIV_SECT_NULL     "Foreign packages (without section)"

/* Displayed divider for packages that have a null priority type */
#define FMT_DIV_PRI_NULL      "Unknown packages"

/*-----------------------------------------------------------------*/

/* Strings that findicate if the item has been expanded or not */
#define FMT_PKG_EXPN   "$7[$7#-$7] $!"
#define FMT_PKG_NEXPN  "$7[$7#+$7] $!"

/* Strings for when specific objects yield a null value */
#define FMT_PKG_PRI_NULL      "Unknown"
#define FMT_PKG_SECT_NULL     "<none>"
#define FMT_PKG_CANDVER_NULL  "<none>"
#define FMT_PKG_INSTVER_NULL  "<none>"

/* Priority, 
 * Package Name, 
 * Candidate Version */
#define FMT_PKG_VWNORM_LEFT   "%-9s %-17s %-18s"
// Same, but without decimal values (for wtop)
#define FMT_TOP_VWNORM_LEFT   "    %-9s %-17s %-18s"

/* Installed Version, 
 * Size, 
 * Installed Size, 
 * Section */
#define FMT_PKG_VWNORM_RIGHT  "%18s %6dK %6dK %10s "
// Same, but without decimal values (for wtop)
#define FMT_TOP_VWNORM_RIGHT  "    %18s %6s %6s %10s "

/* Priority, 
 * Package Name, 
 * Section, 
 * Candidate Version, 
 * Installed Version, 
 * Size, 
 * Installed Size, 
 * Short Description */
#define FMT_PKG_VWVERB_LEFT   "%-3s %-12s %-8s %-10s %-10s %-6d %-6d  %s"
// Same, but without decimal values (for wtop)
#define FMT_TOP_VWVERB_LEFT   "    %-3s %-12s %-8s %-10s %-10s %-6s %-6s  %s"

/*-----------------------------------------------------------------*/

/* Package Name,
 * Installed ?,
 * Upgraded ?,
 * Marked state (install/delete) ? */
#define FMT_DTOP_LEFT         "%-15s %s, %s; %s"

/* These displayed in the description window when
 * a certain divider has the cursor on it. */
#define FMT_DWIN_DIV_SECT     "Wow, it's the start of a new package section!"
#define FMT_DWIN_DIV_PRI      "Wow, it's the start of a new package priority!"
#define FMT_DWIN_DIV_STATE    "Wow, it's the start of a new package installation state!"
/* Optional text specified in PackageList::Package::Extra */
#define FMT_DWIN_DIV_CUST     "%s"

/*-----------------------------------------------------------------*/

/* Current Percentage of List,
 * Short Description of Package */
#define FMT_STAT_LEFT         "$7#[$5#Pos'n $!%03d%%$7#]"
/* Current program version */
#define FMT_STAT_RIGHT        "$7#[$1%s$7#]"

/* Counts of Install, Delete, Keep, Broken, Bad packages */
#define FMT_STAT_CENTER       " Install..$7#%lu$! Delete...$7#%lu$! Keep....$7#%lu$! Broken...$7#%lu$! "

#define FMT_STAT_FILTINV      "$7#[$2Inverted$7#] "
/* Number of filters present */
#define FMT_STAT_FILT         "$7#[$5Filters: $6%d$7#] "


/* These displayed in the status window at the bottom
 * when a certain divider has the cursor on it. */
#define FMT_STAT_DIV_SECT     "`-> This represents a whole section of packages"
#define FMT_STAT_DIV_PRI      "`-> This represents the priority of the underlying packages"
#define FMT_STAT_DIV_STATE    "`-> This represents the installation state of the underlying packages"
/* Optional text specified in PackageList::Package::Extra */
#define FMT_STAT_DIV_CUST     "%s"

/*-----------------------------------------------------------------*/

#endif
