
/*
 * I'm not sure what this does yet...  I'll be sure to let you know ...
 */

#include <std.h>
#include <func/apt.h>
#include <func/config.h>
#include <parsers/color.h>
#include <interface/coreui.h>
#include <interface/dialogs.h>
#include <list/colors.h>
#include <list/screens.h>
#include <list/filters.h>
#include <string>

#include "acquire.h"
#include "acquire_status.h"
#include "captris.h"

#include <sys/vfs.h>

pkgAcquireInterface::pkgAcquireInterface(AcquireMaster _Type = UI)
{
	MasterType = _Type;

	WindowsActive = false;
	NoCacheInit = false;

	Game = NULL;
	extra = NULL;
}

pkgAcquireInterface::~pkgAcquireInterface()
{
	if (WindowsActive == true)
		DestroyWindows();

	if (Game != NULL)
		delete Game;

	/* 
	 * If we're returning to the CAPT UI then the changes that we made
	 * by doing an operation must be put into affect immediately.
	 */

	if (MasterType == UI)
	{
		if (NoCacheInit == false)
			global_cache_reinit();

		doupdate();
	}
	else
	{
		doupdate();
		clear();
		refresh();
	}

}

void pkgAcquireInterface::AcquireUpdate()
{
	// Get the source list
	pkgSourceList List;
	if (List.ReadMainList() == false)
	{
		Error("Unable to read sources list");
		return;
	}

	// Lock the list directory
	FileFd Lock;
	if (_config->FindB("Debug::NoLocking", false) == false)
		Lock.Fd(GetLock(_config->FindDir("Dir::State::Lists") + "lock"));
	if (_error->PendingError() == true)
		_error->Discard();

	// Create the download object
	AcquireStatus Stat(this);
	pkgRealAcquire Fetcher(&Stat, this);
	pFetcher = &Fetcher;
	pStat = &Stat;

	// Populate it with the source selection
	pkgSourceList::const_iterator I;
	for (I = List.begin(); I != List.end(); I++)
	{
		new pkgAcqIndex(&Fetcher, I);

		// I wonder what error this is .....
		if (_error->PendingError() == true)
			return;
	}

	/*
	 * At this point we are ready do deal with the interface
	 */
	InitWindows();

	// Run it
	switch (Fetcher.Run())
	{
	case (pkgAcquire::Failed):
	case (pkgAcquire::Cancelled):
		Lock.Close();
		ack_errors();
		NoCacheInit = true;
		return;

	case (pkgAcquire::Continue):
		break;
	}

	// Clean out any old list files
	if (Fetcher.Clean(_config->FindDir("Dir::State::lists")) == false || Fetcher.Clean(_config->FindDir("Dir::State::lists") + "partial/") == false)
	{
		Error("Cleaning out lists directories FAILED. Please check your permissions.");
		return;
	}
}

void pkgAcquireInterface::AcquireUpgrade()
{
	// Do the upgrade

	if (pkgAllUpgrade(*Cache) == false)
	{
		// Bad things happened with the upgrade, tell the
		// user about it and then return to the coreui.
		capt_show_broken(*Cache);
		return;
	}

	AcquireRun();		// Complete the stuff
}

void pkgAcquireInterface::AcquireRun()
{
	// Make sure we've not been called in vain ..

	if (Cache->InstCount() == 0 && Cache->DelCount() == 0)
	{
		NoCacheInit = true;
		return;
	}
	if (Cache->BrokenCount() != 0)
	{
		NoCacheInit = true;
		capt_show_broken(*Cache);
		return;
	}

	// Lock the archive directory
	FileFd Lock;
	if (_config->FindB("Debug::NoLocking", false) == false)
		Lock.Fd(GetLock(_config->FindDir("Dir::Cache::Archives") + "lock"));
	if (_error->PendingError() == true)
		_error->Discard();

	if (_error->PendingError() == true)
	{
		string s;
		_error->PopMessage(s);
		Error("%s", s.c_str());
		NoCacheInit = true;
		return;
	}

	// Create the download object
	AcquireStatus Stat(this);
	pkgRealAcquire Fetcher(&Stat, this);
	pFetcher = &Fetcher;
	pStat = &Stat;

	// Read the source list
	pkgSourceList List;
	if (List.ReadMainList() == false)
	{
		Error("The list of sources could not be read.");
		return;
	}

	// Create the package manager and prepare to download
	pkgDPkgPM PM(*Cache);
	if (PM.GetArchives(&Fetcher, &List, Recs) == false || _error->PendingError() == true)
	{
		Error(" Error creating package manager !! ");
		return;
	}

	unsigned long FetchBytes = Fetcher.FetchNeeded();
	unsigned long FetchPBytes = Fetcher.PartialPresent();
	unsigned long DebBytes = Fetcher.TotalNeeded();

	// Only boot up the interface if there is something to download
	if (FetchBytes > 0)
	{
		if (DebBytes != Cache->DebSize())
		{
			Error("\n-> %d, %d <- \nHow odd.. The sizes didn't match, email apt@packages.debian.org\n", DebBytes, Cache->DebSize());
			return;
		}

		// Check for enough free space
		struct statfs statbuf;
		string OutputDir = _config->FindDir("Dir::Cache::Archives");

		if (statfs(OutputDir.c_str(), &statbuf) != 0)
			PrintOutputF("Couldn't determine free space in %s\n", OutputDir.c_str());

		if (unsigned (statbuf.f_bfree) < (FetchBytes - FetchPBytes) / statbuf.f_bsize)
		{
			Error("Sorry, you don't have enough free space in %s", OutputDir.c_str());
			return;
		}

		/*
		 * At this point we are ready do deal with the interface
		 */
		InitWindows();

		// Tell them what we want
		if (DebBytes != FetchBytes)
			PrintOutputF("%sB of %sB needs to be downloaded.\n", SizeToStr(FetchBytes).c_str(), SizeToStr(DebBytes).c_str());
		else
			PrintOutputF("%sB needs to be downloaded.\n", SizeToStr(DebBytes).c_str());

		// Size delta
		if (Cache->UsrSize() >= 0)
			PrintOutputF("Afterwards, %sB will be used.\n", SizeToStr(Cache->UsrSize()).c_str());
		else
			PrintOutputF("Afterwards, %sB will be freed.\n", SizeToStr(-1 * Cache->UsrSize()).c_str());

		if (_error->PendingError() == true)
		{
			Error("An unknown error occurred. Buggah.");
			return;
		}

		output->Refresh();

		// Run it
		switch (Fetcher.Run())
		{
		case (pkgAcquire::Failed):
		case (pkgAcquire::Cancelled):
			Lock.Close();
			ack_errors();
			NoCacheInit = true;
			return;

		case (pkgAcquire::Continue):
			break;
		}

		// Print out errors
		bool Failed = false;
		bool Transient = false;

		string errors = "\nThe following files did not download correctly:\n\n";

		for (pkgAcquire::Item ** I = Fetcher.ItemsBegin(); I != Fetcher.ItemsEnd(); I++)
		{
			if ((*I)->Status == pkgAcquire::Item::StatDone && (*I)->Complete == true)
				continue;

			if ((*I)->Status == pkgAcquire::Item::StatIdle)
			{
				Transient = true;
				continue;
			}

			errors += "  * " + (*I)->DescURI() + " (" + (*I)->ErrorText + ")\n";

			Failed = true;
		}

		if (Failed == true)
			cerr << errors;
	}
	else
	{
		clear();
		refresh();
		endwin();
	}

	// Try to deal with missing package files
	if (PM.FixMissing() == false)
	{
		Error("I was unable to correct the missing package files.");
		return;
	}

	// Unlock before installing packages
	CacheFile->ReleaseLock();

	// Run dpkg
	pkgPackageManager::OrderResult Res = PM.DoInstall();

	if (Res == pkgPackageManager::Failed || _error->PendingError() == true)
	{
		string s, q;
		while (_error->PendingError() == true)
		{
			_error->PopMessage(q);
			s += "  * ";
			s += q;
			s += "\n";
		}
		cerr << "\nPackage manager (dpkg) failed: \n\n" << s;

	}
	else if (Res == pkgPackageManager::Completed)
	{
		printf("\nPackage manager (dpkg) succeeded.\n");
	}

	if (MasterType == UI)
		Keywait();

	return;
}

void pkgAcquireInterface::InitWindows(void)
{
	curs_set(0);
	clear();
	refresh();

	CalibrateWindows();

	output = new UniqueWindow(output_len_y, output_len_x, output_pos_y, output_pos_x);
	output->scrollable(true);
	output->ChangeTitle("fetcher backlog");
	output->Erase();
	output->Refresh();

	itemized = new UniqueWindow(itemized_len_y, itemized_len_x, itemized_pos_y, itemized_pos_x);
	itemized->scrollable(false);
	itemized->ChangeTitle("file progress");
	itemized->Erase();
	itemized->Refresh();

	total = new UniqueWindow(total_len_y, total_len_x, total_pos_y, total_pos_x);
	total->scrollable(false);
	total->ChangeTitle("batch progress");
	total->Erase();
	total->Refresh();

	if (strcmp(get_config_string("captris"), "1") == 0)
		StartCaptris();

	WindowsActive = true;

	PrintOutputF("$3#To toggle playing the captris game, press the 't' key.$! \n");
}

void pkgAcquireInterface::CalibrateWindows()
{
	extra_len_y = 16;
	extra_len_x = 37;
	extra_pos_y = LINES - extra_len_y;
	extra_pos_x = 0;

	output_len_y = LINES - extra_len_y - 1;
	output_len_x = COLS;
	output_pos_y = 0;
	output_pos_x = 0;

	if (strcmp(get_config_string("captris"), "1") == 0)
	{
		total_len_y = 5;
		total_len_x = COLS - extra_len_x - 2;
		total_pos_y = LINES - total_len_y;
		total_pos_x = extra_len_x + 2;

		itemized_len_y = LINES - output_len_y - total_len_y - 2;
		itemized_len_x = COLS - extra_len_x - 2;
		itemized_pos_y = extra_pos_y;
		itemized_pos_x = extra_len_x + 2;
	}
	else
	{
		total_len_y = 5;
		total_len_x = COLS;
		total_pos_y = LINES - total_len_y;
		total_pos_x = 0;

		itemized_len_y = LINES - output_len_y - total_len_y - 2;
		itemized_len_x = COLS;
		itemized_pos_y = extra_pos_y;
		itemized_pos_x = 0;
	}

}

void pkgAcquireInterface::StartCaptris()
{
	if (WindowsActive == true)
	{
		set_config_string("captris", "1");

		CalibrateWindows();

		delete itemized;
		itemized = new UniqueWindow(itemized_len_y, itemized_len_x, itemized_pos_y, itemized_pos_x);
		itemized->scrollable(false);
		itemized->ChangeTitle("file progress");
		itemized->Erase();
		itemized->Refresh();

		delete total;
		total = new UniqueWindow(total_len_y, total_len_x, total_pos_y, total_pos_x);
		total->scrollable(false);
		total->ChangeTitle("batch progress");
		total->Erase();
	}

	extra = new UniqueWindow(extra_len_y, extra_len_x, extra_pos_y, extra_pos_x);

	extra->scrollable(false);
	extra->ChangeTitle("entertainment");
	extra->Erase();
	keypad(extra->body(), true);

	if (Game == NULL)
	{
		Game = new Captris(this);
		Game->initiate();
	}

	clear();
	refresh();
	output->Redraw();
	extra->Redraw();
	total->Redraw();
	itemized->Redraw();
}

void pkgAcquireInterface::StopCaptris()
{
	set_config_string("captris", "0");

	CalibrateWindows();

	delete itemized;
	itemized = new UniqueWindow(itemized_len_y, itemized_len_x, itemized_pos_y, itemized_pos_x);
	itemized->scrollable(false);
	itemized->ChangeTitle("file progress");
	itemized->Erase();

	delete total;
	total = new UniqueWindow(total_len_y, total_len_x, total_pos_y, total_pos_x);
	total->scrollable(false);
	total->ChangeTitle("batch progress");
	total->Erase();

	delete extra;
	extra = NULL;

	clear();
	refresh();
	output->Redraw();
	total->Redraw();
	itemized->Redraw();
}

void pkgAcquireInterface::ViewInstall()
{
	int pkgcount = 0, headcount = 0, prevheadcount = 0;
	string tmp = "  ";

	for (pkgCache::PkgIterator I = Cache->PkgBegin(); I.end() == false; I++)
	{
		if ((*Cache)[I].Install() == true)
		{
			if ((tmp.length() + strlen(I.Name()) - headcount) >= unsigned (COLS - 16))
			{
				tmp += " \n  ";
				prevheadcount++;
				headcount = prevheadcount;
			}
			tmp += I.Name();
			tmp += " ";

			prevheadcount += strlen(I.Name()) + 1;
			pkgcount++;
		}
	}

	if (pkgcount > 0)
		ui_dialog(DLGPAIR, "Install", (char *) tmp.c_str());

}

void pkgAcquireInterface::ViewRemove()
{
	int pkgcount = 0, headcount = 0, prevheadcount = 0;
	string tmp = "  ";

	for (pkgCache::PkgIterator I = Cache->PkgBegin(); I.end() == false; I++)
	{
		if ((*Cache)[I].Delete() == true)
		{
			if ((tmp.length() + strlen(I.Name()) - headcount) >= unsigned (COLS - 16))
			{
				tmp += " \n  ";
				prevheadcount++;
				headcount = prevheadcount;
			}
			tmp += I.Name();
			tmp += " ";

			prevheadcount += strlen(I.Name()) + 1;
			pkgcount++;
		}
	}

	if (pkgcount > 0)
		ui_dialog(DLGPAIR, "Delete", (char *) tmp.c_str());

}

void pkgAcquireInterface::DestroyWindows(void)
{
	delete output;
	delete extra;
	delete itemized;
	delete total;

	clear();
	refresh();

	WindowsActive = false;
}

void pkgAcquireInterface::Error(char *fmt, ...)
{
	va_list va;
	char buf[512];

	va_start(va, fmt);
	vsnprintf(buf, 511, fmt, va);
	va_end(va);

	clear();
	refresh();
	ui_dialog(DLGPAIR, "fatal error", "\n %s \n", buf);

	NoCacheInit = true;
}

void pkgAcquireInterface::ack_errors()
{
	string s, q;

	if (_error->PendingError() == true)
	{
		while (_error->PendingError() == true)
		{
			_error->PopMessage(q);
			s += " * ";
			s += q;
			s += "\n";
		}
		ui_dialog(DLGPAIR, "Acquisition Errors", "\n%s\n", s.c_str());
	}
}

void pkgAcquireInterface::PrintOutputF(char *fmt, ...)
{
	va_list va;
	char buf[200];

	va_start(va, fmt);

	vsnprintf(buf, 200, fmt, va);

	ColorMVPrintW(output->body(), output->body()->_cury, output->body()->_curx, COLOR_BLUE, 0, "%s", buf);

	va_end(va);
}

void pkgAcquireInterface::Keywait(void)
{
	printf("\nPress enter to continue ...");
	fflush(stdout);

	char C;

	while (1)
	{
		read(STDIN_FILENO, &C, 1);
		if (C == '\n')
			break;
	}

}

void pkgAcquireInterface::CleanUp(void)
{
	DestroyWindows();

	ui_initwindows();
	ui_redraw_current();
}

// Acquire::SetFds - Deal with readable FDs
// ---------------------------------------------------------------------
void pkgRealAcquire::SetFds(int &Fd, fd_set * RSet, fd_set * WSet)
{
	pkgAcquire::SetFds(Fd, RSet, WSet);

	FD_SET(STDIN_FILENO, RSet);

}

// Acquire::RunFds - Deal with active FDs
// ---------------------------------------------------------------------
void pkgRealAcquire::RunFds(fd_set * RSet, fd_set * WSet)
{
	pkgAcquire::RunFds(RSet, WSet);

	if (FD_ISSET(STDIN_FILENO, RSet))
	{
		int ch = wgetch(Fetcher->output->body());

		if (ch == 'r')
			Fetcher->ViewRemove();
		else if (ch == 'i')
			Fetcher->ViewInstall();
		else if (ch == 'q')
			Fetcher->pStat->Abort();
		else if (ch == 't')
		{
			if (Fetcher->extra == NULL)
				Fetcher->StartCaptris();
			else
				Fetcher->StopCaptris();
		}
		else if (Fetcher->extra != NULL)
			Fetcher->Game->handlekey(ch);
	}
}
