// vs_progress.cc
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A vscreen_widget that also acts as a progress bar.

#include "vs_progress.h"

void vs_progress::display()
{
  int width,height;
  get_owner()->getmaxyx(height,width);
  int barsize;
  char percent_string[50];

  if(!Op.empty())
    {
      assert(Percent>=0 && Percent<=100);
      barsize=int(Percent*width/100.0);

      snprintf(percent_string, 50, ": %i%%", int(Percent));

      get_owner()->show_string_as_progbar(0,
					  height-1,
					  Op+percent_string,
					  COLOR_PAIR(get_color("pkgtree_progress", COLOR_BLUE, COLOR_YELLOW)),
					  COLOR_PAIR(vs_tree::get_status_color())|A_BOLD,
					  barsize,
					  width);
    }
  else
    get_owner()->display_status("", COLOR_PAIR(vs_tree::get_status_color())|A_BOLD);
}

void vs_progress::Update()
{
  get_tree()->show_status();
  get_owner()->refresh();
}

void vs_progress::Done()
{
  get_tree()->show_status();
  get_owner()->refresh();
}
