// pkg_subtree.h (this is -*-c++-*-)
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A subtree which contains packages (and can be contained in itself)

#ifndef PKG_SUBTREE_H
#define PKG_SUBTREE_H

#include "pkg_node.h"
#include "vs_subtree.h"

class pkg_subtree:public vs_subtree<pkg_tree_node, tag_sort_policy>, public pkg_tree_node
{
  string label;
protected:
  void set_label(const char *_label) {label=_label;}
public:
  pkg_subtree(const char *_label, bool _expanded=false):
    vs_subtree<pkg_tree_node, tag_sort_policy>(_expanded),label(_label) {}

  virtual void display(vs_tree *win, int y);
  virtual const char *tag() const;

  virtual void sort();

  virtual void select() {}
  virtual void hold() {}
  virtual void remove() {}
  virtual void purge() {}

  string get_label() {return label;}

  bool dispatch_char(chtype ch);
};

#endif
