// pkg_item.h
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A tree item which represents a package.

#ifndef PKG_ITEM_H
#define PKG_ITEM_H

#include "pkg_node.h"

#include <apt-pkg/pkgcache.h>

class pkg_item:public pkg_tree_node
{
  pkgCache::PkgIterator package;
protected:
  pkgCache::PkgIterator get_package() {return package;}

public:
  pkg_item(pkgCache::PkgIterator _package):package(_package) {}

  virtual void display(vs_tree *win, int y);

  virtual const char *tag() const {return package.Name();}
  virtual bool matches(string s);

  virtual void select();
  virtual void hold();
  virtual void remove();
  virtual void purge();

  virtual void highlighted(vs_tree *win);

  virtual int get_normal_attr();

  bool dispatch_char(chtype ch);
};

#endif
