#include <ctype.h>
#include "adstring.h"
#include "string.h"
#include <stdio.h>
#include <stdlib.h>
#include "regex.h"
#include <stdlib.h>
#include <strstream.h>
#include <iomanip.h>
#include <list.h>
#include <algo.h>

// ************* String.h replacement code:
int min(int i, int j){return i<j ? i : j;}

Regex::Regex(const char *s){
  patt=(struct re_pattern_buffer*)
    malloc(sizeof(struct re_pattern_buffer));
  patt->translate=0;
  patt->fastmap=0;
  patt->buffer=0;
  patt->allocated=0;
  re_compile_pattern(s,strlen(s),patt);
}

String::String(){
}

String::String(const String& s){
  buf=s.buf;
}
String::String(char c){
  buf.push_back(c);
}
String::String(const char *s){
  while(*s){
    buf.push_back(*s);
    s++;
  }  
}
unsigned int String::length() const{
  return buf.size();
}

const char* String::chrstr() const{
  //This assumes vector doesn't free the memory for the last element.
  //I believe (but am not sure) that this is true.

  ((vector<char> &)buf).push_back('\0');
  ((vector<char> &)buf).pop_back();
  return &(buf[0]);
}

String String::at(int pos, int len) const{
  String s;
  while(len && pos<(int)buf.size()){
    s+=buf[pos];
    pos++;
    len--;
  }
  return s;
}
String String::after(int i) const{
  String s;

  i++;
  if(i>=0 && i<= (int)buf.size()){
    while(i < (int)(buf.size())){
      s+=buf[i];
      i++;
    }
    return s;
  } else
    return "";  
}

String String::after(char *s, int startpos=0) const{
  int i;

  if(strlen(s)){
    i=index(s,startpos);
    if(i!=-1)
      return after(i+strlen(s)-1);
    else
      return "";
  } else
    return after(startpos);
  
}
String String::before(int i) const{
  int j;
  String s;

  if(i>=0 && i<= (int)buf.size()){
    for(j=0;j<i;j++)
      s+=buf[j];
    return s;
  } else 
    return "";
}
String String::before(char *s, int startpos=0) const{
  return before(index(s,startpos));
}
String String::before(char c, int startpos=0) const{
  return before(index(c,startpos));
}

int String::index(char c, int startpos=0) const{
  const char* i;

  i=find(buf.begin()+startpos, buf.end(), c);
  if(i!=buf.end())
    return i - buf.begin();
  else
    return -1;
}
int String::index(const char *s, int startpos=0) const{
  String t(s);
  const char *i;

  i=search(buf.begin()+startpos, buf.end(), &t[0], &t[t.length()]);
  if(i!=buf.end())
    return  i - buf.begin();
  else
    return -1;
}
int String::index(const String &s, int startpos=0) const{
  const char *i;

  i=search(buf.begin()+startpos, buf.end(), &s[0], &s[s.length()]);
  if(i!=buf.end())
    return  i - buf.begin();
  else
    return -1;
}
bool String::contains(const String &s, int startpos=-1) const{
  if(startpos==-1){
    return index(s)>=0;
  } else {
    if(s.length() > length()-startpos)
      return 0;
    else
      return !strncmp(&s.buf[0], &buf[startpos], s.length());
  }
}
bool String::contains(const char *s, int startpos=-1) const{
  if(startpos==-1){
    return index(s)>=0;
  }else{
    if(strlen(s) > length()-startpos)
      return 0;
    else
      return !strncmp(s, &buf[startpos], strlen(s));
  }
}
bool String::contains(const Regex& r, int startpos=0) const{
  return re_match(r.pattern(), buf.begin(), length(), startpos, 0) 
    > 0;
}
bool String::contains(char c, int startpos=-1) const{
  if(startpos==-1)
    return find(buf.begin(), buf.end(), c) != buf.end();
  else
    return buf[startpos]==c;
}
void String::del(int pos, int len){
  if(pos>=0 && len>0 && pos+len <= (int)buf.size())
    buf.erase(buf.begin()+pos, buf.begin()+pos+len);
}
String& String::operator+=(char c){
  buf.push_back(c);
  return *this;
}
String& String::operator+=(const String &s){
  int i;
  for(i=0; i<(int)s.length(); i++)
    buf.push_back(s[i]);
  return *this;
}
String& String::operator+=(const char *s){
  while(*s){
    buf.push_back(*s);
    s++;
  }
}
const char& String::operator[](int i)const{
  return buf[i];
}
char& String::operator[](int i){
  return (char&)buf[i];
}
String::operator const char*() const{
  //This assumes vector doesn't free the memory for the last element.
  //I believe (but am not sure) that this is true.

  ((vector<char> &)buf).push_back('\0');
  ((vector<char> &)buf).pop_back();
  return &buf[0];
}

String operator +(const String &x, const String &y){
  String s;
  unsigned int i;

  for(i=0; i<x.length(); i++)
    s+=x[i];
  for(i=0; i<y.length(); i++)
    s+=y[i];
  return s;
}

bool operator == (const String &x, const String &y){
  if(x.length() != y.length())
    return 0;
  else
    return !strncmp(&x.buf[0], &y.buf[0], x.length());
}
bool operator != (const String &x, const String &y){
  return !(x==y);
}
bool operator <  (const String &x, const String &y){
  int r;
  r=strncmp(&x.buf[0], &y.buf[0], min(x.length(),y.length()));
  if(r)
    return r<0;
  else
    return x.length() < y.length();
}
bool operator >  (const String &x, const String &y){
  int r;
  r=strncmp(&x.buf[0], &y.buf[0], min(x.length(),y.length()));
  if(r)
    return r>0;
  else
    return x.length() > y.length();
}
bool operator <= (const String &x, const String &y){
  return ! (x>y);
}
bool operator >= (const String &x, const String &y){
  return !(x<y);
}


ostream &operator<<(ostream &o, const String &s){
  for(int i=0;i<(int)s.length(); i++){
    o<<s[i];
  }
  return o;
}
String upcase(const String &x){
  String s;
  for(int i=0;i< (int)x.length(); i++)
    s+=toupper(x[i]);
  return s;
}
int readline(istream& s, String& x, 
	     char terminator = '\n'){
  char buf[MAX_LINE*2];
  bool ret;

  ret=s.get(buf,sizeof(buf), terminator);
  x=String(buf);
  s.get(terminator);
  return ret;
}

// ************* "own" string handling code:



parseerror::parseerror(parsestream *p){
  lineno=p->lineno;
  buffer=p->buffer;
  pos=p->pos;
  fname=p->fname;
}
void parseerror::report(ostream &o){
  int i;
  o<<"In file \""<<filename()<<"\" at line "<<linenumber()<<":"<<endl;
  o<<buffer<<endl;
  for(i=1;i<pos;i++)
    o<<" ";
  o<<"^"<<endl
   <<errormsg()<<endl;
}
void parsestream::preprocess(String &s){
  //disregards lines that start with a #
  //set filename if line starts with "!F"

  if(!s.length())
    return;

  switch(s[0]){
  case '#':
    s=""; 
    return;
  case '!':
    if(s.length()>1){
	switch(s[1]){
	case 'F': 
	  set_linenumber(0);
	  set_filename(s.after(2));
	  //cerr<<"filename="<<filename()<<", s.after="<<s.after(2)<<endl;
	  s="";
	  return;
	default:
	  if(s.contains("!include ",0)){
	    String t(s.after("!include "));
	    if((t[0]=='/')||(fname.size()==0)||(filename()[0]!='/'))
	      new_file(t);
	    else
	      new_file(String_parent(filename()) + "/" + t);
	  }
	  s="";
	  return;
	}
    }
    return;
  default:;
  }
}
void parsestream::close_file(){
  //should delete i.back(), but only if !=stdin!
  
  int nu=i.size()-1;
  if(nu || !stdin_file)
    delete i[nu];
  i[nu]=NULL;
  if(i.size()>1){
    i.pop_back();
    lineno.pop_back();
    fname.pop_back();
  } else {
    throw endoffile(this);
  }
}
void parsestream::new_file(const String &s){
  ifstream *f=new ifstream(s);
  pos=0;
  i.push_back(f); 
  lineno.push_back(0);
  fname.push_back(s);
  if(!in_constructor){
    if(!*f||!f->good())
      throw ferror_open(this);
  }
  //??? 
}
void parsestream::new_line(){
  while(i.size()){
    if(!current_istr()||current_istr()->eof()){
      close_file();
      continue;
    }
    buffer="";
    pos=0;
    while(current_istr()->good()&&
	  !(current_istr()->eof())&&
	  !buffer.length()){
      readline(*current_istr(),buffer);
      set_linenumber(linenumber()+1);
      preprocess(buffer);
      buffer=rmtrailingspace(buffer);
    }
    while(current_istr()->good()&&
	  !(current_istr()->eof())&&
	  (buffer[buffer.length()-1]=='\\')){
      String s;
      readline(*current_istr(),s);
      set_linenumber(linenumber()+1);
      buffer=buffer.at(0,buffer.length()-1)+" "+rmtrailingspace(s);
    }
    if(!buffer.length()){
      close_file();
      continue;
    }
    if(current_istr()->eof()&&
       buffer.length()&&
       (buffer[buffer.length()-1]=='\\')){
      //a "\" at the end of a file: unconditional error (don't unwind etc).
      throw endoffile(this);
    }
    return;
  }
  if(in_constructor){
    return;
  } else
    throw endoffile(this);
}

char parsestream::get_char(){
  if(!buffer.length())
    throw endoffile(this);
  if(pos>=(int)buffer.length())
    throw endofline(this);
  
  return buffer[pos++];
}

char parsestream::put_back(char c){
  if (c){
    if(pos){
      pos--;
      // buffer.at(pos,1)=String(c);
      buffer[pos]=c;
    } else
      buffer=String(c)+buffer;
    
  }
  return c;
}

String parsestream::get_line(){
  String s;
  s=buffer.after(pos-1);
  if(s=="")
    throw endofline(this);
  buffer="";
  try{
    skip_line();
  }
  catch(endoffile){};
  return s;
}

String parsestream::get_name(){
  char c;
  String s;
  skip_space();
  try{
    while((c=get_char())&&
	  (isalnum(c)||(c=='_')||(c=='-')||(c=='+')||(c=='.')))
      s+=c;
    if(c)
      put_back(c);
  } catch(endofline d){};
  return s;
}

String parsestream::get_name(const Regex &r){
  char c;
  String s;
  skip_space();
  try{
    while((c=get_char())&&(String(c).contains(r)))
      s+=c;
    if(c)
      put_back(c);
  } catch(endofline){};
  return s;
}


String parsestream::get_Stringconst(){
  char c;
  String s;
  skip_space();
  c=get_char();
  try{
    if(c=='\"'){
      while((c=get_char())&&(c!='\"')){
	if(c=='\\'){
	  c=get_char();
	  switch(c){
	  case 't': c='\t'; break;
	  case 'b': c='\b'; break;
	  case 'n': c='\n'; break;
	  default:; break;
	  }
	}
	s+=c;
      }
      if(c!='\"')
	throw char_expected(this, '\"');
    } else{ //no " at begining
      s=c;
      while((c=get_char())&&!isspace(c))
	s+=c;
    }
  }catch(endofline p){};
  return s;
}

String parsestream::get_eq_name(){
  char c;
  skip_space();
  c=get_char();
  if(c!='=')
    throw char_expected(this, '=');
  return get_name();
}
String parsestream::get_eq_Stringconst(){
  char c;
  skip_space();
  c=get_char();
  if(c!='=')
    throw char_expected(this, '=');    
  return get_Stringconst();
}
void parsestream::skip_line(){
  buffer="";
  try{
    new_line();
  }
  catch(endoffile d){};
}
void parsestream::skip_space(){
  char c;
  while(isspace(c=get_char()));  
  if(c)
    put_back(c);
}
void parsestream::skip_char(char expect){
  char c=get_char();
  if(c!=expect){
    put_back(c);
    throw char_expected(this, expect);
  }
}


String rmtrailingspace(String &s){
  while(s.length()&&(isspace(s[s.length()-1])))
    s.del((int)s.length()-1,1);
  return s;
}



String escape_doublequotes(const String &s){
  String t;
  unsigned int i;
  for(i=0;i!=s.length();i++){
    if(s[i]=='\"')
      t+='\\';
    t+=s[i];
  }
  return t;
}

String escapewith_String(const String &s, const String &esc,
			 const String &with){
  // call with: escape_String("hello $world, %dir", "$%", "\\")
  // returns:   "hello \$world, \%dir"
  String t;
  unsigned int i;
  for(i=0;i!=s.length();i++){
    if(esc.contains(s[i]))
      t+=with;
    t+=s[i];
  }
  return t;
}

String escape_String(const String &s, const String &esc){
  // call with: escape_String("hello $world, %dir", "$%")
  // returns:   "hello \$world, \%dir"
  return escapewith_String(s,esc,"\\");
}
String cppesc_String(const String &s){
  String t;
  unsigned int i;
  for(i=0;i!=s.length();i++){
    if(!(isalnum(s[i])||(s[i]=='_')))
      t+=String('$')+itohexString(int(s[i]));
    else
      t+=s[i];
  }
  return t;
}
String tolower_String(const String &s){
  String t;
  for(unsigned int i=0; i<s.length(); i++)
    t+=tolower(s[i]);
  return t;
}
String toupper_String(const String &s){
  String t;
  for(unsigned int i=0; i<s.length(); i++)
    t+=toupper(s[i]);
  return t;
}
String replacewith_String(const String &s, const String &replace,
			  const String &with){
  // call with: replacewith_String("hello $world, %dir", "$% ", "123")
  // returns:   "hello31world,32dir"
  String t;
  unsigned int i;
  int j;
  for(i=0;i!=s.length();i++){
    if((j=replace.index(s[i]))>=0)
      t+=with[j % with.length()];
    else
      t+=s[i];
  }
  return t;
}

String replace(String s,char match, char replace){
  unsigned int i;
  for(i=0;i!=s.length();i++)
    if(s[i]==match)
      s[i]=replace;
  return s;
}
String sort_hotkey(String s){
  String t;
  unsigned i;
  
  t=s[0];
  s[0]='\0';
  for(i=1;i!=s.length();i++)
    if((isspace(s[i-1])||ispunct(s[i-1]))&&isupper(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=s.length();i++)
    if((isspace(s[i-1])||ispunct(s[i-1]))&&isalnum(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=s.length();i++)
    if(isupper(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=s.length();i++)
    if(isalpha(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=s.length();i++)
    if(isalnum(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=s.length();i++)
    if(s[i]){
      t+=s[i];
      s[i]='\0';
    }
  return t;
}

int Stringtoi(const String &s){
  return atoi(s);
}

String itoString(int i){
  char s[MAX_LINE];
  ostrstream str(s,sizeof(s));
  str<<i<<ends;
  return s;
}

String itohexString(int i){
  char s[MAX_LINE];
  ostrstream str(s,sizeof(s));
  str<<setbase(16)<<i<<ends;
  return s;
}


String String_parent(String s){
  // String_parent("/Debian/Apps/Editors/Emacs") = "/Debian/Apps/Editors
  int  i,p;
  
  for(i=0,p=-1;(unsigned int)i!=s.length();i++)
    if(s[i]=='/')
      p=i;
  if(p<0)
    return "";
  else
    return s.at(0,p);
}

