/*--------------------------------*-C-*---------------------------------*
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as you don't
 * try to make money out of it and you include an unaltered copy of this
 * message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * (nation@rocket.sanders.lockheed.com).
 * No additional restrictions are applied
 *
 * Additional modifications by mj olesen <olesen@me.queensu.ca>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#include "rxvt.h"

#include <X11/Xlib.h>

#include "xsetup.h"
#include "screen.h"

/*----------------------------------------------------------------------*
 * local variables
 */
#ifdef SCROLLBAR_NONE
void sbar_init (XGCValues *gcv) {}
#else	/* SCROLLBAR_NONE */

#define stipple_width 12
#define stipple_height 2
static char stipple_bits[] = {
   0xaa, 0x02, 0x54, 0x01};

/* check XBM matches header define */
#if (SBAR_WIDTH != stipple_width)
Error, check values
#endif

#ifndef SCROLLBAR_NOARROWS
#define up_width 12
#define up_height 12
static char up_bits[] = {
   0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x70, 0x00, 0x70, 0x00, 0xf8, 0x00,
   0xf8, 0x00, 0xfc, 0x01, 0xfc, 0x01, 0xfe, 0x03, 0xfe, 0x03, 0x00, 0x00};

#define dn_width 12
#define dn_height 12
static char dn_bits[] = {
   0x00, 0x00, 0xfe, 0x03, 0xfe, 0x03, 0xfc, 0x01, 0xfc, 0x01, 0xf8, 0x00,
   0xf8, 0x00, 0x70, 0x00, 0x70, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00};

/* check XBM matches header define */
#if (SBAR_WIDTH != up_width) || (up_width != up_height)\
||  (SBAR_WIDTH != dn_width) || (dn_width != dn_height)
Error, check values
#endif

#endif	/* ! NOARROWS */
/*----------------------------------------------------------------------*/

/* Initialise scrollbar data structures - called just once,
 * gcv already contains foreground, background, font
 */
void
sbar_init (XGCValues *gcv)
{
   gcv->fill_style = FillOpaqueStippled;

#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_IGNORE) return;
#endif

#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_ARROWS)
#endif
     {
#ifndef SCROLLBAR_NOARROWS
	gcv->stipple = XCreateBitmapFromData (Xdisplay, sbar.up.win,
					      up_bits,
					      up_width,
					      up_height);
	if (!gcv->stipple)
	  {
	     print_error ("Can't create up bitmap");
	     exit (EXIT_FAILURE);
	  }
	sbar.up.gc = XCreateGC (Xdisplay, RxvtWin.parent,
				GCForeground|GCBackground|GCFont|
				GCFillStyle|GCStipple,
				gcv);

	gcv->stipple = XCreateBitmapFromData (Xdisplay, sbar.dn.win,
					      dn_bits,
					      dn_width,
					      dn_height);
	if (!gcv->stipple)
	  {
	     print_error ("Can't create downarrow bitmap");
	     exit (EXIT_FAILURE);
	  }
	sbar.dn.gc = XCreateGC (Xdisplay, RxvtWin.parent,
				GCForeground|GCBackground|GCFont|
				GCFillStyle|GCStipple,
				gcv);
#endif	/* ! NOARROWS */
     }

   gcv->stipple = XCreateBitmapFromData (Xdisplay,
					 sbar.sb.win,
					 stipple_bits,
					 stipple_width,
					 stipple_height);
   if (!gcv->stipple)
     {
	print_error ("Can't create scrollbar bitmap");
	exit (EXIT_FAILURE);
     }
   sbar.sb.gc = XCreateGC (Xdisplay, RxvtWin.parent,
			   GCForeground|GCBackground|GCFont|
			   GCFillStyle|GCStipple,
			   gcv);
   sbar_show (100, 0, 100);
   sbar_down_reset ();
   sbar_up_reset ();
}

/* Redraw scrollbar to show area from
 * low to (low+high) proportional to len
 */
void
sbar_show (int len, int low, int high)
{
   static int olen, otop, obot;		/* old values */
   static int dlen, dtop, dbot;		/* drawn values */
   int y, top, bot;

#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_IGNORE) return;
#endif

   if (len > 0)
     {
	olen = len;
	otop = (len - (low + high));
	obot = (len - low);
     }

   if ((len >= 0) && (dlen == olen) && (dtop == otop) && (dbot == obot))
     return;

   dlen = olen;
   dtop = otop;
   dbot = obot;

   top = (sbar.h * dtop) / dlen - 1;
   bot = (sbar.h * dbot) / dlen;

   y = 0;
#ifndef SCROLLBAR_NOARROWS
#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_ARROWS)
#endif
     y = sbar.w;
#endif

   if (top > 0)
     XClearArea (Xdisplay, sbar.sb.win,
		 0, y, sbar.w, (top - 1), False);

   if (bot < sbar.h)
     XClearArea (Xdisplay, sbar.sb.win,
		 0, y + bot, sbar.w, (sbar.h - bot), False);

   if (bot > top)
     XFillRectangle (Xdisplay, sbar.sb.win, sbar.sb.gc,
		     0, (y + top), sbar.w, (bot - top));
}

/* Redraw the scrollbar's up arrow */
void
sbar_up_reset (void)
{
#ifndef SCROLLBAR_NOARROWS
#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_ARROWS)
#endif
     XFillRectangle (Xdisplay, sbar.up.win, sbar.up.gc, 0, 0, sbar.w, sbar.w);
#endif
}

/* Redraw the scrollbar's down arrow */
void
sbar_down_reset (void)
{
#ifndef SCROLLBAR_NOARROWS
#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_ARROWS)
#endif
     XFillRectangle (Xdisplay, sbar.dn.win, sbar.dn.gc, 0, 0, sbar.w, sbar.w);
#endif	/* ! NOARROWS */
}

#endif	/* SCROLLBAR_NONE */
/*----------------------- end-of-file (C source) -----------------------*/
