/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/

/* Form definition file generated with fdesign. */

#include <forms.h>
#include "config.h"
#include <stdlib.h>

#include "lyx.h"
#include "version.h"

FD_form_title *create_form_form_title(void)
{
  FL_OBJECT *obj;
  FD_form_title *fdui = (FD_form_title *) fl_calloc(1, sizeof(FD_form_title));

  fdui->form_title = fl_bgn_form(FL_NO_BOX, 300, 310);
  obj = fl_add_box(FL_UP_BOX,0,0,300,310,"");
    fl_set_object_color(obj,FL_DARKCYAN,FL_TOP_BCOL);
  obj = fl_add_frame(FL_ENGRAVED_FRAME,30,180,230,100,"");
  obj = fl_add_text(FL_NORMAL_TEXT,20,20,250,50,"LyX ");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE+FL_ENGRAVED_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,20,70,250,30,VERSION);
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE+FL_ENGRAVED_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,20,110,250,30,"(C) 1995 Matthias Ettrich,");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
  obj = fl_add_text(FL_NORMAL_TEXT,20,140,250,20,"1995, 1996 LyX Team.");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
  obj = fl_add_text(FL_NORMAL_TEXT,40,230,210,20,"There is  ABSOLUTELY NO WARRANTY.");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_SMALL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
  obj = fl_add_text(FL_NORMAL_TEXT,40,260,210,20,"See \"Help->Copying/Warrany\" for details.");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_SMALL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
  obj = fl_add_text(FL_NORMAL_TEXT,40,190,210,20,"This is free software and you are welcome");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_SMALL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
  obj = fl_add_text(FL_NORMAL_TEXT,40,210,210,20,"to redistribute it under certain conditions.");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_SMALL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
  fdui->timer_title = obj = fl_add_timer(FL_HIDDEN_TIMER,20,220,30,60,"");
    fl_set_object_callback(obj,TimerCB,0);
  obj = fl_add_button(FL_HIDDEN_RET_BUTTON,0,0,300,310, "");
    fl_set_object_callback(obj,TimerCB,0);
    fl_end_form();

  return fdui;
}


FD_form_figure *create_form_form_figure(void)
{
  FL_OBJECT *obj;
  FD_form_figure *fdui = (FD_form_figure *) fl_calloc(1, sizeof(FD_form_figure));

  fdui->form_figure = fl_bgn_form(FL_NO_BOX, 300, 240);
  obj = fl_add_box(FL_UP_BOX,0,0,300,240,"");
  obj = fl_add_text(FL_NORMAL_TEXT,20,20,90,50,"Figure");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);
  fdui->group_radio_fugre = fl_bgn_group();
  fdui->radio_postscript = obj = fl_add_checkbutton(FL_RADIO_BUTTON,20,80,260,30,"Encapsulated Poscript (*.eps, *.ps)");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->radio_inline = obj = fl_add_checkbutton(FL_RADIO_BUTTON,20,110,260,30,"Inlined EPS (*.eps, *.ps)");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->radio_latex = obj = fl_add_checkbutton(FL_RADIO_BUTTON,20,140,250,30,"LaTeX / TeX (*.tex, *.latex)");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fl_end_group();

  obj = fl_add_button(FL_NORMAL_BUTTON,20,190,80,30,"OK");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,FigureOKCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,110,190,80,30,"Apply");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,FigureApplyCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,200,190,80,30,"Cancel");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,FigureCancelCB,0);
  fl_end_form();
  return fdui;
}
/*---------------------------------------*/
FD_form_screen *create_form_form_screen(void)
{
  FL_OBJECT *obj;
  FD_form_screen *fdui = (FD_form_screen *) fl_calloc(1, sizeof(FD_form_screen));

  fdui->form_screen = fl_bgn_form(FL_NO_BOX, 420, 480);
  obj = fl_add_box(FL_UP_BOX,0,0,420,480,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,20,250,370,160,"");
  obj = fl_add_text(FL_NORMAL_TEXT,30,10,200,50,"Screen Options");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);
  fdui->input_roman = obj = fl_add_input(FL_NORMAL_INPUT,130,70,270,30,"Roman Font");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->input_sans = obj = fl_add_input(FL_NORMAL_INPUT,130,110,270,30,"Sans (Serif) Font");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->input_typewriter = obj = fl_add_input(FL_NORMAL_INPUT,130,150,270,30,"Typewriter Font");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->input_font_norm = obj = fl_add_input(FL_NORMAL_INPUT,130,190,270,30,"Font Norm");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_size = obj = fl_add_input(FL_INT_INPUT,350,20,50,30,"Normal Size");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_tiny = obj = fl_add_input(FL_INT_INPUT,80,280,50,30,"Tiny");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_small = obj = fl_add_input(FL_INT_INPUT,80,320,50,30,"Small");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_normal = obj = fl_add_input(FL_INT_INPUT,80,360,50,30,"Normal");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_large = obj = fl_add_input(FL_INT_INPUT,200,280,50,30,"Large");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_larger = obj = fl_add_input(FL_INT_INPUT,200,320,50,30,"Larger");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_largest = obj = fl_add_input(FL_INT_INPUT,200,360,50,30,"Largest");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_huge = obj = fl_add_input(FL_INT_INPUT,320,280,50,30,"Huge");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  fdui->intinput_giant = obj = fl_add_input(FL_INT_INPUT,320,320,50,30,"Giant");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  obj = fl_add_text(FL_NORMAL_TEXT,50,240,200,20,"Reference Sizes for Scaling");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
  obj = fl_add_button(FL_RETURN_BUTTON,20,430,120,30,"OK");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,ScreenOKCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,150,430,120,30,"Apply");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,ScreenApplyCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,280,430,120,30,"Cancel");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,ScreenCancelCB,0);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/
FD_form_toc *create_form_form_toc(void)
{
  FL_OBJECT *obj;
  FD_form_toc *fdui = (FD_form_toc *) fl_calloc(1, sizeof(FD_form_toc));

  fdui->form_toc = fl_bgn_form(FL_NO_BOX, 430, 380);
  obj = fl_add_box(FL_UP_BOX,0,0,430,380,"");
  obj = fl_add_text(FL_NORMAL_TEXT,20,20,210,40,"Table of Contents");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_resize(obj, FL_RESIZE_ALL);
    fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
  fdui->browser_toc = obj = fl_add_browser(FL_HOLD_BROWSER,20,70,390,260,"");
  fl_set_object_resize(obj, FL_RESIZE_ALL);
  fl_set_object_gravity(obj, NorthWestGravity, SouthEastGravity);
    fl_set_object_callback(obj,TocSelectCB,0);
  obj = fl_add_button(FL_RETURN_BUTTON,260,340,150,30,"Close");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_resize(obj, FL_RESIZE_ALL);
    fl_set_object_gravity(obj,SouthGravity, SouthGravity);
    fl_set_object_callback(obj,TocCancelCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,20,340,150,30,"Update");
    fl_set_button_shortcut(obj,"Uu#u",1);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_resize(obj, FL_RESIZE_ALL);
    fl_set_object_gravity(obj, SouthGravity, SouthGravity);
    fl_set_object_callback(obj,TocUpdateCB,0);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

FD_form_ref *create_form_form_ref(void)
{
  FL_OBJECT *obj;
  FD_form_ref *fdui = (FD_form_ref *) fl_calloc(1, sizeof(FD_form_ref));

  fdui->form_ref = fl_bgn_form(FL_NO_BOX, 410, 440);
  obj = fl_add_box(FL_UP_BOX,0,0,410,440,"");
  obj = fl_add_text(FL_NORMAL_TEXT,10,10,310,40,"Insert Cross-Reference");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_resize(obj, FL_RESIZE_ALL);
    fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
  fdui->browser_ref = obj = fl_add_browser(FL_HOLD_BROWSER,20,70,360,270,"");
    fl_set_browser_dblclick_callback(obj,RefSelectCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,20,390,120,30,"Update");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_resize(obj, FL_RESIZE_ALL);
    fl_set_object_gravity(obj, SouthWestGravity, SouthWestGravity);
    fl_set_object_callback(obj,RefUpdateCB,0);
  obj = fl_add_button(FL_HIDDEN_RET_BUTTON,0,0,0,0,0);
    fl_set_object_callback(obj,RefSelectCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,250,390,120,30,"Close");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_resize(obj, FL_RESIZE_ALL);
    fl_set_object_gravity(obj, SouthEastGravity, SouthEastGravity);
    fl_set_object_callback(obj,RefHideCB,0);
    fdui->radio_ref =obj = fl_add_checkbutton(FL_RADIO_BUTTON,90,350,90,30,"Ref");
    fdui->radio_pageref =obj = fl_add_checkbutton(FL_RADIO_BUTTON,200,350,90,30,"Page");
    fl_end_form();

  return fdui;
}
/*---------------------------------------*/

