/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: create.h,v 1.1 94/04/26 20:07:15 nau Exp $
 */

/* prototypes for create routines
 */

#ifndef	__CREATE_INCLUDED__
#define	__CREATE_INCLUDED__

#include "global.h"

/* ---------------------------------------------------------------------------
 * some useful macros
 */
/* ---------------------------------------------------------------------------
 * sort line coordinates and set direction
 */
#define	SETLINEDIRECTION(line,x1,y1,x2,y2)									\
	{																		\
		if ((x1) > (x2) || ((x1) == (x2) && (y1) > (y2)))								\
			{ (line)->X1 = (x2); (line)->Y1 = (y2); (line)->X2 = (x1); (line)->Y2 = (y1); }	\
		else																\
			{ (line)->X1 = (x1); (line)->Y1 = (y1); (line)->X2 = (x2); (line)->Y2 = (y2); }	\
																			\
			/* direction is used internaly to speed up drawings */			\
		if ((line)->Y2 > (line)->Y1)											\
			(line)->Direction = (line)->X1 == (line)->X2 ? 0 : 1;					\
		else																\
			(line)->Direction = (line)->Y1 == (line)->Y2 ? 2 : 3;					\
	}


PCBTypePtr		CreateNewPCB(void);
PinTypePtr		CreateNewVia(PCBTypePtr, Position, Position, Dimension, char *, BYTE);
LineTypePtr		AddLineToStack(LineTypePtr);
LineTypePtr		CreateNewLineOnLayer(PCBTypePtr, LayerTypePtr, Position, Position, Position, Position, Dimension, BYTE);
RectTypePtr		CreateNewRect(PCBTypePtr, LayerTypePtr, Position, Position, Dimension, Dimension, BYTE);
void			SetSurroundingTextRectangle(SymbolTypePtr, TextTypePtr);
void			AddStringToText(PCBTypePtr, TextTypePtr, char *);
TextTypePtr		CreateNewText(PCBTypePtr, LayerTypePtr, Position, Position, BYTE, char *, BYTE);
void			CreateNewElementData(ElementTypePtr, char *, char *, Position, Position, BYTE);
ElementTypePtr	CreateNewElement(PCBTypePtr, char *, char *, Position, Position, BYTE);
LineTypePtr		CreateNewLineInElement(ElementTypePtr, Position, Position, Position, Position, Dimension);
MarkTypePtr		CreateNewMarkInElement(ElementTypePtr, Position, Position);
ArcTypePtr		CreateNewArcInElement(ElementTypePtr, Position, Position, Dimension, Dimension, int, int, Dimension);
PinTypePtr		CreateNewPin(ElementTypePtr, Position, Position, Dimension, char *, BYTE);
ElementTypePtr	CopyElement(PCBTypePtr, ElementTypePtr, ElementTypePtr);
LineTypePtr		CreateNewLineInSymbol(SymbolTypePtr, Position, Position, Position, Position, Dimension);
void			CreateDefaultFont(void);

#endif
