/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include "_scm.h"



#ifndef floor
extern double floor();
#endif

#ifdef __STDC__
unsigned long
scm_hasher(SCM obj, unsigned long n, sizet d)
#else
unsigned long
scm_hasher(obj, n, d)
     SCM obj;
     unsigned long n;
     sizet d;
#endif
{
  switch (7 & (int) obj) {
  case 2: case 6:		/* INUMP(obj) */
    return INUM(obj) % n;
  case 4:
    if ICHRP(obj)
      return (unsigned)(scm_downcase[ICHR(obj)]) % n;
    switch ((int) obj) {
#ifndef SICP
    case (int) EOL: d = 256; break;
#endif
    case (int) BOOL_T: d = 257; break;
    case (int) BOOL_F: d = 258; break;
    case (int) EOF_VAL: d = 259; break;
    default: d = 263;		/* perhaps should be error */
    }
    return d % n;
  default: return 263 % n;	/* perhaps should be error */
  case 0:
    switch TYP7(obj) {
    default: return 263 % n;
    case tc7_smob:
      switch TYP16(obj) {
      case tcs_bignums:
      bighash: return INUM(scm_modulo(obj, MAKINUM(n)));
      default: return 263 % n;
#ifdef FLOATS
      case tc16_flo:
	if REALP(obj) {
	  double r = REALPART(obj);
	  if (floor(r)==r) {
	    obj = scm_inexact_to_exact (obj);
	    if IMP(obj) return INUM(obj) % n;
	    goto bighash;
	  }
	}
	obj = scm_number_to_string(obj, MAKINUM(10));
#endif
      }
    case tcs_symbols: case tc7_string:
      return scm_strhash(UCHARS(obj), (sizet) LENGTH(obj), n);
    case tc7_wvect:
    case tc7_vector:
      {
	sizet len = LENGTH(obj);
	SCM *data = VELTS(obj);
	if (len>5)
	  {
	    sizet i = d/2;
	    unsigned long h = 1;
	    while (i--) h = ((h<<8) + (scm_hasher(data[h % len], n, 2))) % n;
	    return h;
	  }
	else
	  {
	    sizet i = len;
	    unsigned long h = (n)-1;
	    while (i--) h = ((h<<8) + (scm_hasher(data[i], n, d/len))) % n;
	    return h;
	  }
      }
    case tcs_cons_imcar: case tcs_cons_nimcar:
      if (d) return (scm_hasher(CAR(obj), n, d/2)+scm_hasher(CDR(obj), n, d/2)) % n;
      else return 1;
    case tc7_port:
      return ((RDNG & CAR(obj)) ? 260 : 261) % n;
    case tcs_closures: case tc7_contin: case tcs_subrs:
      return 262 % n;
    }
  }
}


PROC (s_hash, "hash", 2, 0, 0, scm_hash);
#ifdef __STDC__
SCM
scm_hash(SCM obj, SCM n)
#else
SCM
scm_hash(obj, n)
     SCM obj;
     SCM n;
#endif
{
  ASSERT(INUMP(n) && 0 <= n, n, ARG2, s_hash);
  return MAKINUM(scm_hasher(obj, INUM(n), 10));
}

PROC (s_hashv, "hashv", 2, 0, 0, scm_hashv);
#ifdef __STDC__
SCM
scm_hashv(SCM obj, SCM n)
#else
SCM
scm_hashv(obj, n)
     SCM obj;
     SCM n;
#endif
{
  ASSERT(INUMP(n) && 0 <= n, n, ARG2, s_hashv);
  if ICHRP(obj) return MAKINUM((unsigned)(scm_downcase[ICHR(obj)]) % INUM(n));
  if (NIMP(obj) && NUMP(obj)) return MAKINUM(scm_hasher(obj, INUM(n), 10));
  else return MAKINUM(obj % INUM(n));
}

PROC (s_hashq, "hashq", 2, 0, 0, scm_hashq);
#ifdef __STDC__
SCM
scm_hashq(SCM obj, SCM n)
#else
SCM
scm_hashq(obj, n)
     SCM obj;
     SCM n;
#endif
{
  ASSERT(INUMP(n) && 0 <= n, n, ARG2, s_hashq);
  return MAKINUM((((unsigned) obj) >> 1) % INUM(n));
}


#ifdef __STDC__
void
scm_init_hash (void)
#else
void
scm_init_hash ()
#endif
{
#include "hash.x"
}

