#! /bin/sh

if [ $# != 2 ] ; then
  echo "Usage: $0 count input-file"
  exit 1
fi

COUNT=$1
INPUT_FILE=$2

ENCODED_FILE=/tmp/encoded.$$
CORRUPTED_FILE=/tmp/corrupt.$$
ERR_FILE=/tmp/errors.$$
FIXED_FILE=/tmp/fixed.$$
ECC_ERR_FILE=/tmp/eccerrs.$$

rm_files ()
{
  rm -f $ENCODED_FILE $CORRUPTED_FILE $ERR_FILE $FIXED_FILE $ECC_ERR_FILE
}

trap rm_files 3

../prog/ecc -e $INPUT_FILE $ENCODED_FILE
./noise $COUNT $ENCODED_FILE $CORRUPTED_FILE $ERR_FILE
../prog/ecc -d --verbose $CORRUPTED_FILE $FIXED_FILE 2> $ECC_ERR_FILE
sed -e 's+ecc: ++' $ECC_ERR_FILE > ${ECC_ERR_FILE}-t
mv ${ECC_ERR_FILE}-t $ECC_ERR_FILE    

diff $INPUT_FILE $FIXED_FILE > /dev/null 2>&1
status1=$?

diff $ERR_FILE $ECC_ERR_FILE > /dev/null 2>&1
status2=$?

rm_files

if [ $status1 -ne 0 -o $status2 -ne 0 ] ; then
  echo "../prog/ecc is not working.  Please send a bug-report (see README)."
  exit 1
else
  echo "test of ecc is successful."
  exit 0
fi
