/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static char rcsid[] = "$Id: xteld.c,v 1.9 1995/07/24 13:42:41 pierre Exp $";

/*
 * Demon XTELD (communication avec le MODEM)
 */

/* 	  
 * Contributions:
 *
 *   Michel Fingerhut	IRCAM Paris
 *		 
 *	- Traitement du fichier de log
 *	- Acces proteges aux services
 *
 *   Pierre Beyssac	SYSECA
 *
 *	- traitement du Minitel 2
 *	- utilisation de syslog
 */

#define EXTERN

#include <stdio.h>
#include "demon.h"
#include "globald.h"

#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <time.h>
#include <signal.h>
#include <string.h>
#ifdef USE_SYSLOG
#include <syslog.h>
#endif /* USE_SYSLOG */

#ifdef NO_TERMIO
#include <sgtty.h>
#else
#ifdef USE_TERMIOS
#include <sys/ioctl.h>
#include <termios.h>
#else
#include <termio.h>
#endif /* USE_TERMIOS */
#endif /* NO_TERMIO */

#ifdef NO_NETWORK
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>
#ifdef sun
#include <sys/termios.h>
#endif /* sun */

static int sock_service;

#define XTELD_INPUT	sock_service
#define XTELD_OUTPUT	sock_service

#else

#define XTELD_INPUT	0
#define XTELD_OUTPUT	1

#endif /* NO_NETWORK */

static int fin_fils;
static int pid_fils;
static int nb_services;
static fd_set a_lire;
static struct timeval timeout;
static time_t t_connexion;
static char buf[256], service[256], utilisateur[256];
static char flag_connexion;
static char parite;
static Boolean flag_serveur_local;
static int tuyau_in[2], tuyau_out[2];

/* Syslog or not syslog ? */
#ifdef USE_SYSLOG
void log_debug (fmt, p1, p2, p3, p4, p5, p6, p7)
char *fmt;
int  p1, p2, p3, p4, p5, p6, p7;
{
    char msg[256];

    sprintf (msg, fmt, p1, p2, p3, p4, p5, p6, p7);
    syslog(LOG_DEBUG, msg);
}

void log_err (s)
char *s;
{
    syslog(LOG_ERR, s);
}
#else
void log_debug (fmt, p1, p2, p3, p4, p5, p6, p7)
char *fmt;
int  p1, p2, p3, p4, p5, p6, p7;
{
    fprintf (fp_console, fmt, p1, p2, p3, p4, p5, p6, p7);
    fprintf (fp_console, "\n\r");
}
#endif /* USE_SYSLOG */

void demande_fin_fils()
{
#ifdef DEBUG
    log_debug ("Demande la fin du fils");
#endif
    fin_fils = 1;
}

/*
 * Transmet une erreur a XTEL 
 *	- chaine de caractere terminee par 0
 *	- errno associe
 */
void erreur_a_xtel (s, code_erreur)
char *s;
int code_erreur;
{
    char e = code_erreur;

    write (XTELD_OUTPUT, CHAINE_REPONSE_DEBUT_ERREUR, 1);
    write (XTELD_OUTPUT, s, strlen(s));
    write (XTELD_OUTPUT, "\0000", 1); 
    write (XTELD_OUTPUT, &e, 1);
    write (XTELD_OUTPUT, CHAINE_REPONSE_FIN_ERREUR, 1);
}

/* 
 * Teste si l'utilisateur courant a acces au service demande
 *
 *	1 si oui
 *	0 sinon
 */
int
service_autorise(indice_service) 
int indice_service;
{    char *pt;
     char autorisations[2048];

     if (definition_services[indice_service].autorisations[0]== '\000')
       return(1);

     strcpy(autorisations, definition_services[indice_service].autorisations);
     pt = strtok(autorisations, ":");
     while (pt != NULL) {
       if (strcmp (pt, utilisateur) == 0) {
           return(1);
       }
       pt = strtok(NULL, ":");
     }
     return(0);
}

/*
 * Fonction de deconnexion (appelee sur SIGCHLD)
 */
static void waitchild ()
{
    int r;

    while (wait (&r) > 0)
	;
}

void deconnexion ()
{
    int r;
    FILE *fplog;

#ifdef DEBUG
    log_debug ("Deconnecte !");
#endif

    flag_connexion = 0;

    if (!flag_serveur_local) {

	if (definition_lignes[numero_ligne].type_dialer != DIALER_MODEM) {

	    /*
	     * Envoi du code de connexion/fin puis de la sequence
	     * de raccrochage
	     */
#ifdef DEBUG
	    log_debug ("Raccrochage Minitel");
#endif
	    write (fd_modem, "\x13I\x1b\x39\x67", 5);
	}

	myundial (fd_modem);

    }
    else
	kill (pid_fils, SIGTERM);

    /* signal a XTEL la deconnexion */
    write (XTELD_OUTPUT, CHAINE_REPONSE_DECONNEXION, 1);

    /* supprime le fichier de log */
    sprintf (buf, "/tmp/.xtel-%s", utilisateur);
    unlink (buf);
	
    if ((fplog= fopen(FICHIER_LOG, "a")) != NULL) {
	long t= time(0), duree;
	char *at= ctime(&t);
	at[24]= '\000';

	duree = (t_connexion == 0 ? 0L : t-t_connexion);
	fprintf(fplog, "%s, %s deconnexion de : %s (%ld s sur %s)\n", at, utilisateur, service, duree, definition_lignes[numero_ligne].nom);
	fclose(fplog);
    }

    waitchild ();
}

/* Test de la mort subite de Xtel (errno == 2) en cours de connexion */
static void test_mort_subite ()
{
    if (errno == SIGINT && flag_connexion) {
	kill (pid_fils, SIGTERM);
	deconnexion ();
    }
}    

/* 
 * Connexion a un service 
 */
void appel_service (service_teletel)
char *service_teletel;
{
    char c, *device_associe = NULL, *numero_direct;
    FILE *fplog;
    register int i;

#ifdef DEBUG
    log_debug ("connexion au service %s utilisateur %s", service_teletel, utilisateur);
#endif

    signal (SIGTERM, demande_fin_fils);

    /* Est-ce un numero direct */
    numero_direct = strchr (service_teletel, ',');
	
    /* Nom du device associe au service */
    if (numero_direct) {
	*numero_direct++ = 0;
	device_associe = numero_direct;
    }
    else {
	for (i = 0 ; i != nb_services ; i++) {
	    if (strcmp (definition_services[i].nom_uucp, service_teletel) == 0)
		device_associe = definition_services[i].device;
	}
    }

    /* Service local par "pipe" */
    if (device_associe != NULL && strcmp (device_associe, "@pipe") == 0) {
	flag_serveur_local = True;

	if (pipe (tuyau_in) < 0) {
#ifdef USE_SYSLOG
	    log_err ("pipe: tuyau_in: %m");
#else
	    fprintf (fp_console, "pipe: tuyau_in: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */
	    exit (0);
	}

	if (pipe (tuyau_out) < 0) {
#ifdef USE_SYSLOG
	    log_err ("pipe: tuyau_out: %m");
#else
	    fprintf (fp_console, "pipe: tuyau_out: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */
	    exit (0);
	}

	if (!fork()) { /* fiston */
#ifdef DEBUG
	    log_debug ("le fiston = %d", getpid());
#endif
	    dup2 (tuyau_out[0], 0);
	    close (tuyau_out[0]);
	    dup2 (tuyau_in[1], 1);
	    close (tuyau_in[1]);

	    if (execlp (service_teletel, service_teletel, NULL) < 0) {
#ifdef USE_SYSLOG
		log_err ("execlp: %m");
#else
		fprintf (fp_console, "execlp: %s: %s\n", service_teletel, sys_errlist[errno]);
#endif /* USE_SYSLOG */
		exit (0);
	    }
	}
	else {
#ifdef DEBUG
	    log_debug ("le papa = %d", getpid());
#endif
	    fd_modem = tuyau_in[0];
	}
    }
    else { /* Connexion distante */
	/* connexion */
	if ((fd_modem = mydial(service_teletel, device_associe)) < 0) {
#ifdef DEBUG
	    log_debug ("meurt (erreur)");
#endif
	    exit (1);
	}
    }

    /* valide le signal de deconnexion */
    signal (SIGCHLD, deconnexion);

    /* Init masque select */
    FD_ZERO (&a_lire);	
    FD_SET (fd_modem, &a_lire);
	
#ifdef DEBUG
    log_debug ("Connecte !");
#endif
	
    flag_connexion = 1;	/* On est connecte ! */
	
    /* signale la connexion a XTEL */
    write (XTELD_OUTPUT, CHAINE_REPONSE_CONNEXION, 1);

    /*
     * On cree un processus qui lit le modem et ecrit sur le reseau.
     * On tue ce processus au bout de DELAI_DECONNEXION secondes sans activite 
     * (ce qui fait raccrocher le MODEM)
     */
    
    if ((pid_fils = fork()) == 0) { /* fils */
	int etat = 0;
	int ignore = 0;
	int code_fin = 1;

	fin_fils = 0;
	while (!fin_fils) {
	    int nread, size, i;
	    
	    timeout.tv_sec = (unsigned long)DELAI_DECONNEXION;

	    nread = select (32, &a_lire, NULL, NULL, (flag_serveur_local ? NULL : &timeout));

	    if (nread < 0 && errno == EINTR) {
		/* select() interrompu par le SIGTERM du parent */
#ifdef DEBUG
		log_debug ("select() interrompu par le SIGTERM du parent");
#endif
		continue;
	    }
	    
	    if (nread == 0 || !FD_ISSET (fd_modem, &a_lire)) {
		/* read = 0 (timeout) ==> deconnexion */
#ifdef DEBUG
		log_debug ("read = 0 (timeout) ==> deconnexion");
#endif
		code_fin = 2;
		break;
	    }
	    
	    size = read (fd_modem, buf, sizeof(buf));

	    if (size <= 0) {
#ifdef DEBUG
		log_debug ("size <= 0");
#endif
		code_fin = 3;
		break;
	    }
	    
	    for (i = 0; i < size; i++) {
		if (definition_lignes[numero_ligne].cs != CS8)
		    buf[i] &= 0x7f;
		
		if (definition_lignes[numero_ligne].type_dialer != DIALER_MODEM) {
		    /*
		     * Detection de la sequence SEP 53 signifiant
		     * la fin de la connexion
		     */
		    switch (etat) {
		      case 0:
			if (buf[i] == 0x13) {
			    /*
			     * Remplacer par des 0 toutes les sequences
			     * SEP xx venant du minitel pour eviter
			     * des echos parasites.
			     */
			    etat = 1;
			    ignore = 2;
			}
			break;
		      case 1:
			if (buf[i] == 0x53)
			    /* Sequence SEP 53 reconnue */
			    fin_fils = 1;
			etat = 0;
			break;
		    }
		    if (ignore) {
			ignore--;
		    }
		}
	    }

	    write (XTELD_OUTPUT, buf, size); /* ecrit sur la connexion XTEL */
	}

	/* Sortie du fils */
#ifdef DEBUG
	log_debug ("meurt, code = %d", code_fin);
#endif
	exit (0);
    }
    
    signal(SIGTERM, SIG_DFL);

    /* creation du fichier de log */
    sprintf (buf, "/tmp/.xtel-%s", utilisateur);
    if ((fplog = fopen (buf, "w"))) {
#ifdef DEBUG
	log_debug ("Creation du fichier de log %s", buf);
#endif
	chmod (buf, 0644);
	if (!flag_serveur_local) 
	    fprintf (fplog, "LIGNE = %s\n", definition_lignes[numero_ligne].nom);
	fprintf (fplog, "PROCESSUS = %d,%d\n", getpid(), pid_fils);
	fprintf (fplog, "SERVICE = %s\n", service);
	fclose (fplog);
    }
    
    if ((fplog= fopen(FICHIER_LOG, "a")) != NULL) {
	char *at;
	
	t_connexion = time(0);
	at = ctime(&t_connexion);
	at[24]= '\000';
	
	if (flag_serveur_local)
	    fprintf(fplog, "%s, %s appel de : %s (local)\n", at, utilisateur, service);
	else
	    fprintf(fplog, "%s, %s appel de : %s sur %s\n", at, utilisateur, service, definition_lignes[numero_ligne].nom);
	fclose(fplog);
    }
#ifdef NO_TERMIO
    parite = definition_lignes[numero_ligne].parity;
#endif
}

int lire_chaine(ch)
char *ch;
{
    int ret;
    unsigned char l;

    do {
	ret = read (XTELD_INPUT, &l, 1);
	if (ret < 0) goto err;
    } while (ret != 1);

    ch[l] = 0;

    while (l) {
	ret = read (XTELD_INPUT, ch, l);
	if (ret < 0) goto err;
	l -= ret;
    }

    return 0;

err:
#ifdef USE_SYSLOG
    log_err ("read: %m");
#else
    fprintf (fp_console, "read: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */
    return -1;
}

/*
 *	Partie principale 
 */
main (ac, av)
int ac;
char **av;
{
    unsigned char c, l;
    int ret;
    char fin_connexion = 0;
#ifdef NO_NETWORK
    int sock_ecoute, retry;
    static struct sockaddr_un unaddr;
    register int i;
    struct stat statb;
#endif /* NO_NETWORK */
    int indice_service = 0, nread;

#ifdef USE_SYSLOG
    openlog("xteld", LOG_PID | LOG_CONS, LOG_DAEMON);
#else
    if ((fp_console = fopen ("/dev/console", "w")) == NULL) {
        perror ("/dev/console");
        exit (1);
    }
#endif /* USE_SYSLOG */

    if ((nb_lignes = lecture_configuration_lignes ()) <= 0) {
	exit (1);
    }

    if ((nb_services = lecture_services ()) < 0) {
	exit (1);
    }

#ifdef NO_NETWORK

    /* Test de l'existence de /tmp/.xtel */
    if (stat (XTEL_UNIX_PATH, &statb) == 0) {
	if (unlink (XTEL_UNIX_PATH) < 0) {
#ifdef USE_SYSLOG
	    log_err ("unlink: %m");
#else
	    fprintf (fp_console, "unlink: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */
	    exit (1);
	}
    }

    /* Je deviens un petit demon... */
    if (fork())
	exit (0);

    /*
     * Detachement du tty
     */

#if defined(SYSV) || defined(SVR4)
    setpgrp ();
#else
    setpgrp (0, getpid());
#endif

    close (0); 
    close (1);
    close (2);

#ifndef SYSV386
#if defined(SYSV) || defined(SVR4) || defined(linux)
    if ((i = open ("/dev/tty", O_RDWR | O_NOCTTY)) >= 0) {
#else
    if ((i = open ("/dev/tty", O_RDWR)) >= 0) {	
	(void) ioctl (i, TIOCNOTTY, (char *) 0);    /* detachement, BSD style */
#endif /* SYSV || SVR4 */
	(void) close (i);
    }
#endif /* !SYSV386 */

    /*
     * Creation/configuration de la socket d'ecoute
     */

    if ((sock_ecoute = socket (AF_UNIX, SOCK_STREAM, 0))  < 0) {
#ifdef USE_SYSLOG
	log_err("socket: %m");
#else
	fprintf (fp_console, "socket: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */
	exit (1);
    }

    unaddr.sun_family = AF_UNIX;
    strcpy (unaddr.sun_path, XTEL_UNIX_PATH);

    if (bind (sock_ecoute, (struct sockaddr *)&unaddr, sizeof(unaddr)) < 0) {
#ifdef USE_SYSLOG
	log_err ("bind: %m");
#else
	fprintf (fp_console, "bind: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */
	exit (1);
    }

    /* Ouvre le service */
    if (listen (sock_ecoute, 5) < 0) {
#ifdef USE_SYSLOG
      log_err ("listen: %m");
#else
      fprintf (fp_console, "listen: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */

      exit (1);
    }

    /*
     * Attente de connexion...
     */


    for (;;) {

      /* Pour eviter les zombies */
      signal (SIGCHLD, waitchild);

#ifdef DEBUG
	log_debug ("Attente de connexion...");
#endif

	for (retry = 10 ; ; retry--) {
	    if ((sock_service = accept (sock_ecoute, (struct sockaddr *)NULL, (int *)NULL)) > 0) {
		break;
	    }
	    else if (!retry) {
#ifdef USE_SYSLOG
		log_err ("accept: %m");
#else
		fprintf (fp_console, "accept: %s\n", sys_errlist[errno]);
#endif /* USE_SYSLOG */
		exit (1);
	    }
	}
	
	/*
	 * Cree le processus de service (fils)
	 */

	if (!fork()) {

#endif /* NO_NETWORK */

#ifdef DEBUG
	    log_debug ("Connexion XTEL...");
#endif

	    /* Lecture du nom d'utilisateur */

	    if (lire_chaine(utilisateur) < 0)
		goto fin_xteld;

#ifdef DEBUG
	    log_debug ("utilisateur = %s", utilisateur);
#endif

	    /* lecture connexion XTEL */
	    while (!fin_connexion && read (XTELD_INPUT, &c, 1) == 1) {

		if (flag_connexion) {
		    if (c == VALEUR_COMMANDE_FIN) {
#ifdef DEBUG
			log_debug ("tue le fils");
#endif		      
			kill (pid_fils, SIGTERM);
		    }
		    else {
#ifdef NO_TERMIO
			if (parite != SANS) {
			    register int p;
			    /* Calcul de parite... */			
			    p = (c & 0x0f) ^ (c >> 4);
			    p = (p & 3) ^ (p >> 2);      
			    p = (p & 1) ^ (p >> 1);
			    if (parite == IMPAIR)
				p = ~p;
			    c = (c & 0x7f) | (p << 7);
			}
#endif /* NO_TERMIO */
			write ((flag_serveur_local ? tuyau_out[1] : fd_modem), &c, 1);
		    }
		}
		else {
		    switch (c) {
			
		      case VALEUR_COMMANDE_CONNEXION_M1 :

			appel_service (NULL);
			break;

		      case VALEUR_COMMANDE_DEMANDE_CONNEXION :
			  
			/* lecture du service */
			if (lire_chaine(service) < 0)
			    fin_connexion++;
			else
			    /* connexion */
			    appel_service (service);
			  
			break;
			  
		      case VALEUR_COMMANDE_SERVICE_SUIVANT :
			    
			if ((indice_service == nb_services) || flag_m1)
			    write (XTELD_OUTPUT, CHAINE_REPONSE_PLUS_DE_SERVICE, 1);
			else {
			    if (service_autorise (indice_service)) {
				c = strlen (definition_services[indice_service].nom_service);
				write (XTELD_OUTPUT, &c, 1);
				write (XTELD_OUTPUT, definition_services[indice_service].nom_service, c);
#ifdef DEBUG
				log_debug ("service: %s", definition_services[indice_service].nom_service);
#endif		      
			    }
			    else { /* service interdit */
				c = 0;
				write (XTELD_OUTPUT, &c, 1);
				indice_service++;
			    }
			}
			  
			break;
			  
		      case VALEUR_COMMANDE_NOM_UUCP :
			    
			c = strlen (definition_services[indice_service].nom_uucp);
			write (XTELD_OUTPUT, &c, 1);
			write (XTELD_OUTPUT, definition_services[indice_service].nom_uucp, c);
#ifdef DEBUG
			log_debug ("%s", definition_services[indice_service].nom_uucp);
#endif		      
			indice_service++;
			  
			break;
			  
		      default :
			      
			break;
		    }
		}
	    }

fin_xteld:
#ifdef NO_NETWORK

	    /* Si xtel a ete tue sauvagement, tue le fils */
	    test_mort_subite ();

#ifdef DEBUG
	    log_debug ("Fin du service");
#endif
	    /* Fin du service */
	    exit (0);

	} /* if !fork */

#ifdef DEBUG
	log_debug ("Ferme la socket de service");
#endif
	close (sock_service);
    }

#else

#ifdef DEBUG
    log_debug ("%d meurt (OK), errno = %d", getpid(), errno);
#endif

    /* Si xtel a ete tue sauvagement, tue le fils */
    test_mort_subite ();

#endif /* NO_NETWORK */

#ifndef USE_SYSLOG
    fclose (fp_console);
#endif /* NO_NETWORK */
}
