.TH cmiptcl 1 "4 April 1995" "tkined" "tkined Reference Manual"

.SH NAME
cmiptcl \- a Tcl interface to the CMIP protocol


.SH CMIP INTERFACE
The Tcl CMIP interface to the Common Management Information Protocol
enables Tcl interpreters
to connect to a remote OSI management agent (e.g. OIM-SMA) and to use
the Common Management Information Services (CMIS).

.TP
.B cmip connect \fIagent\fR \fIhost\fR
Connect to the remote \fIagent\fR (e.g. OIM-SMA) of a management
information base (MIB) running
on \fIhost\fR (e.g. foobar, NOT foobar.hmbl.grmpf.it).
This command returns a cmip handle, that is the new created
command for this association. The cmip handle starts with "cmip" and ends
with a number, e.g. cmip42.

.TP
.B cmip wait
Waits till all asynchronous requests for all associations are
answered. As long as there are outstanding asynchronous requests, it
allows other Tk_Events to take place.

.TP
.B cmip info
Returns a list of all cmip handles that have been created using the cmip
connect command.

.TP
.B cmip# get \fIclass\fR \fIinstance\fR ?\fIoptions\fR?
Retrieve management information on this association (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object that will be returned,
if not modified by the options.

.RS 5
The available 
.I options
for get are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -attributes \fIattributes\fR
The \fIattributes\fR is a list, that may contain the attributes to ask
for. {} for no attributes. Default is all attributes. Each Element of
the list may be a list, but only the first element is used as an
attribute to look for (so e.g. the result of an get or set request may
be used as the input).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.RE

.TP
.B cmip# set \fIclass\fR \fIinstance\fR \fIattributes\fR ?\fIoptions\fR?
Set management information at the agent (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object on which
\fIattributes\fR will be set,
if not modified by the options. The \fIattributes\fR is a list whose
elements are a list
of attribute-type, attribute-value and an \fImodify-operation\fR,. The
possible \fImodify-operations\fR are replace, addValue, removeValue
and setToDefault. If no \fImodify-operation\fR is given, than replace
is used.

.RS 5
The available 
.I options
for set are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.TP
.B -nonconfirmed
The set-option may be used as a confirmed or non-confirmed service.
Default is to use the confirmed service, but if you want to use the
unconfirmed service just use -nonconfirmed as one of the options.

.RE

.TP
.B cmip# action \fIclass\fR \fIinstance\fR \fIaction\fR ?\fIoptions\fR?
Perform an action on management information at the agent (cmip#).
The \fIclass\fR and the \fIinstance\fR define the base managed object on
which the \fIaction\fR will be performed,
if not modified by the options. The \fIaction\fR is a list containing the
action-type and an optional action-value.

.RS 5
The available 
.I options
for set are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.TP
.B -nonconfirmed
The action-option may be used as a confirmed or non-confirmed service.
Default is to use the confirmed service, but if you want to use the
unconfirmed service just use -nonconfirmed as one of the options.

.RE

.TP
.B cmip# create \fIclass\fR ?\fIoptions\fR?
Create a managed object (MO) at the agent (cmip#).

.RS 5
The available 
.I options
for create are:
.RE

.RS 
.TP 10
.B -instance \fIinstance\fR | -superior \fIsuperiorInst\fR
The \fIinstance\fR specifies the object instance name, alternatively
the \fIsuperiorInst\fR specifies the object that is the parent in the
containment tree

.TP
.B -reference \fIreferenceInst\fR
The \fIreferenceInst\fR specifies a reference object instance to be used for
initial attribute values to be copied.

.TP
.B -attributes \fIattributes\fR
The \fIattributes\fR specifies initial attribute values, it contains a
list of attribute-type and attribute-value pairs.

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is complete.
.RE

.TP
.B cmip# delete \fIclass\fR \fIinstance\fR ?\fIoptions\fR?
Delete managed object(s) at the agent (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object which
will be deleted,
if not modified by the options.

.RS 5
The available 
.I options
for delete are:
.RE

.RS 
.TP 10
.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is complete.

.RE

.TP
.B cmip# cancelGet \fIrequestHandle\fR ?-callback callback?
Cancel the outstanding asynchronous GET request at the agent (cmip#),
given by \fIrequestHandle\fR. If a callback is given, it will be executed,
if the result of the asynchronous request is complete.

.TP
.B cmip# eventSink ?-callback callback?
Initialize a callback for event reports. If no callback is given, this
will wait for Eventreports till eternity and show event reports
emitted by MOs of the agent.

.TP
.B cmip# requests
Returns a list of all request handles, so the outstanding asynchronous
requests.

.TP
.B cmip# wait
Waits till all asynchronous requests for this association (cmip#) are
queued. As long as there are outstanding asynchronous requests, it
allows other Tk_Events to take place.

.TP
.B cmip# release
Release the association and delete the cmip# command and all structures
related to it. (The release is done by M_TerminateReq())

.TP
.B cmip# abort
Aborts the association abrupt and delete the cmip# command and all structures
related to it. (The abortion is done by M_AbortReq())

.SH AUTHORS
The Tcl interface to the OSIMIS cmip library was written by
M. Kernchen <kernchen@ibr.cs.tu-bs.de>.
