/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  romlib.h
 * Purpose: Header file for interfacing with the C library functions
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Special characters from ASCII character set:
 */
#define CHR_BS		'\010'
#define CHR_LF		'\012'
#define CHR_FF		'\014'
#define CHR_CR		'\015'
#define CHR_STOP	'\023'
#define CHR_ESC		'\033'



/*
 **************************************************************************
 *
 * I/O functions:
 */
extern int getkey(int timeout);		/* wait for keyboard input	*/
extern int chkkey(void);		/* check if a key pressed	*/
extern void printf(char *format, ...);	/* print formatted string	*/



/*
 **************************************************************************
 *
 * Memory management functions:
 */
extern void *malloc(int size);		/* allocate memory		*/
extern void free(void *mem);		/* free memory			*/
extern int memavail(void);		/* get available memory size	*/



/*
 **************************************************************************
 *
 * Time related functions:
 */
extern void set_timeout(int ticks);	/* set number of timeout ticks	*/
extern int chk_timeout(void);		/* check if timeout reached	*/
extern unsigned long get_ticks(void);	/* get current timer ticks	*/



/*
 **************************************************************************
 *
 * String and memory handling functions:
 */
extern void memcpy(void *b1, void *b2, int length);
extern int  memcmp(void *b1, void *b2, int length);
extern void memset(void *b, int c, int length);



/*
 **************************************************************************
 *
 * Miscellaneous routines:
 */
extern void fatal(void);			/* terminate boot rom	*/
extern short int random(void);			/* get random value	*/
extern unsigned long far2long(void far *ptr);	/* convert far to long	*/

