/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  general.h
 * Purpose: Header file with general declarations
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Define boolean values:
 */
#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif



/*
 **************************************************************************
 *
 * Define NULL pointer:
 */
#ifndef NULL
#define NULL	(void *)0		/* near pointer		*/
#endif
#ifndef UNIX
#ifndef FNULL
#define FNULL	(void far *)0		/* far pointer		*/
#endif
#endif



/*
 **************************************************************************
 *
 * Macros to allow usage of far pointers in the source code
 */
#ifndef UNIX
#define FP_OFF(fp)	((unsigned)(fp))
#define FP_SEG(fp)	((unsigned)((unsigned long)(fp) >> 16))
#define MK_FP(seg,ofs)	((void far *) \
		(((unsigned long)(seg) << 16) | (unsigned long)(ofs)))
#endif

