.\" $Revision: 6.21 $
.TH PXSPREAD 1 LOCAL
.SH NAME
pxspread \- prepare xspread files
.SH SYNOPSIS
.B pxspread
[
.I -fhkLPrSv
]
[
.I -s cell
]
[
.I -R n
]
[
.I -C n
]
[
.I -n n
]
[
.I -d c
]

.SH DESCRIPTION
.I Pxspread
is used to prepare data for input to the spread sheet calculator
.I xspread(1).
It accepts normal ascii data on standard input.  Standard output
is a
.I xspread
file.
With no options, 
.I pxspread
starts the spread sheet in cell A0.  Strings are right justified.
All data on a line is entered on the same row; new input lines
cause the output row number to increment by one.  The default delimiters
are tab and space.  The column formats are set to one larger
than the number of columns required to hold the largest value
in the column.

Options:

.IP "\-C n"
Increment by
.I n 
on each new output column.

.IP "\-d c"
Use the single character
.I c
as the delimiter between input fields.

.IP "\-f"
Omit column width calculations.  This option is for preparing
data to be merged with an existing spreadsheet.  If the option is not
specified, the column widths calculated for the data read by
.I pxspread
will override those already set in the existing spreadsheet.

.IP "\-h"
Print a short usage/help.

.IP "\-k"
Keep all delimiters.  This option causes the output cell to change on
each new delimiter encountered in the input stream.   The default
action is to condense multiple delimters to one, so that the cell only
changes once per input data item.

.IP "\-L"
Left justify strings.

.IP "\-n n"
Output 
.I n
rows before advancing to the next column.  This option is used when
the input is arranged in a single column and the spread sheet is to
have multiple columns, each of which is to be length
.I n.

.IP "\-P"
Plain numbers only.
A field is a number only when there is no imbeded [-+eE].

.IP "\-r"
Output the data by row first then column.  For input consisting of a single
column, this
option will result in output of one row with multiple columns
instead of a single
column spread sheet.

.IP "\-R n"
Increment by
.I n 
on each new output row.

.IP "\-s cell"
Start the top left corner of the spread sheet in 
.I cell.
For example, 
.I "-s B33"
will arrange the output data so that the
spread sheet starts in column B, row 33.

.IP "\-S"
All numbers are strings.

.IP "\-v"
Print the version of
pxspread

.SH SEE ALSO
xspread(1)

.SH AUTHOR

Robert Bond
