.TH gk_userlist "1 May 1995" "GroupKit"
.SH NAME
gk_userlist \- display a list of users
.SH SYNOPSIS
.TP
\fBgk_userlist \fIpathname \fR?\fIoptions\fR?

.SH DESCRIPTION

This widget is used to display a list of users inside a widget.
Facilities exist for adding or deleting users from the list,
and users are represented by an arbitrary Tk window, supplied by
the caller.
The widget is used internally by the gk_participants(n) family 
of widgets.

.SH WIDGET COMMAND

The \fBgk_userlist\fR command creates a new Tcl command whose name
is \fIpathname\fR.  This command may be used to invoke various
operations on the widget.  The following commands are possible:
.TP
\fIpathname \fBadduser \fIusernum win\fR
Add a user to the list.  The user is (uniquely) identified by
\fIusernum\fR, and is represented in the list by \fIwin\fR, an
arbitrary Tk window passed in by the caller.

.TP
\fIpathname \fBdeluser \fIusernum\fR
Delete a user, identified by \fIusernum\fR, from the list.

.TP
\fIpathname \fBcomponent \fIidentifier \fR?\fIargs...\fR?
Return a subcomponent of the widget.  Currently, \fIidentifier\fR
can only have the value "user", in which case it must be followed
by an argument specifying the usernum of a user in the list.  This
will then return the pathname of the window representing the user.

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.

.SH SEE ALSO
.PP
gk_participants(n)

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca) and Mark Roseman
(roseman@cpsc.ucalgary.ca)
