.TH gk_event n "8 Dec 1994" "GroupKit"
.SH NAME
gk_on, gk_event, gk_postEvent \- 
generating and dealing with events
.SH SYNOPSIS
.TP 
\fBgk_postEvent\fI event\fR
.TP
\fBgk_on \fIpattern action\fR
.TP
\fBgk_event \fIattribute\fR

.SH DESCRIPTION
These commands provide a way to generate and receive events, which
are used as a notification mechanism throughout GroupKit.  Events
consist of a set of attribute/value pairs.  All events include the
\fBtype\fR attribute which identifies it; other attributes depend
on this type.

Applications arrange to be notified when an event occurs by specifying
a trigger.  Triggers consist of a pattern and an action; the pattern
is a Tcl expression which determines if the application is interested
in the event, and the action is a Tcl expression that is executed if
the pattern returns true.

.SH COMMANDS

.TP 
\fBgk_postEvent\fI event\fR
Post an event specified by the keyed list \fIevent\fR.  This must
include an attribute \fBtype\fR which specifies the type of the 
event; other attributes are dependent on this type.  This will
invoke all existing triggers (see \fBgk_on\fR below).

.TP
\fBgk_on \fIpattern action\fR
Create a new event trigger.  When an event is generated (see 
\fBgk_postEvent\fR above), the Tcl code specified in \fIpattern\fR
is evaluated.  If the result is a true value, the Tcl code
in \fIaction\fR is executed.

.TP
\fBgk_event \fIattribute\fR
Return the value associated with \fIattribute\fR of the current
event.  This is commonly used in triggers.  It is only valid to
call this during the "scope" of an event.

.SH DEBUGGING
If the "debugevents" key of the "userprefs" environment is set to 
1 (i.e. in the user's .groupkitrc file), the contents of each
generated event will be displayed on stdout.

.SH NOTE
In the future, this mechanism will likely change somewhat to be more
similar to Tk's bind mechanism.  In particular, the concept of 
pattern will likely be replaced by just the event type, leaving
further decisions on whether to process the event to be handled
in the event handler (action) itself.  Additionally, certain types
of events (such as for environments) will be bound to particular 
objects, rather than all events being global in scope.  

.SH "SEE ALSO"
.PP
gk_newenv(n), gk_notifier(n)

.SH AUTHOR
Mark Roseman (roseman@cpsc.ucalgary.ca)
