.TH gk_viewport n "14 August 1995" "GroupKit"
.SH NAME
gk_choice \- Create a window with choices.
.SH SYNOPSIS
.TP 
\fBgk_choice\fI pathname \fR?\fIoptions\fR?

.SH "STANDARD OPTIONS"
.nf
.ta 4c 8c 12c
.VS
\fBactiveBackground	disabledForeground	highlightThickness	
\fBactiveForeground	font		image	textVariable
\fBanchor		foreground	justify	underline
\fBbackground	height	padX	width
\fBbitmap	highlightBacground	padY	wrapLength
\fBborderWidth	highlightColor	relief
\fBcursor	highlightThickness	takeFocus
.VE		
.fi

See the ``options'' manual entry for details on the standard options.
.LP
All of the options, except for \fB-choices\fR, \fB-msg\fR, and \fB-title\fR,
by default are applied to all of the buttons.  To see how to access the
individual buttons see the Widget Command section.


.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.nf
Name:	\fBchoices\fR
Class:	\fBChoices\fR
Command-Line Switch:	\fB\-choices\fR
.fi
.IP
Specifies what choices are to be given to the user.  This is a list
of \fItext-command\fR pairs, where the text is the \fItext\fR that is to 
appear on the button and \fIcommand\fR is the command that is executed
when the button is invoked.
.LP

.ta 4c
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
This command is inherited from the Tk Button widget.  By changing this
value all of the buttons are given the same command.  See the Tk Button
widget for more details.
.LP

.ta 4c
.nf
Name:	\fBmessage\fR
Class:	\fBMessage\fR
Command-Line Switch:	\fB\-msg\fR
.fi
.IP
A command to be executed in order to create a message above the set of
buttons.  The top most window pathname for the widget is appended to the 
list of arguments for the command. This  pathname should be used when 
creating the widgets to be used in the message portion of the widget.
.LP

.ta 4c
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
This option is inherited from the Tk Button widget.  By changing this
option the state of all the buttons is changed.  See the Tk Button widget
for more details.
.IP
.LP

.ta 4c
.nf
Name:	\fBtitle\fR
Class:	\fBTitle\fR
Command-Line Switch:	\fB\-title\fR
.fi
.IP
The option specifies the title that appears on the window.
.LP

.SH DESCRIPTION
This widget creates a toplevel window with 0 or more buttons and a
message portion.  The buttons appear horizontally along the bottom
of the widget and if there is a message it is placed above the buttons.

The best way to describe this widget is that it is a pop-up window
much like those in other windowing systems.

.SH "WIDGET COMMAND"
The \fBgk_choice\fR command creates a new Tcl command whose name is
\fIpathname\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.IP
\fIpathname option \fR?\fIarg arg ...\fR?
.LP
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for gk_choice widgets:
.TP
\fIpathname \fBcget \fIoption\fR
Returns the current value of the configuration option given by 
\fIoption\fR.  \fIOption\fR may have any of the values accepted 
by the gk_choice command.
.TP
\fIpathname \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathname\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBgk_choice\fR
command.
.TP
\fIpathname \fBcomponents\fR
Returns a list of compnent widgets.  In particular the list returned 
is the pathnames of all the buttons that appear at the bottom of the
widget.  The pathname for the leftmost button corresponds to the 0 
index of this list and the rightmost button is the last entry in the
list.
.TP
\fIpathname \fBflash\fR
This command causes all of the buttons to flash. See the Tk Button
widget for more details on the flash command.
.TP
\fIpathname \fBinvoke\fR
This causes the commands to be invoked for each of the buttons.
See the Tk Button widget for more details on the flash command.
.TP

.SH "DEFAULT BINDINGS"
The Buttons have the default button bindings - see Tk Button widget
for more information.  All of the buttons will destroy the toplevel
widget when they are invoked.

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.  

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)


