.TH gk_about n "22 Dec 1994" "GroupKit"
.SH NAME
gk_about \- Display an application about box
.SH SYNOPSIS
.TP 
\fBgk_about\fI pathname \fR?\fIoptions\fR?

.SH "STANDARD OPTIONS"
.nf
.ta 4c 8c 12c
.VS
\fBbackground	borderwidth	font	relief
\fBbitmap	cursor	geometry
.VE
.fi

See the ``options'' manual entry for details on the standard options.

.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.nf
Name:	\fBbitmapBg\fR
Class:	\fBBitmapBg\fR
Command-Line Switch:	\fB\-bitmapBg\fR
.fi
.IP
Specifies the background color of the bitmap.
.LP

.ta 4c
.nf
Name:	\fBbitmapFg\fR
Class:	\fBBitmapFg\fR
Command-Line Switch:	\fB\-bitmapFg\fR
.fi
.IP
Specifies the foreground color of the bitmap.
.LP

.ta 4c
.nf
Name:	\fBinfo\fR
Class:	\fBInfo\fR
Command-Line Switch:	\fB\-info\fR
.fi
.IP
Specifies the textual information to be displayed, not
including the software version.  If this options is not
specified then some default text is used.
.LP

.ta 4c
.nf
Name:	\fBinfoWidth\fR
Class:	\fBInfoWidth\fR
Command-Line Switch:	\fB\-infoWidth\fR
.fi
.IP
This specifies the width of the information frame.  The information
frame contains the bitmap as well as the textual information.
This option accepts any form that is acceptable to Tk_GetPixels.
If this options is not specified then it defaults to "300 pixels".
.LP

.ta 4c
.nf
Name:	\fBtitle\fR
Class:	\fTitle\fR
Command-Line Switch:	\fB\-title\fR
.fi
.IP
Specifies the textual title to be displayed at the top of the window.
If not specified it defaults to "GroupKit".
.LP

.ta 4c
.nf
Name:	\fBversion\fR
Class:	\fBVersion\fR
Command-Line Switch:	\fB\-version\fR
.fi
.IP
Specifies the software version and release date.
.LP

.ta 4c
.nf
Name:	\fBversionWidth\fR
Class:	\fBVersionWidth\fR
Command-Line Switch:	\fB\-versionWidth\fR
.fi
.IP
Specifies the width of the message which contains the version
information.  The value may have any of the forms acceptable to
Tk_GetPixels.  If not specified, it defaults to 200 pixels.
.LP

.SH DESCRIPTION
This widget is a top-level window that contains text that 
describes GroupKit i.e. it's version number, authors, and
other useful information.  It is a combination widget; it contains
a number of standard Tk widgets (label  message button).  These
various components can be accessed through the appropriate commands
(See the Widget Command section).

.SH "WIDGET COMMAND"
The \fBgk_about\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.IP
\fIpathName option \fR?\fIarg arg ...\fR?
.LP
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for gk_about widgets:
.TP
\fIpathName \fBbitmap\fR
Return the path name of the label containing the widget's bitmap.
.TP
\fIpathName \fBbutton\fR
Return the path name of the button at the bottom of the widget.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBgk_about\fR
command.
.TP
\fIpathName \fBinfo\fR
Return the path name of the message which contains the textual information
about the program.
.TP
\fIpathName \fBtitle\fR
Return the path name of the label containing the program's title.
.TP
\fIpathName \fBversion\fR
Return the path name of the message containing the program's version
information.

.SH "DEFAULT BINDINGS"
There are no default bindings for the widget.

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)
