char tcl_ports[] = "\
#\n\
#    This file is part of tk707.\n\
#\n\
#    Copyright (C) 2000, 2001, 2002, 2003, 2004 Chris Willing and Pierre Saramito \n\
#\n\
#    tk707 is free software; you can redistribute it and/or modify\n\
#    it under the terms of the GNU General Public License as published by\n\
#    the Free Software Foundation; either version 2 of the License, or\n\
#    (at your option) any later version.\n\
#\n\
#    Foobar is distributed in the hope that it will be useful,\n\
#    but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
#    GNU General Public License for more details.\n\
#\n\
#    You should have received a copy of the GNU General Public License\n\
#    along with Foobar; if not, write to the Free Software\n\
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n\
#\n\
# -----------------------------------------------------------------------------\n\
#	File ports.tcl\n\
#	GUI for selection of ALSA port.\n\
# -----------------------------------------------------------------------------\n\
\n\
proc port_setup {} {\n\
	global tcl_rcFileName\n\
	global ports\n\
	global iolists\n\
	global font12\n\
	global normal_r_14\n\
\n\
	set ports .setup\n\
	toplevel $ports\n\
	wm title $ports \"TK-707 ALSA port setup\"\n\
\n\
	set howto .setup.h\n\
	set howtotext $howto.text\n\
	set howtoscroll $howto.scroll\n\
	frame $howto ;#-relief groove -borderwidth 2\n\
	canvas $howtotext -yscrollcommand \"$howtoscroll set\" -width 13.5c -height 5c\n\
	scrollbar $howtoscroll -command \"$howtotext yview\" -width 0.4c\n\
	pack $howtoscroll -side right -fill y\n\
	pack $howtotext\n\
	pack $howto\n\
\n\
	$howtotext create text 0.2c 0.2c -anchor nw -font *-${normal_r_14}-* -text	\\\n\
\"Double click on one of Output Ports to make it the Selected Output.\\n\n\
The SAVE button will save the setting in ~/.tk707rc so that this\n\
selection dialogue won't appear next time TK-707 is started.\\n\n\
The OK button will close this dialogue and allow TK-707 to start\n\
using the selected port. If the current setting hasn't been SAVEd\n\
then this dialogue will appear again next time TK-707 is run.\n\
If no port has been selected, TK707 will not start.\\n\n\
Input Port selection is for future use and currently has no effect.\\n\n\
When this selection dialogue is raised from the File->Ports menu,\n\
a selection can be SAVEd but ports cannot be changed while\n\
TK-707 is running (yet).\"\n\
\n\
	set iolists $ports.l\n\
	canvas $iolists -width 14c -height 8c -relief groove -borderwidth 2\n\
	pack $iolists\n\
	set	olist $iolists.ol\n\
	set	ilist $iolists.il\n\
	set oselect $iolists.op\n\
	set iselect $iolists.ip\n\
\n\
        scrollbar $iolists.os -command \"$olist yview\"\n\
        scrollbar $iolists.is -command \"$ilist yview\"\n\
        listbox $olist -font *-${normal_r_14}-* -width 26 -height 10 -selectmode browse -exportselection 1 -yscroll \"$iolists.os set\"\n\
	listbox $ilist -font *-${normal_r_14}-* -width 26 -height 10 -selectmode browse -exportselection 1 -yscroll \"$iolists.is set\"\n\
\n\
	label $oselect -width 28 -height 1 -relief sunken -borderwidth 2\n\
	label $iselect -width 28 -height 1 -relief sunken -borderwidth 2\n\
\n\
\n\
	$iolists create text 2c 0.5c -font *-${normal_r_14}-* -text \"Input Ports\" -anchor nw\n\
	$iolists create text 9c 0.5c -font *-${normal_r_14}-* -text \"Output Ports\" -anchor nw\n\
        $iolists create window 0c 1.5c -height 4c -window $iolists.is -anchor nw\n\
        $iolists create window 0.5c 1.5c -height 4c -window $ilist -anchor nw\n\
        $iolists create window 7c 1.5c -height 4c -window $iolists.os -anchor nw\n\
        $iolists create window 7.5c 1.5c -height 4c -window $olist -anchor nw\n\
	$iolists create window 0.2c 6c -window $iselect -anchor nw\n\
	$iolists create window 7.05c 6c -window $oselect -anchor nw\n\
	$iolists create text 2c 7c -font *-${normal_r_14}-* -text \"Selected Input\" -anchor nw\n\
	$iolists create text 9c 7c -font *-${normal_r_14}-* -text \"Selected Output\" -anchor nw\n\
\n\
	# Get list of output ports\n\
	set oportlist [tk7_port_list 1]\n\
	foreach i $oportlist {\n\
		$olist insert end $i\n\
	}\n\
	# Get list of input ports\n\
	set iportlist [tk7_port_list 0]\n\
	foreach i $iportlist {\n\
		$ilist insert end $i\n\
	}\n\
	bind .setup.l.il <Double-1> {\n\
		$iolists.ip configure -font *-${normal_r_14}-* -text [selection get]\n\
	}\n\
	bind $olist <Double-1> {\n\
		$iolists.op configure -font *-${normal_r_14}-* -text [selection get]\n\
	}\n\
	set portacts $ports.pa\n\
	canvas $portacts -width 14c -height 1.5c\n\
	pack $portacts\n\
\n\
	button $portacts.c -font *-${normal_r_14}-* -text CANCEL -width 6 -command {\n\
		if {! [tk7_port_setcheck]} {\n\
			puts \"NO PORTS SET\"\n\
			destroy .\n\
			exit\n\
		} else {\n\
			destroy $ports\n\
		}\n\
	}\n\
	button $portacts.s -font *-${normal_r_14}-* -text SAVE -width 6 -command {\n\
		set oplist [.setup.l.op configure -text]\n\
		# puts \"XX${oplist}XX\"\n\
		if {[llength $oplist] != 5} {\n\
			puts nothing\n\
		} else {\n\
			if {[llength [lindex $oplist 4]] > 0} {\n\
				set op [lindex [lindex $oplist 4] 0]\n\
				set oc [lindex [lindex $oplist 4] 1]\n\
				set tkxox(ALSA_OUTPORT) \"${op}:${oc}\"\n\
				# Save selection\n\
				set OPstr [format \"set tkxox(ALSA_OUTPORT) %d:%d\" $op $oc]\n\
				set f [open $tcl_rcFileName w]\n\
				seek $f  0 end\n\
				puts $f $OPstr\n\
				close $f\n\
				destroy $ports\n\
			}\n\
		}\n\
	}\n\
	button $portacts.b -font *-${normal_r_14}-* -text OK -width 6 -command {\n\
		set oplist [.setup.l.op configure -text]\n\
		if {[llength $oplist] != 5} {\n\
			puts nothing\n\
		} else {\n\
			if {[llength [lindex $oplist 4]] > 0} {\n\
				set op [lindex [lindex $oplist 4] 0]\n\
				set oc [lindex [lindex $oplist 4] 1]\n\
				set tkxox(ALSA_OUTPORT) \"${op}:${oc}\"\n\
			}\n\
		}\n\
		if {! [tk7_port_setcheck]} {\n\
			#puts \"NO PORTS SET\"\n\
			destroy .\n\
			exit\n\
		} else {\n\
			destroy $ports\n\
		}\n\
	}\n\
	$portacts create window 3c 0.75c -window  $portacts.c\n\
	$portacts create window 7c 0.75c -window  $portacts.s\n\
	$portacts create window 11c 0.75c -window  $portacts.b\n\
\n\
	grab set $ports\n\
	tkwait window $portacts\n\
}\n\
";
